<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');

/**
 * Title sublabel class
 * @package 	Content
 * @subpackage  Text/Title
 * @version 	1.0.0
 * @since       1.0.0
 */
class PartSublabel{

    /**
     * @var PartFont $font
     */
    public $font;
    
    /**
     * @var String $position
     */
    public $position;

    /**
     * @var String $trigger
     */
    public $trigger;

    /**   
	 * @var String $source
	 */
	public $source;
	
	/**   
	 * @var String $text
	 */
	public $html;
	
	/**   
	 * @var String $url
	 */
	public $url;
	
	/**   
	 * @var String $query
	 */
	public $query;
  
    function __construct($preset = null){
		$this->font 	= new PartFont();
		$this->position 	= 'bottom';
		$this->trigger 	= 'always';
		$this->source 	= 'html';
		$this->html 	= '';
		$this->url 		= null;
		$this->query 	= null;
    }
    
    public function bind($data){
    	if(isset($data->font))		$this->font->bind($data->font);
    	if(isset($data->position))	$this->position 	= 	$data->position; 
	if(isset($data->trigger))		$this->trigger 	= 	$data->trigger; 
    	if(isset($data->source))		$this->source 	= 	$data->source; 
    	if(isset($data->html))		$this->html 	= 	$data->html; 
    	if(isset($data->url))			$this->url 		= 	$data->url; 
	if (isset($data->data))		$this->data = $data->data;	
    	if(isset($data->query))		$this->query 	= 	$data->query; 
    }
    
    public function codeWizard($partObject){}
}
