<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/joomla/joomlaarticlescontent.php');
require_once(NGEPATH_HELPERS . '/api/content/joomla/joomlamenucontent.php');
require_once(NGEPATH_HELPERS . '/api/content/databasecontent.php');
//require_once(NGEPATH_HELPERS . '/api/content/imagescontent.php');
//require_once(NGEPATH_HELPERS . '/api/content/videoscontent.php');


/**
 * Content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartMultiplecontent{

    	var $version;
    
	/**   
	 * @var String $mode
	 */
	//public $mode;

	/**   
	 * @var int $count
	 * When custom mode : number of items
	 */
	//public $count;
	
	
	/**
	 * @var PartArticlesContent $articles
	 * If database mode : sousrce of data
	 */	
	//public $articles;
	
	/**
	 * @var PartJoomlaMenuContent $menu
	 * If database mode : sousrce of data
	 */
	//public $menu;
	
	/**
	 * @var PartDatabaseContent $database
	 * If database mode : sousrce of data
	 */
	//public $database;

	/**
	 * @var PartImagesContent $images
	 * If image mode : sousrce of data
	 */	
	//public $images;

	/**   
	 * @var array $items
	 * If custom mode : custom items
	 */
	//public $items;
			

	
	function __construct($mode='custom'){
		
	//	$this->mode = $mode;
		$this->source = $mode;
		$this->version = '';
	//	$this->count = 0;
		//$this->articles = new PartJoomlaArticlesContent();
		//$this->menu = new PartJoomlaMenuContent();
		//$this->database = new PartDatabaseContent();
		//$this->images = new PartImagesContent(); //Custom images
//		$this->videos = new PartVideosContent(); //Custom images
		$this->items = array();
	}
	
	
	public function bind($params){
                
		$content = $params->get('content');
		
		if (isset($content->mode))		
		    $this->mode = $content->mode;
/*
		switch ($this->mode) {
			case 'joomla.articles' :
				$this->bindJoomlaArticles($params);
				break;			
			case 'joomla.menu' :
				$this->bindJoomlaMenu($params);
				break;	
			case 'database' :
				$this->bindDatabase($params);
				break;			
			case 'images' :
				$this->bindImages($params);
//				$this->bindVideos($params);
				break;
			case 'custom' :
				$this->bindCustom($params);
				break;						    
    			default : //Other sources
				//Direct binding for free usage un each content plugin
				$this->params = $content;
				break;
		}	
*/		
		
		//Source of the tabs, can be custom for each tab custom, or tabs dynamically generated by datasource
		if (isset($content->source))
		    $this->source = $content->source;
/*
		if ($this->source == "custom")
		    $this->bindCustom($params);
		else
		    if ($this->source == "joomlamenu")
		    $this->bindJoomlaMenu($params);
		else
		    $this->bindSource($params);
*/		
		switch ($this->source) {
		    case 'joomla.articles' :
			$this->articles = new PartJoomlaArticlesContent();
			$this->bindJoomlaArticles($params);
			break;
		    case 'joomla.menu' :
			$this->menu = new PartJoomlaMenuContent();
			$this->bindJoomlaMenu($params);
			break;
		    case 'custom' :
			$this->bindCustom($params);
			break;
		    default :
			$this->bindSource($params);			
			break;					    
		}
	}
/*		
                 public function addItem($label, $type, $ref){
                    $item = new PartcustomlinkItem();
                    $item->label = $label;
                    $item->link->type = $type;
			switch ($type) {
				case "article" :
					$item->link->article = $ref;
					break;
				//TODO
			}
                    $this->items[] = $item;
                }
*/
              
	protected function bindJoomlaArticles($params){
			$this->articles->bind($params);				
	}
	
	protected function bindJoomlaMenu($params){
			$this->menu->bind($params);
	}
	
	protected function bindDatabase($params){
			$this->database->bind($params);				
	}

	protected function bindImages($params){
			$this->images->bind($params);				
	}
	
	protected function bindCustom($params){
			//to be overriden
	}
	
	protected function bindSource($params){
			//to be overriden
	    $content = $params->get('content');
	    //$source = str_replace('.', '/', $this->source);
	    $source = str_replace('.', '_', $this->source);
	    $this->$source = $content;
	    //if ($content->comode == 'joomla.menu')
	//	$this->menu->bind($params);
	}
	
	public function codeWizard($partObject){}
}
