<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartLabelContent{
	
	/**   
	 * @var String $source
	 */
	public $source;
	
	/**   
	 * @var String $text
	 */
	public $html;
	
	/**   
	 * @var String $url
	 */
	public $url;
	
	/**   
	 * @var String $query
	 */
	public $query;

	/**   
	 * @var String $article
	 */
	public $article;
	
	/**   
	 * @var String $system
	 */
	public $system;
	
	/**   
	 * @var String $date_format_mode
	 */
	public $date_format_mode;

	/**   
	 * @var String $date_format_value
	 */
	public $date_format_value;

	function __construct(){
		
		$this->source = 	'html';
		$this->html = 		'';
		$this->url = 		null;
		$this->query = 		null;
		$this->data = 		'';
		$this->article = 	'title';
		$this->system = 	'date';
		$this->date_format_mode = 'default';
		$this->date_format_value = '';
	}
	
	public function bind($data){
		
		if (isset($data->source))	$this->source = 	$data->source;
		if (isset($data->html))	$this->html = 		$data->html;
		if (isset($data->url))		$this->url = 		$data->url;
		if (isset($data->query))	$this->query = 		$data->query;
		if (isset($data->data))	$this->data = 		$data->data;
		if (isset($data->article))	$this->article = 	$data->article;
		if (isset($data->system))	$this->system = 	$data->system;
		if (isset($data->date_format_mode))	$this->date_format_mode = 	$data->date_format_mode;
		if (isset($data->date_format_value))	$this->date_format_value = 	$data->date_format_value;
	}
	
	public function codeWizard($partObject){}
}
