<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');

/**
 * Title label class
 * @package 	Content
 * @subpackage  Text/Title
 * @version 	1.0.0
 * @since       1.0.0
 */
class PartLabel{

    /**
     * @var PartFont $font
     */
    public $font;

    /**
     * @var String $source
     */
    public $source;

    /**
     * @var String $text
     */
    public $html;

    /**
     * @var String $url
     */
    public $url;

    /**
     * @var String $query
     */
    public $query;

    /**
     * @var String $trigger
     */
    public $trigger;
	
	
    function __construct($preset = null) {
	
	$this->font = new PartFont();
	$this->font->size = 14; //Default size for labels
	$this->source = 'html';
	$this->html = '';
	$this->url = null;
	$this->query = null;
	$this->trigger 	= 'always';	
    }

    public function bind($data) {

	if (isset($data->font))		$this->font->bind($data->font);
	if (isset($data->source))		$this->source = $data->source;
	if (isset($data->html))		$this->html = $data->html;
	if (isset($data->url))			$this->url = $data->url;
	if (isset($data->query))		$this->query = $data->query;
	if (isset($data->data))		$this->data = $data->data;	
	if(isset($data->trigger))		$this->trigger 	= 	$data->trigger; 
    }

    public function codeWizard($partObject) {
	
    }

}
