<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

//require_once(NGEPATH_HELPERS . '/api/template.php');
require_once(NGEPATH_HELPERS . '/api/content/joomla/articlescontentrenderer.php');

/**
 * Content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartJoomlaArticlesContent{

	/**
	 * @var String $mode
	 */
	//public $mode;
	
	/**   
	 * @var PartContentArticlesRenderer $renderer
	 */
	public $renderer;
	
	/**   
	 * @var String $html
	 */
	public $ordering;
	/**   
	 * @var integer $count
	 */
	public $count;
	/**   
	 * @var String $category
	 */
	public $category;
	/**   
	 * @var String $author
	 */
	public $author;
	/**   
	 * @var String $featured
	 */
	public $featured;
	/**   
	 * @var String $tags
	 */
	public $tags;
		
	function __construct(){
	//	$this->mode = 		'custom';
		$this->renderer =     new PartArticlescontentRenderer();
		$this->category = 	'';
		$this->author = 	'';
		$this->featured = 	'';
		$this->tags =	'';				
		$this->ordering = 	'';
		$this->count =         0;		
	}
	
	public function bind($params){
		
		$content = $params->get('content');
		if (isset($content))
			$articles = $content->articles;
		
		if (isset($articles)){
			if(isset($articles->renderer))		$this->renderer->bind($articles->renderer);
			
			if(isset($articles->category_filter) && ($articles->category_filter == 'custom') && (isset($articles->category))) 
				$this->category = 	$articles->category;
			if(isset($articles->author_filter) && ($articles->author_filter == 'custom')) 
				$this->author = 	$articles->author;
			if(isset($articles->featured) && ($articles->featured != '')) 
				$this->featured = 	$articles->featured;
			if(isset($articles->tags_filter) && ($articles->tags_filter == 'custom') && (isset($articles->tags))) 
				$this->tags = 	$articles->tags;
			
			if(isset($articles->ordering))		$this->ordering = 	$articles->ordering;
			if(isset($articles->count_mode) && ($articles->count_mode == 'custom')) //else all = 0
				$this->count = 	$articles->count;			
		}	
	}
	
	public function codeWizard($partObject){}
}
