<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/contentglyph.php');

/**
 * Thumbnails content title class 
 * 
 * For uasge in single items. (glyph->name property) . In multiple items, use PartThumbnailHeaderContent
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartHeaderContent{

	/**
	 * @var String $label
	 */
	public $label;
	
	/**
	 * @var PartContentGlyph $glyph
	 */
	public $glyph;
	
	function __construct(){	
		$this->label = 	"";
		$this->glyph = 	new PartContentGlyph();
	}
	
	public function bind($data){
		$this->label = 	$data->label;
		$this->glyph->bind($data->glyph);
	}
	
	public function codeWizard($partObject){}
}
