<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/multiplecontent.php');
require_once(NGEPATH_HELPERS . '/api/content/dropdowncustomcontent.php');

/**
 * Content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartDropdowncontent extends PartMultiplecontent{
		
	function __construct($mode='custom'){
		parent::__construct();		
		$this->mode = $mode;
	}
	
// 	public function addItem(){
		
// 	}
	
	public function bind($params){
		//if ($this->mode == 'custom')
		//	$this->bindCustom($params);
                
                            $content = $params->get('content');
		if (isset($content->mode))
			$this->mode = $content->mode;
	
		switch ($this->mode) {
			case 'database' :
				$this->bindDatabase($params);
				break;
			default : 
				$this->bindCustom($params);
				break;
		}	
		
	}
		
                 public function addHtml($label, $html){
                    $item = new PartTabsCustomContent();
                    $item->label = $label;
                    $item->body->source = 'html';
                    $item->body->html = $html;
                    $this->items[] = $item;
                }

                protected function bindDatabase($params){
	
		$content = $params->get('content');
                            if (isset($content->source)) 	$this->source		= $content->source;
		if (isset($content->query)) 	$this->query		= $content->query;
		if (isset($content->count)) 	$this->count 		= $content->count;
	}
        
	protected function bindCustom($params){
		$count = $params->get('count');
		
		//Creating default items
		for ($i=0;$i<$count; $i++){
			$this->items[] = new PartDropdowncustomcontent();
		}
			
		/***** Get Params *****/
		//Body
		$linkTypes = $params->get('link_types');
		$linkMenus = $params->get('link_menus');
		$linkArticles = $params->get('link_articles');
		$linkImages 	= $params->get('link_images');
		$linkDocuments 	= $params->get('link_documents');
		$linkUrls 	= $params->get('link_urls');
		
		$labels 	= $params->get('labels');
		$glyphnames 	= $params->get('glyphnames');
		$images 	= $params->get('images');
		//$glyph_pacements                   = $params->get('glyph_positions');
		$glyph_names 		= $params->get('glyph_names');
		
		for ($i=0;$i<$count; $i++){
			//Body
			$this->items[$i]->link->type		= $linkTypes[$i];
			$this->items[$i]->link->menu		= $linkMenus[$i];
			$this->items[$i]->link->article		= $linkArticles[$i];
			$this->items[$i]->link->image		= $linkImages[$i];
			$this->items[$i]->link->document	= $linkDocuments[$i];
			$this->items[$i]->link->url			= $linkUrls[$i];
			//$this->items[$i]->body->query		= $querys[$i];
			if ($labels[$i] != '')
			$this->items[$i]->label->html 		= $labels[$i];
			$this->items[$i]->glyphname 		= $glyphnames[$i];
			//$this->items[$i]->images 			= $images[$i];
			
/*			if (isset($images) && $images[$i] != '') {
				$this->items[$i]->tab->source = 'image';
				$this->items[$i]->tab->image = $images[$i];			
			}
*/				
		}
	}
	
	public function codeWizard($partObject){}
}
