<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

//require_once(NGEPATH_HELPERS . '/api/renderer.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class NgePartDataFilter extends NgePart {

	/**   
	 * @var string $type
	 */
	public $type;
	
	/**
	 * @var PartDatasource $sql
	 */
	public $sql;
	
	/**
	 * @var PartTabsbody $items
	 */
	public $items;


	function __construct(){
		parent::__construct();

		$this->type = 'none';
		$this->sql = '';
		$this->items = array();
	}

	//Bind params from json stored parameters
	public function bind($data){

	    if(isset($data->type))		$this->type 	= $data->type;
	    if(isset($data->sql))		$this->sql		= $data->sql;
	    	    
	    //Custom filters
	    if ($this->type == 'custom' && (isset($data->count))){
		for ($i=0;$i<$data->count; $i++){
		    		    
		    //If filter is not empty (while filling the form)
		    
		    if (isset($data->items[$i]) && ($data->items[$i]->field != '')) {
			$customFilter = new NgePartDataCustomFilter();
			$customFilter->bind($data->items[$i]);
			$this->items[] = $customFilter;
		    }
		    
		    /*echo $i.' - '.$data->fields[$i].'<br/>';
		    $customFilter = new NgePartDataCustomFilter();
		    $customFilter->field = $data->fields[$i];
		    $customFilter->operator = $data->operators[$i];
		    $customFilter->value = $data->values[$i];
		    $customFilter->between_start = $data->between_starts[$i];
		    $customFilter->between_end = $data->between_ends[$i];
		    
		    
		    //Adding filter if ok (can be empty while filling the form)
		    if ($customFilter->field != '')
			$this->items[] = $customFilter;
		     */
		}
	    }
	}

	public function codeWizard($partObject){}
}