<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

//require_once(NGEPATH_HELPERS . '/api/renderer.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class NgePartDataCustomFilter extends NgePart {

	/**   
	 * @var string $name
	 */
	public $field;
	
	/**
	 * @var string $filters
	 */
	public $operator;
	
	/**
	 * @var string $value
	 */
	public $value;
	
	/**
	 * @var string $between_start
	 */
	public $between_start;
	
	/**
	 * @var string between_end
	 */
	public $between_end;


	function __construct(){
		parent::__construct();

		$this->field = '';
		$this->operator = '';
		$this->value = '';
		$this->between_start = '';
		$this->between_end = '';
	}

	//Bind params from json stored parameters
	protected function bind($data){
		
	    if (isset($data->field))		$this->field = 		$data->field;
	    if (isset($data->operator))		$this->operator = 		$data->operator;
	    if (isset($data->value))		$this->value = 		$data->value;
	    if (isset($data->between_start))	$this->between_start = 	$data->between_start;
	    if (isset($data->between_end))	$this->between_end = 	$data->between_end;
	}

	public function codeWizard($partObject){}
}