<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');
require_once(NGEPATH_HELPERS . '/api/link.php');
require_once(NGEPATH_HELPERS . '/api/content/headercontent.php');

/**
 * Tabs custom content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartCustomMenuItem {

	/**
	 * @var String $label
	 */
	public $label;

	/**   
	 * @var PartContentGlyph $glyph
	 */
	public $glyph;
	

	/**   
	 * @var PartLink $link
	 */
	public $link;

	/**
	 * @var PartHeaderContent $header
	 */
	public $header;
		
	/**   
	 * @var PartCustomContent $body
	 */
	public $body;
		
	/**   
	 * @var PartTabsContentGlyph $glyph
	 */
	public $legend;

	
	function __construct(){		
		$this->label = 	'';
		$this->glyph = 	new PartContentGlyph();
		$this->link = 	new PartLink();

		$this->header =	new PartHeaderContent();
		$this->body = 	new PartCustomContent();
		$this->legend = "";
		
	}
	
	public function bind($data){
		//Made by PartContent
	    	if (isset($data->label))	$this->label =	$data->label;
		$this->glyph->bind($data->glyph);
		if (isset($data->link))		$this->link =	$data->link;

		if (isset($data->header))	$this->header->bind($data->header);		
		$this->body->bind($data);
		if (isset($data->legend))	$this->legend = $data->legend;		
		
	}
	
	public function codeWizard($partObject){}
}

