<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');
require_once(NGEPATH_HELPERS . '/api/link/customlink.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/dropdown/dropdowncontentlabel.php');
require_once(NGEPATH_HELPERS . '/api/content/contentglyph.php');

/**
 * Tabs custom content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartCustomlinkItem{

	/**
	 * @var String $label
	 */
	public $label;

	/**
	 * @var String $sublabel
	 */
	public $sublabel;

	/**
	 * @var String $image
	 */
	//public $image;
	
	
	/**   
	 * @var PartContentGlyph $glyph
	 */
	public $glyph;
	
	/**   
	 * @var PartCustomContent $content
	 */
	public $link;
		
	function __construct(){		
		$this->label = 	'';
		$this->sublabel = 	'';
		$this->image = 	'';
		$this->glyph = 	new PartContentGlyph();
		$this->link = 	new PartCustomLink();

	}
	
	public function bind($data){

		if (isset($data->label))	$this->label =	$data->label;
		if (isset($data->sublabel))	$this->sublabel =	$data->sublabel;
		if (isset($data->glyph))	$this->glyph->bind($data->glyph);
		if (isset($data->link))		$this->link->bind($data->link);
	    
	}
	
	public function codeWizard($partObject){}
}
