<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/template.php');
require_once(NGEPATH_HELPERS . '/api/content/videocontent.php');
require_once(NGEPATH_HELPERS . '/api/link.php');

/**
 * Content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartCustomContent{

	/**
	 * @var String $mode
	 */
	//public $mode;
	
	/**   
	 * @var String $source
	 */
	public $source;
	/**   
	 * @var String $html
	 */
	public $html;
	/**   
	 * @var String $article
	 */
	public $article;
	/**   
	 * @var String $module
	 */
	public $module;
	
	/**   
	 * @var String $url
	 */
	public $url;

	/**   
	 * @var String $query
	 */
	public $query;

	/**   
	 * @var parLink $link
	 */
	public $link;	
	
	/**   
	 * @var String $image
	 */
	public $image;
	
	/**   
	 * @var String $video
	 */
	public $video;
	
	
	function __construct(){
	//	$this->mode = 		'custom';
		$this->source =                     'html';
		$this->html = 		'';
		$this->article =                    null;
		$this->module =                     null;
		$this->url = 		null;
		$this->query = 		null;
		$this->image = 		'';
		$this->video = 		'';
		$this->link = 		new PartLink();		
                	$this->template = 		new PartTemplate();
	}
	
	public function bind($data){

	    	if(isset($data->source))	$this->source = 	$data->source;
	    	//The content from that source is in a property of the source name, for example $data->article
		if ($this->source == 'video'){
		    
		    $this->video = new PartVideoContent();
		    $this->video->bind($data->video);
		}
		else
		if ($this->source == 'article'){
		    $this->source = 'joomla.article';
		    if(isset($data->article))	$this->joomla_article = 	$data->article;
		}
		else
		if ($this->source == 'module'){
		    $this->source = 'joomla.module';
		    if(isset($data->module))	$this->joomla_module = 	$data->module;
		}
		    else{ //plugin content
			//The value property has _ instead of dots
			if(isset($this->source)){
			    $source = str_replace('.', '_', $this->source); //
			    if(isset($data->{$source}))	$this->{$source} = 	$data->{$source};
			}
		    }

		    if(isset($data->link))	$this->link->bind($data->link);
		    
//                            if(isset($data->template))	$this->template->bind($data->template);

		//Loading plugin contents
		    /*
		if ($this->source != 'html'){		    
		    if (file_exists(NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $this->source) . '/content.php')){
			$className = 'Nge' . implode('', array_map('ucfirst', explode('.', $this->source))) . 'Content';
			require_once NGEPATH_CONTENTS . '/source/' . implode('/', explode('.', $this->source)) . '/content.php';

			//WARNING : $data contains properties from the config screen. 
			//All content properties are not known because they can come from external content plugins
			//So we transmit unchanged all these properties as second parameter of the loadBody method (params)
			$this->html = $className::loadBody($this->{str_replace('.', '_', $this->source)}, $data);
			$this->source = 'html';
		    }
		    else {			
			//trigger_error ( 'NGE source driver not found for this data source : ' . NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $this->source) . '/content.php', E_USER_WARNING);
			//$this->html = '';
			//$this->source = 'html';
		    }
		}*/
			    
	}
	
	public function codeWizard($partObject){}
}
