<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/columnsrules.php');

/**
 * ColumnsCols class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartColumnsCols{
	
	/**
	 * @var String $padding
	 */
	public $padding;
	/**
	 * @var String $count
	 */
	public $count;
	/**
	 * @var String $gap
	 */
	public $gap;
	/**
	 * @var String $align
	 */
	public $align;
	/**   
	 * @var PartColumnsRules $rules
	 */
	public $rules;

	
	function __construct(){
		$this->padding = 	'10';
		$this->count = 		'2';
		$this->gap =		'3';
		$this->align =		'justify';
		$this->rules = 		new PartColumnsRules();
	}
	
	public function bind($data){
		if(isset($data->padding))		$this->padding =	$data->padding;
		if(isset($data->count))		$this->count = 		$data->count;
		if(isset($data->gap))			$this->gap = 		$data->gap;
		if(isset($data->align))		$this->align = 		$data->align;
		if(isset($data->rules))	$this->rules->bind($data->rules);
	}
	
	public function codeWizard($partObject){}
}
