<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/padding.php');
require_once(NGEPATH_HELPERS . '/api/part/images/image/imagecaptionpositions.php');
require_once(NGEPATH_HELPERS . '/api/animationeffect.php');
require_once(NGEPATH_HELPERS . '/api/effects/effect.php');

/**
 * Caption class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartCaption extends NgePart{
	
	/**
	 * @var PartFont $font
	 */
	public $font;
	
	/**
	 * @var PartBackground $border
	 */
	
	public $border;
	
	/**
	 * @var PartBackground $background
	 */
	public $background;
		
	/**
	 * @var String $html
	 */
	public $html;
	
	
	/**
	 * @var PartImagecaptionpositions $positions
	 */
	public $positions;
	
	/**
	 * @var PartPadding $padding
	 */
	public $padding;
	
	/**
	 * @var PartEffect $effects
	 */
	public $effects;
	
	/**
	 * @var String $trigger 
	 */
	public $trigger;

	function __construct($preset = null){

	    	parent::__construct();
		$this->html = 		'';
		$this->font = new PartFont();
		$this->font->size = '14'; //Default size for captions
		$this->padding = 		new PartPadding();
		$this->padding->vpadding = 		8; 
		$this->padding->hpadding = 		12; 
		$this->border =	new PartBorder();
		$this->background =	new PartBackground();
		$this->positions = new  PartImagecaptionpositions ();
		$this->trigger = 'always';
		$this->effects = 	array();

	}
	
	public function bind($data){
		
		//Content
		if (isset ( $data->html ))	$this->html = $data->html;		

		if (isset ( $data->font ))	$this->font->bind ( $data->font );
		if(isset($data->hpadding)){
		    $this->padding->left = $data->hpadding;
		    $this->padding->right = $data->hpadding;
		}
		if(isset($data->vpadding)){
		    $this->padding->top = $data->vpadding;
		    $this->padding->bottom = $data->vpadding;
		}
		if (isset ( $data->border ))		$this->border->bind ( $data->border );		
		if (isset ( $data->background ))		$this->background->bind ( $data->background );		
		if (isset ( $data->positions ))		$this->positions->bind ( $data->positions );		
		if (isset ( $data->trigger ))		$this->trigger = $data->trigger;				
				
		//display effects on display trigger
		if (isset($data->effects) && isset($data->effects->display) && ($data->effects->display->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->display);
		    $effect->event='display';
		    $this->effects[] = $effect;
		}
		//display effects on hover trigger
		if (isset($data->effects) && isset($data->effects->hover) && ($data->effects->hover->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->hover);
		    $effect->event='hover';
		    $this->effects[] = $effect;
		}
		//display effects on click trigger
		if (isset($data->effects) && isset($data->effects->click) && ($data->effects->click->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->click);
		    $effect->event='click';
		    $this->effects[] = $effect;
		}

	}
	
	public function codeWizard($partObject){}
}
