<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/bootstrapbutton.php');
require_once(NGEPATH_HELPERS . '/api/padding.php');
require_once(NGEPATH_HELPERS . '/api/backgroundlink.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/itemheight.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartButton{
	
	/**
	 * @var String $style
	 */
	public $style;
	
	/**
	 * @var String $class
	 */
	public $class;
	
	/**
	 * @var PartBootstrapbutton $bootstrap
	 */
	public $bootstrap;

	/**
	 * @var String $align
	 */
	public $align;

	/**
	 * @var String $valign
	 */
	public $valign;

	/**
	 * @var String $shape
	 */
	public $shape;

	/**
	 * @var PartItemheight $height
	 */
	public $height;

	
	/**
	 * @var PartPadding $padding
	 */
	public $padding;

	/**
	 * @var PartBackground $background
	 */
	public $background;
	
	/**
	 * @var PartBorder $border
	 */
	public $border;
	
	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;

	
	function __construct($preset = null){

		$this->style = '';
		$this->class = 		'';
		$this->bootstrap =	new PartBootstrapbutton();
		$this->shape = 		'rectangle';
		$this->height = 	new PartItemheight();
		$this->height->value =		30; //Default value
		$this->align = 'center';
		$this->valign = 'middle';		
		$this->padding = 	new PartPadding();
		$this->padding->top = 		8; 
		$this->padding->bottom = 		8; 
		$this->padding->left = 		12; 
		$this->padding->right = 		12; 
		$this->background =	new PartBackgroundlink();
		$this->border = 	new PartBorder();
		$this->shadow =	new PartShadow();

	}
	
	public function bind($data){
		
		if (isset($data->style))		$this->style = 			$data->style;
		
		if (isset($data->class))		$this->class = 			$data->class;
		if (isset($data->bootstrap))		$this->bootstrap->bind ( $data->bootstrap );

		if (isset($data->align))		$this->align = 			$data->align;
		if (isset($data->valign))		$this->valign = 			$data->valign;
		if (isset($data->shape))		$this->shape = 			$data->shape;
		if (isset ( $data->height ))		$this->height->bind ( $data->height );
		
		//If shape is square or circle, we dont use the hpadding and vpadding settings, only padding
		if(isset($data->hpadding)){
		    $this->padding->left = $data->hpadding;
		    $this->padding->right = $data->hpadding;
		}
		if(isset($data->vpadding)){
		    $this->padding->top = $data->vpadding;
		    $this->padding->bottom = $data->vpadding;
		}
		if(isset($data->padding)){
		    $this->padding->default = $data->padding;
		}
		
		//If shape is square or circle, we dont use the hpadding and vpadding settings, only padding
		//We override default values
		if(($this->shape == 'square') && ($this->shape == 'circle')){
		    $this->padding->left = $this->padding->default;
		    $this->padding->top = $data->padding->default;
		    $this->padding->right = $data->padding->default;
		    $this->padding->bottom = $data->padding->default;
		}
		
		
		if (isset ( $data->border ))		$this->border->bind ( $data->border );
		if (isset ( $data->background ))		$this->background->bind ( $data->background );
		if (isset ( $data->shadow ))		$this->shadow->bind ( $data->shadow );		
	}
	
	public function codeWizard($partObject){}
}
