<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartBullets{
	/** 
	 *	@var String $position Glyph position from the text can be "left" or "right"
	 */
	public $style;
	
	/**
	 *	@var String $position
	 */
	public $position;
	
	/**
	 *	@var String $size Glyph size
	 */
	public $size;
	/**
	 *	@var String $color Glyph color
	 */
	public $color;
	
	/**
	 *	@var String $color Glyph color
	 */
	public $color_hover;
	
	function __construct(){
		$this->style = 	'none';
		$this->size = 		'30';
		$this->color = 		'#666666';				
		$this->color_hover = 	'';				
		$this->position = 		'outside';
	}
	
	public function bind($data){

		if (isset($data->style))			$this->style =		$data->style;
		if (isset($data->position))			$this->position =		$data->position;
		if (isset($data->size)) 			$this->size = 		$data->size;
		if (isset($data->color)) 			$this->color = 		$data->color;
		if (isset($data->color_hover)) 			$this->color_hover = 	$data->color_hover;
	}
	
	public function codeWizard($partObject){}
}
