<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/radius.php');
require_once(NGEPATH_HELPERS . '/api/effects/bordereffect.php');
/**
 * Border class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartBorder{
	/**
	 * @var String $style
	 */
	public $style;
	/**
	 * @var Array|null $positions
	 */
	public $positions;
	/**
	 * @var String $width
	 */
	public $width;
	/**
	 * @var PartRadius $radius
	 */
	public $radius;
	
	/**
	 * @var String $color
	 */
	public $color;
	
	/**
	 * @var String $color_hover
	 */
	public $color_hover;
	
	/**
	 * @var String $color_hover
	 */
	public $color_active;
	
	/**
	 * @var array $effects
	 */
	public $effects;

	function __construct(){
		$this->style = 		'default';
		$this->positions = array('left', 'top', 'bottom', 'right');
		$this->width = 		'1';
		$this->radius = new PartRadius();
		$this->color = 		'#cccccc';
		$this->color_hover = 		'';
		$this->color_active = 		'';
		$this->effects		= array();
	}
	
	public function bind($data){
		if (isset($data->style))			$this->style = 		$data->style;
		if (isset($data->positions))			$this->positions =		$data->positions;
		if (isset($data->width))			$this->width = 		$data->width;
		if (isset($data->radius_positions)) 		$this->radius->positions = 	$data->radius_positions;
		if (isset($data->radius_width))			$this->radius->width = 	$data->radius_width;
		if (isset($data->color))			$this->color = 		$data->color;
		if (isset($data->color_hover))			$this->color_hover = 	$data->color_hover;
		if (isset($data->color_active))			$this->color_active = 	$data->color_active;
		
		if (isset($data->effects)){
		    foreach ($data->effects as $dataEffect){
			$effect = new PartBorderEffect();
			$effect->bind($dataEffect);
			$this->effects[] = $effect;
		    }
		}
	}
	
	public function codeWizard($partObject){}
}