<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');

/**
 * Panel class
 * @package 	Content
 * @subpackage  Panels/Panel
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartBody {

	/**
	 * @var PartPadding $padding
	 */
	public $padding;

	/**
	 * @var PartFont $font
	 */
	public $font;

	/**   
	 * @var PartBorder $border
	 */
	public $border;
	
	/**   
	 * @var PartBackground $background
	 */
	public $background;
	
	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;


	function __construct(){

		//Default values		
//		$this->padding = 		"10";
		$this->padding = 	new PartPadding();
 		$this->padding->default = 	'10';
		$this->font =	new PartFont();
		$this->border = 	new PartBorder();
		$this->background = new PartBackground();
		$this->shadow = 	new PartShadow();
	}

	//Bind params from JRegistry data object
	public function bind($data){				
		//if (isset($data->padding))		$this->padding = 		$data->padding;
		
		if(isset($data->hpadding)){
		    $this->padding->left = $data->hpadding;
		    $this->padding->right = $data->hpadding;
		}
		if(isset($data->vpadding)){
		    $this->padding->top = $data->vpadding;
		    $this->padding->bottom = $data->vpadding;
		}
		if(isset($data->padding)){
		    $this->padding->default = $data->padding;
		}
		if (isset ($data->font))		$this->font->bind ( $data->font );
		if (isset($data->border))		$this->border->bind($data->border);
		if (isset($data->background))		$this->background->bind($data->background);
		if (isset($data->shadow))		$this->shadow->bind($data->shadow);
	}

	public function codeWizard($partObject){}
}