<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartBadge{
	
	/**
	 * @var PartFont $font
	 */
	public $font;
	/**
	 * @var PartBackground $background
	 */
	public $background;
	
	/**
	 * @var PartBorder $border
	 */
	public $border;
	
	/**
	 * @var String $label
	 */
	public $label;
	
	/**
	 * @var String $glyphname
	 */
//	public $glyphname;
	
	/**
	 * @var String $shape
	 */
	public $shape;
	
	/**
	 * @var String $hposition
	 */
	public $hposition;
	
	/**
	 * @var String $vposition
	 */
	public $vposition;
	
	/**
	 * @var String $align
	 */
	public $align;
	/**
	 * @var String $padding
	 */
	public $padding;
	
	/**
	 * @var String $hoffset
	 */
	public $hoffset;
	
	/**
	 * @var String $voffset
	 */
	public $voffset;
	
	/**
	 * @var PartGlyph $glyph
	 */
	public $glyph;
	
	/**
	 * @var array $effects
	 */
	public $effects;
	
	
	function __construct($preset = null){
		
		$this->label = 		'';
//		$this->glyphname = 	'';
		$this->glyph = 		new PartGlyph();		
		$this->shape = 	'rectangle';
		$this->hposition = 		'left';
		$this->vposition = 		'top';		
		$this->padding = 	'5';
		$this->hoffset = 	'0';
		$this->voffset = 	'0';
		$this->font = 	   	new PartFont();
		$this->background =	new PartBackground();
		$this->border = 	new PartBorder();
		$this->effects		= array();
	}
	
	public function bind($data){
		//Content
		if (isset ( $data->label ))
			$this->label = $data->label;
//		if (isset ( $data->glyphname ))
//			$this->glyphname = $data->glyphname;
		//Options
		if (isset ( $data->shape ))		$this->shape = $data->shape;
		if (isset ( $data->hposition ))		$this->hposition = $data->hposition;
		if (isset ( $data->vposition ))		$this->vposition = $data->vposition;
		if (isset ( $data->align ))		$this->align = $data->align;
		if (isset ( $data->padding ))		$this->padding = $data->padding;		
		if (isset ( $data->hoffset ))		$this->hoffset = $data->hoffset;		
		if (isset ( $data->voffset ))		$this->voffset = $data->voffset;		
		if (isset ( $data->font ))		$this->font->bind ( $data->font );
		if (isset ( $data->glyph ))		$this->glyph->bind ( $data->glyph );		
		if (isset ( $data->border ))		$this->border->bind ( $data->border );
		if (isset ( $data->background ))		$this->background->bind ( $data->background );
		
		//display effects on display trigger
		if (isset($data->effects) && isset($data->effects->display) && ($data->effects->display->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->display);
		    $effect->event='display';
		    $this->effects[] = $effect;
		}
		//display effects on hover trigger
		if (isset($data->effects) && isset($data->effects->hover) && ($data->effects->hover->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->hover);
		    $effect->event='hover';
		    $this->effects[] = $effect;
		}
	}
	
	public function codeWizard($partObject){}
}
