<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/background.php');

/**
 * Background class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartBackgroundlink extends PartBackground{
	
	
	/**
	 * @var String $color_hover
	 */
	public $color_hover;
	
	/**
	 * @var String $color_hover2
	 */
	public $color_hover2;

		/**
	 * @var String $color_active
	 */
	public $color_active;
	
	/**
	 * @var String $color_active2
	 */
	public $color_active2;

	
	function __construct(){		
		
		parent::__construct();
		
		$this->color_hover 	= '#dddddd';
		$this->color_hover2 	= '#eeeeee';
		$this->color_active 	= '#dddddd';
		$this->color_active2 	= '#eeeeee';
	}
	
	public function bind($data){		
		parent::bind($data);
		if (isset($data->color_hover)) 			$this->color_hover 	= 	$data->color_hover;
		if (isset($data->color_hover2)) 			$this->color_hover2 	=	$data->color_hover2;
		if (isset($data->color_active)) 			$this->color_active 	= 	$data->color_active;
		if (isset($data->color_active2)) 		$this->color_active2 	=	$data->color_active2;
	}
	
	public function codeWizard($partObject){}
}
