<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/tint.php');

/**
 * Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartBackgroundimage{
	/** 
	 *	@var String $position Glyph position from the text can be "left" or "right"
	 */
	public $image;
	/**
	 *	@var String $name Glyph name
	 *	@example "icomoon-home", "icomoon-headphones", "icomoon-twitter2"
	 */
	//public $name;
	/**
	 *	@var String $size Glyph size
	 */
	public $image_hover;
	
	/**
	 *	@var String $repeat
	 */
	public $repeat;
	
	/**
	 *	@var String $fit
	 */
	public $fit;

	/**
	 *	@var String $tint
	 */
	public $tint;
	
	/**
	* @var String $trigger
	*/
	public $trigger;
	
	function __construct(){
		$this->image =			'';
		$this->image_hover = 	'';
		$this->repeat =			'1';
		$this->fit =			'image';
		$this->tint		= new PartTint();
	}
	
	public function bind($data){
		if (isset($data->image))		$this->image =		$data->image;
		if (isset($data->image_hover))		$this->image_hover = 	$data->image_hover;
		if (isset($data->repeat)) 		$this->repeat = 		$data->repeat;
		if (isset($data->fit))			$this->fit =		$data->fit;
		if (isset($data->tint))			$this->tint->bind($data->tint);		
	}
	
	public function codeWizard($partObject){}
}
