<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/backgroundimage.php');
require_once(NGEPATH_HELPERS . '/api/backgroundvideo.php');
require_once(NGEPATH_HELPERS . '/api/effects/backgroundeffect.php');

/**
 * Background class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartBackground{
	
	/**
	 * @var String $style
	 */
	public $style;
	
	/**
	 * @var String $color
	 */
	public $color;
	
	/**
	 * @var String $color_hover
	 */
	public $color_hover;
	
	/**
	 * @var String $color2
	 */
	public $color2;

	/**
	 * @var String $color_odd
	 */
	public $color_odd;
	
	/**
	 * @var String $color_even
	 */
	public $color_even;
	
	/**
	 * @var String $direction
	 */
	public $direction;

	/**
	 * @var Backgroundimage $image
	 */
	public $image;

	/**
	 * @var Backgroundvideo $video
	 */
	public $video;
	
	/**
	 * @var numeric $opacity
	 */
	public $opacity;
	
	/**
	 * @var array $effects
	 */
	public $effects;

		
	function __construct(){		
		$this->style		= 'default';
		$this->color		= '#f9f9f9';
		$this->color2		= '#ffffff';
		$this->color_odd		= '#ffffff';
		$this->color_even		= '#f9f9f9';
		$this->color_hover 	= '';
		$this->color_hover2 	= '';
		$this->direction		= 'vertical';		
		$this->image		= new PartBackgroundimage();
		$this->video		= new PartBackgroundvideo();
		$this->opacity		= '100';
		$this->effects		= array();
	}
	
	public function bind($data){
		if (isset($data->style)) 		$this->style	=	$data->style;
		if (isset($data->color)) 		$this->color 	=	$data->color;
		if (isset($data->color2)) 		$this->color2 	=	$data->color2;
		if (isset($data->color_odd)) 		$this->color_odd 	=	$data->color_odd;
		if (isset($data->color_even)) 		$this->color_even 	= 	$data->color_even;		
		if (isset($data->color_hover)) 		$this->color_hover 	= 	$data->color_hover;
		if (isset($data->color_hover2)) 		$this->color_hover2 	=	$data->color_hover2;
		if (isset($data->direction)) 		$this->direction 	=	$data->direction;		
		if (isset($data->image)) 		$this->image->bind($data->image);
		if (isset($data->video)) 		$this->video->bind($data->video);
		if (isset($data->opacity)) 		$this->opacity	=	$data->opacity;
		
		/*if (isset($data->effects)){
		    foreach ($data->effects as $dataEffect){
			$effect = new PartBackgroundEffect();
			$effect->bind($dataEffect);
			$this->effects[] = $effect;
		    }
		}
		*/		
		//display effects on display trigger
		if (isset($data->effects->display) && ($data->effects->display->name != 'none')){
		    $effect = new PartBackgroundEffect();
		    $effect->bind($data->effects->display);
		    $effect->event='display';
		    $this->effects[] = $effect;
		}
		//display effects on hover trigger
		if (isset($data->effects->hover) && ($data->effects->hover->name != 'none')){
		    $effect = new PartBackgroundEffect();
		    $effect->bind($data->effects->hover);
		    $effect->event='hover';
		    $this->effects[] = $effect;
		}
		
	}
	
	public function codeWizard($partObject){}
}