<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

/**
 * Part controller class.
 */
class NgeControllerPart extends JControllerForm
{

    function __construct() {
        $this->view_list = 'parts';
        parent::__construct();
    }

    /**
     * Rendering part in edit mode, for example to be edited in frontend
     */
    public function alter(){

	$jinput = JFactory::getApplication()->input;
	$pk = $jinput->getInt('pk'); //Existing part id

	//Check user ACL
	if ($pk && $this->userAllowedToEditPart($pk)){
	    //result is html
	    echo $this->_render('edit');
	}
    	exit();
    }

    /* For image wall */
    public function preview(){

	if (!JSession::checkToken()) {
 	    echo NGE::translate('SESSION_EXPIRED');
 	    exit();
 	}

	$jinput = JFactory::getApplication()->input;
	$pk =	    $jinput->getInt('pk'); //Existing part id when editing existing part
	$plname =	    $jinput->get('plname'); //Part library id when creating new part

	//Check user ACL, allowed to create or edit part part?
	if (($pk && $this->userAllowedToEditPart($pk)) || (($plname != '') && ($this->userAllowedToCreatePart()))){
	    //result is html
	    echo $this->_render('preview');
	}
    	exit();
    }
    
    /**
     * For displaying help in the configuration screen
     */
    public function help(){

	if (!JSession::checkToken()) {
 	    echo NGE::translate('SESSION_EXPIRED');
 	    exit();
 	}
	
	$jinput = JFactory::getApplication()->input;
	$pk = $jinput->getInt('pk'); //Existing part id
	
	//Check user ACL, allowed to edit part?
	if (($pk && $this->userAllowedToEditPart($pk)) || (($plname != '') && ($this->userAllowedToCreatePart()))){
	    //result is html
	    $lang = JFactory::getLanguage();
	    $lang->load('com_nge_help',JPATH_SITE);
	    echo $this->_render('help');
	}
    	exit();
    }	

/**
 * 
 * @param type $renderingMode render / edit / preview
 * @return string
 */	
    protected function _render($renderingMode){
    	$jinput = JFactory::getApplication()->input;
    	$mode =					$jinput->get('mode');
    	$plname = 				$jinput->get('plname'); //Part library id
    	$pk = 					$jinput->getInt('pk'); //Existing part id
    	$includeLibraries =				$jinput->getInt('include_libraries', 1); //Existing part id
	$storedSource = 				$jinput->get('storedsource'); //Current part or history 

    	$model = $this->getModel();

    	if ($plname != ''){ //Creation mode, part library id
    		$name = $plname;
    	}else if ($pk != '') //Modification mode, part id
    		$name = '['.$pk.']';
    
    	//If mode == edit, create, duplicate, we are in the config screen, in live preview, live params are in the url
    	//Otherwise, no url params, normal rendering => only database params
		
	//Warning. If values are json string object, decode them to save them as array.
	//Each array item can be modified by inlineediting.
	//Save thing in model part->save
	$keyArrayJson = NGE::recursive_array_search('ngejson::',$_REQUEST);
	if($keyArrayJson !== false){/*If value with json object string exist*/
	    $_REQUEST = NGE::decode_json_string($_REQUEST, $keyArrayJson);
	}

    	if (($mode == 'edit') || ($mode == 'create') || ($mode == 'duplicate'))
    		$urlparams = json_encode($_REQUEST);
    	else
    		$urlparams = '';
    
    	//Normal rendering for an existing part, all params in database
    	switch ($renderingMode){	    
		case 'preview': //In config screen
			require_once NGEPATH_HELPERS . '/ngecontenthelper.php';	
			$result = $model->render($name, $renderingMode, $urlparams, $storedSource);
                                            //Load common scripts and stylesheets for the current part		
			//TOTO, scripts are always included, because of content.prepare call in the part model.
			if ($includeLibraries == '1'){ //Include libraries when first preview
			    $result = NgeContenthelper::renderScripts() . $result;
			    $result = NgeContenthelper::renderStyleSheets() . $result;
			}
                                            return $result;
                                            break;
		case 'render': //Normal rendering. Scripts are added together in the content plugin
		case 'edit':
    			return $model->render($name, $renderingMode, $urlparams);
    			break;
    		case 'generate':
			return $model->generate($name, $urlparams);
			break;
		case 'help':
    			//return $model->help($name, $urlparams);			
			require_once NGEPATH_HELPERS . '/ngepartshelper.php';
			require_once NGEPATH_HELPERS . '/ngeparthelper.php';
			$part = NgePartsHelper::getPart($name);			
			return NgePartHelper::help($part);
                     break;
    	}
    }
    
    /**
     * Save part content and properties from editors, and front-editing
     * The configuration screen can contain all existing fields or also only some fields in smaller forms
     * 
     */
    public function save($key = NULL, $urlVar = NULL)
    {
    	//Warning. See also back controller : administrator/components/com_nge/controllers/part.php	

	$jinput = JFactory::getApplication()->input;
	$pk = $jinput->getInt('pk'); //Part id
	$result = array();
	$result["result"] = 0;
		
	//Check session
       	if (!JSession::checkToken() ){
	    $result["message"] = JText::_('SESSION_EXPIRED');
       	}
	else //Check user ACL
	if((!$pk) && (!$this->userAllowedToCreatePart())) {
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED');
	}
	if(($pk) && (!$this->userAllowedToEditPart($pk))) {
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else {
        		 
	    $medium =	$jinput->get('medium');
	    $medium_id =	$jinput->getInt('medium_id');
	    $caller =	$jinput->get('caller');
	    $viewmode =	$jinput->get('viewmode');
	    $rendering_mode =	$jinput->get('rendering_mode', '');

	    //Wich caller type ?
	    $callerArray = explode('.', $caller); //Caller can be jce, jck, layout.page, layout.article...
	    //Here we need only first part (jce, or layout)
	    $editors = array('tinymce','jce','jck','ckeditor');
	    $callerType = '';
	    if (in_array($caller,$editors))
		$callerType = 'editor';
	    else
	    if((count($callerArray) > 1) && $callerArray[1]=='position' && (!$pk))
		$callerType = 'newposition';
	    else
	    if (in_array($callerArray[0], array('front','layout')) || $caller=='ckeditor.inline')
		$callerType = 'inline';
	    else
	    if ($callerArray[0] == 'ngepart')
		$callerType = 'part';
	    
	    //Saving
	    $model = $this->getModel();
	    if ($model->save($_REQUEST)) {
		
		$result["result"] = "1"; //Saving result is OK
		$result["idpart"] = $model->idpart;
    		$result["pk"] = $model->idpart;		
		
		//Rendering content back
		switch ($callerType){
		    case 'editor' : //Inside a Joomla editor
			$result["htmlpart"] = '<part data-class="'.$model->part_category.'" data-part="'.$model->idpart.'">&nbsp;</part>';                
			break;
		    case 'inline' :
			//Sending back all html to be replaced in the parent sreen
			//Part is rendered in edit mode
			$params = new stdClass();
			$params->rendering_mode = ($rendering_mode === "") ? 'edit' : $rendering_mode;

			if ($viewmode == 'thumbnails'){ //Thumbnail format display			    
			    require_once NGEPATH_HELPERS . '/parts/renderer/thumbnails.php';
			    $result["html"] = NgePartRendererThumbnails::render('['.$model->idpart.']', $params);
			}
			else{ //Normal display			    
			    require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
			    $result["html"] = NgePartRendererDefault::render('['.$model->idpart.']', $params);

			    //Add scripts and styles if is new part
			    if (!$pk){
				require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
				$result["html"] = NgeContenthelper::renderScripts() . $result["html"];
				$result["html"] = NgeContenthelper::renderStyleSheets() . $result["html"];
			    }
			}			
			break;
		    case 'newposition' :
			// create nge_module if in creation and part dropped in postion
			$newModule = $this->create_nge_module($result["pk"], $jinput->get('position',0), $jinput->get('plname'), $jinput->get('m_before_id',0) );
			if($newModule['result'] == true){
			    $result['m_id'] = $newModule['m_id'];
			    $result['html'] = $newModule['html'];
			    $result['title'] = $newModule['title'];
			    $result['module'] = $newModule['module'];
			    $result['position'] = $newModule['position'];

			    //Add scripts and styles if is new part
			    if (!$pk){
				require_once NGEPATH_HELPERS . '/ngecontenthelper.php';				    
				$result["html"] = NgeContenthelper::renderScripts() . $result["html"];
				$result["html"] = NgeContenthelper::renderStyleSheets() . $result["html"];
			    }
			}
			else {
			    $result["result"] = "0";
			    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_CREATING_MODULE');
			}
			break;		    
		    case 'part' :
			$result["plname"] = $jinput->get('plname');			
			break;
		    
		}
	    }
	    else {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_SAVING_PART');
	    }
    	}    	
	print(json_encode($result));
    	exit();
    }
            
    /**
     * Update some params of a widget, in front-editing
     */
    public function updateParams() {
	
	$jinput = JFactory::getApplication()->input;
	$pk = $jinput->getInt('pk'); //Existing part id
	$params = $jinput->getRaw('params'); 	
	$result = array();
	$result["success"] = 0;

	//Check session
       	if (!JSession::checkToken() ){
	    $result["message"] = JText::_('SESSION_EXPIRED');
       	}
	else //Check user ACL
	if (!$this->userAllowedToEditPart($pk, 'params')){		
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED');
	}
	else //part Id defined ?
	if(!$pk) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_PART_ID_IN_KEY');
	}
	else {
	
	    require_once NGEPATH_HELPERS . '/ngeparthelper.php';
	    $part = NgePartHelper::getPart($pk);
	    $part->mergeParams($params);

	    if ($part->save()){
		    $result["success"] = 1;
		    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_SAVED');
	    }else{
		    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_SAVED');
	    }
	}
    	
    	print(json_encode($result));
    	exit();
    }
    
    
     /**
     * NgeControllerPart::addcontent()
     * 
     * @return void
     */
    public function addcontent() {

	$jinput = JFactory::getApplication()->input;
	$pk = $jinput->getInt('pk'); //Existing part id
	$result = array();
	$result["result"] = "0";

	//Check session
       	if (!JSession::checkToken() ){
	    $result["message"] = JText::_('SESSION_EXPIRED');
       	}
	else //Check user ACL
	if (!$this->userAllowedToEditPart($pk)){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else //part Id defined ?
	if(!$pk) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_PART_ID_IN_KEY');
    	}
	else {
	    $part_model = $this->getModel();
	    $jinput = JFactory::getApplication()->input;
	    $pk = 	$jinput->get('pk');
	    $return = false;

	    // put nge content query in array
	    $query = urldecode($jinput->getRaw("ngecontent",'post'));
	    $query_content_properties=array();
	    parse_str($query,$query_content_properties);

	    if(count($query_content_properties)) {
		$contentParams = $part_model->load_part_content($pk);

		if(!$contentParams) {
		   $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_NO_CONTENT_PARAMS_FOUND');
		   print(json_encode($result));
		   exit();
		}
		$paramsArray = json_decode($contentParams,true);

		//Searching count value
		$count = $paramsArray['count'];
		$count++;
		$paramsArray['count'] = $count;
		foreach($query_content_properties as $key=>$value){
		    $paramsArray[$key.'s'][$count] = $value;
		}
		//$new_obj_params = array_merge($obj_params,$query_content_properties);

		$contentParams = json_encode($paramsArray);

		//$part_model->savepart_params($part_id,$params);
		$return = $part_model->savepart_content($pk,$contentParams);
	    }        

	    if ($return) {
		    //If caller is an editor, we return the part id

		$caller = $jinput->get('caller', '');
		$callerArray = explode('.', $caller); //Caller can be jce, jck, layout.page, layout.article...
		//Here we nedd only first part (jce, or layout)
		$caller = $callerArray[0];
		$editors = array('tinymce','jce','jck');
		//Caller is inline editing (front or layout). Preview is sent back
		if (in_array($caller, array('front','layout'))){
			require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
			require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
			$result["pk"] = $pk;
			$result["result"] = "1"; //Saving result is OK
			//Sending back all html to be replaced in the parent sreen
			//Full part html
			$result["html"] = NgePartRendererDefault::render('['.$pk.']');
			//Scripts and styles, only if creation
			if (!(isset($_REQUEST['pk']) && $_REQUEST['pk'] != '')){
			    $result["html"] = NgeContenthelper::renderScripts() . $result["html"];
			    $result["html"] = NgeContenthelper::renderStyleSheets() . $result["html"];
			}
		}
	    }
	    else {
		$result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_SAVING_PART');
	    }
	}
	print(json_encode($result));
	exit();
    }

    
     /**
     * NgeControllerPart::duplicate()
     * 
     * Duplicate an existing part.
     */
    public function duplicate($key = NULL, $urlVar = NULL) {
	
	$jinput = JFactory::getApplication()->input;
	$pk = $jinput->getInt('pk'); //Existing part id
	$result = array();
	$result["result"] = "0";

	//Check session
       	if (!JSession::checkToken('get') ){
	    $result["message"] = JText::_('SESSION_EXPIRED');
       	}
	else //Check user ACL
	if (!$this->userAllowedToEditPart($pk)){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else  //part Id defined ?
	if(!$pk) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_PART_ID_IN_KEY');
    	}
	else //Demo mode ?
	if (NGE::features('nge.demo')){
                    $result["pk"] = "0";
                    $result["result"] = "1";
                    $result["html"] = '';
	    //$result["message"] = NGE::translate('COM_NGE_DEMO_MODE_MESSAGE');
	}
	else {
	    //Process part duplication
	    require_once(JPATH_COMPONENT.'/helpers/ngeparthelper.php');

	    $medium = 	$jinput->get('medium', '', 'string');
	    $medium_id = 	$jinput->get('medium_id', '', 'int'); 
	    $return = 	$jinput->get('return', '', 'string');

	    $idPart = NgePartHelper::duplicate($pk, $medium, $medium_id, $return);
	    if ($idPart){
		$result["pk"] = $idPart;
		$result["result"] = "1"; //Saving result is OK
		if ($return == 'preview'){
		    require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
		    $result["html"] = NgePartRendererDefault::render('['.$idPart.']');
    /*	    }else if ($return == 'wireframe'){
		    require_once NGEPATH_HELPERS . '/parts/renderer/wireframe.php';
		    $document	= JFactory::getDocument();
		    $renderer 	= new JDocumentRendererWireframe($document);
		    $result["html"] = $renderer->render('['.$idPart.']');*/
		}else if ($return == 'fastview'){
		    require_once NGEPATH_HELPERS . '/parts/renderer/thumbnails.php';
		    $result["html"] = NgePartRendererThumbnails::render($idPart);
		}else{	
		    echo "1";
		    JFactory::getApplication()->close();
		}
	    }
	}
	print(json_encode($result));
	exit();
    }
    
    /**
     * NgeControllerPart::getHistory()
     * Return history list of the current part
     * @return json object
     */
    public function getHistory(){

	$jinput = JFactory::getApplication()->input;
	$partId = $jinput->getInt('pk');
	$includeLibraries = $jinput->getInt('include_libraries', '1'); //Must include or not scripts
	$result = array();
	$result["result"] = "0";	

	//Check session
       	if (!JSession::checkToken() ){
	    $result["message"] = JText::_('SESSION_EXPIRED');
       	}
	else //Check user ACL
	if (!(NGE::features('nge.pro') && $this->userAllowedToEditPart($partId))){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else //part Id defined ?
	if(!$partId) {    		
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_PART_ID_IN_KEY');
    	}
	else{ // get History list
	    require_once NGEPATH_HELPERS . '/ngepartshistoryhelper.php';
	    $lang = JFactory::getLanguage();
	    $lang->load('com_nge_pack',JPATH_SITE);
	    $result["result"] = "1";
	    $result["history"] = NgePartsHistoryHelper::getHistory($partId);
	}
	print(json_encode($result));
	exit();
    }
    
    /**
     * NgeControllerPart::restore()
     * 
     * Restore part content from old history
     * @return void
     */
    public function restore() {   
	
	$jinput = JFactory::getApplication()->input;
	$h_id = $jinput->getInt('h_id');
	$result = array();
	$result["result"] = "0";	

	//Check session
       	if (!JSession::checkToken() ){
	    $result["message"] = JText::_('SESSION_EXPIRED');
       	}
	require_once NGEPATH_HELPERS . '/ngepartshistoryhelper.php';
	$current_version_data = NgePartsHistoryHelper::getData($h_id);
	$pk = $current_version_data->part_id;
	//Check user ACL
	if (!(NGE::features('nge.pro') && $this->userAllowedToEditPart($pk))){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else //history Id defined ?
	if(!$h_id) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_PART_ID_IN_KEY');
	}
	else{ // get History
	    $lang = JFactory::getLanguage();
	    $lang->load('com_nge_pack',JPATH_SITE);

	    $model = $this->getModel();
	    $return = $model->restore($h_id);

	    $result["result"] = "1";
	    $result["widget"] = $return;
	}            
	print(json_encode($result));
	exit();
    }
    
    
    
     /**
     * NgeControllerPart::storeproperty()
     * store a string into a part property, can by "content" type ("content" field in the database) or "params" type ("params" field in the database)
     * @return success/failure
     */
    public function storeproperty() {

	$jinput = JFactory::getApplication()->input;
	$pk =	$jinput->getInt('pk'); //Existing part id
	$type =	$jinput->get('type', 'params');
	$result = array();
	$result["result"] = "0";
	
	//Check session
       	if (!JSession::checkToken() ){
	    $result["message"] = JText::_('SESSION_EXPIRED');
       	}
	else //Check user ACL
	if (!$this->userAllowedToEditPart($pk, $type)){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else //part Id defined ?	
	if(!$pk) {    		
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_PART_ID_IN_KEY');
    	}
	else { //Storing property	
	    $partModel =    JModelAdmin::getInstance('part', 'NgeModel');
	    $property =	$jinput->get('property');
	    $value =	$jinput->get('value');
	    $callback = 	$jinput->get('callback');

	    $result['result'] = $partModel->storeProperty($pk, $type, $property, $value);

	    //For preview return while inlineediting
	    if ($result['result'])
	    switch ($callback) {
		case 'html' :
		    $result['callback'] = $data->content->html;
		    break;
		case 'article' :
		    require_once (JPATH_ROOT . '/components/com_nge/helpers/data/joomla/articledriver.php');
		    $article = NgeJoomlaArticleDriver::load($value);
		    $result['callback'] = $article->introtext;
		    break;
		case 'module' :
		    require_once (JPATH_ROOT . '/components/com_nge/helpers/data/joomla/moduledriver.php');
		    $result['callback'] = NgeJoomlaModuleDriver::load($value);
		    break;
		case 'url' :
		    require_once (JPATH_ROOT . '/components/com_nge/helpers/data/url/urldriver.php');
		    $result['callback'] = UrlDriver::getContents($value);
		    break;
	    }
	}
	print(json_encode($result));
	exit();
    }
    
    /**
     * NgeControllerPart::createThumbnail()
     * create Thumbnail in local tmp folder to use in fastview
     * @return success/failure
     */
    public function createThumbnail() {
        //TODO RESTE A SECURISE TOKEN
        $jinput         = JFactory::getApplication()->input;
        $widget_id      = $jinput->get('pk');
        $svg            = $_REQUEST["svg"];
        $result         = array();
        
        if($svg === ""){ //Other than chart
            $tmp_png_filename = 'chart_'.$widget_id.'.png';
            $tmp_nge_directory = JPATH_SITE . '/tmp/nge/';
            $tmp_thumb_directory = $tmp_nge_directory . 'thumbs/';
            $output_tmp_jpg = $tmp_thumb_directory.$tmp_png_filename;
            $url = NGEURL_ROOT . 'index.php?option=com_ngd&view=widget&format=html&tmpl=component&id='.$widget_id.'&rendering_mode=preview';

            if(!is_dir($tmp_nge_directory)){
                mkdir($tmp_nge_directory);
            }

            if(!is_dir($tmp_thumb_directory)){
                mkdir($tmp_thumb_directory);
            }

            $output_png = shell_exec('phantomjs '.NGEPATH_ASSETS.'/js/phantomjs_create_thumbnail.js "'.$url.'" "'.$output_tmp_jpg.'"');

            if (!is_file($output_tmp_jpg) || filesize($output_tmp_jpg) === 0) {
                $result['result']  = 0;
                $result['message'] = 'Erreur de création du thumbnail : '.$tmp_png_filename;
            }else{
                $result['result']  = 1;
                $result['message'] = 'Création du thumbnail : '.$tmp_png_filename;
            }
        }else{ //Chart take svg for better rendering performance
            $tmp_svg_filename = 'chart_'.$widget_id.'.svg';
            $tmp_nge_directory = JPATH_SITE . '/tmp/nge/';
            $tmp_thumb_directory = $tmp_nge_directory . 'thumbs/';
            $output_tmp_svg = $tmp_thumb_directory.$tmp_svg_filename;

            if(!is_dir($tmp_nge_directory)){
                mkdir($tmp_nge_directory);
            }

            if(!is_dir($tmp_thumb_directory)){
                mkdir($tmp_thumb_directory);
            }

            if ($svg === "" || !file_put_contents($output_tmp_svg, $svg)) {
                $result['result']  = 0;
                $result['message'] = 'Erreur de création du fichier tmp thumbnail svg : '.$tmp_svg_filename;
            }else{
                $png_filename = 'chart_'.$widget_id.'.png';
                $output_png = $tmp_thumb_directory.$png_filename;

                shell_exec("inkscape -z " . $output_tmp_svg . ' -e ' . $output_png);

                if (!is_file($output_png) || filesize($output_png) === 0) {
                    $result['result']  = 0;
                    $result['message'] = 'Erreur de création du fichier thumbnail png : '.$output_png;
                }else{
                    $result['result']  = 1;
                    $result['message'] = 'Création du thumbnail png : '.$output_png;
                    //Suppression fichier tmp local svg
                    unlink($output_tmp_svg);
                }
            }
        }
        
        print(json_encode($result));
    	exit();
    }
    
    /**
     * NgeControllerPart::updateFormFieldContent()
     * Update field into a form in ajax
     * Used by the ngepattern field in old forms
     * @return success/failure
     */
    public function updateFormFieldContent() {
    	
	$user = JFactory::getUser();
	$result 	= array();
	$result["result"] = '0';	

	if (!NGE::features('nge.premium'))
	    $canEdit = $user->authorise('core.edit', 'com_content');
	else
	    $canEdit = $user->authorise('core.edit', 'com_nge');
	if (!$canEdit){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else {
	    $jinput = JFactory::getApplication()->input;
	    $nameForm =	$jinput->get('nameForm');
	    $pathForm =	$jinput->get('pathForm');
	    $nameField =	$jinput->get('nameField');
	    $newValue =	$jinput->get('newValue');	    
	    $partModel 	= JModelAdmin::getInstance('part','NgeModel');

	    $result['result'] = $partModel->getFieldContent($nameForm, $pathForm, $nameField, $newValue);
	}    
    	print(json_encode($result));
    	exit();
    }
    
    /**
     * NgeControllerPart::updateItem()
     * Update items for part multiple
     * @return object
     */
    /*public function updateItem() {
	
	
	$jinput = JFactory::getApplication()->input;
	$pk =		$jinput->getInt('pk'); //Existing part id
	$part_type =	$jinput->get('part_type');
	$result = array();
	$result["result"] = "0";
	
	//Check user ACL
	if (!$this->userAllowedToEditPart($pk)){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else //part Id defined ?
	if(!$pk) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_PART_ID_IN_KEY');
    	}
	else {		
	    //TODO voir si on créer plutot un controller part multiple et une class ngePartMultiple extend to ngePart  
	    switch ($part_type) {
		    case "navigation.list":
			    require_once (JPATH_ROOT . '/components/com_nge/classes/frontediting/ngenavigationlist.php');
			    $part_navigation_list = new NgeNavigationList($pk); 
			    $status = $part_navigation_list->updateItem($_REQUEST);
		    break;
		    case "navigation.menu":
			    require_once (JPATH_ROOT . '/components/com_nge/classes/frontediting/ngenavigationmenu.php');
			    $part_navigation_menu = new NgeNavigationMenu($pk); 
			    $status = $part_navigation_menu->updateItem($_REQUEST);
		    break;
		    case "panels.tabs":
			    require_once (JPATH_ROOT . '/components/com_nge/classes/frontediting/ngepanelstabs.php');
			    $part_panels_tabs = new NgePanelsTabs($pk);
			    $status = $part_panels_tabs->updateItem($_REQUEST);
		    break;
	    }
	}    	
    	print(json_encode($status));
    	exit();
    }
    */
    
    /**
     * Method to check if you can create a new part
     * @param   int $id id of the part
     * @param   string $nature of the property content/option/display
     * @return  boolean
     */
    private function userAllowedToCreatePart()
    {
	$user = JFactory::getUser();
	//Current user must be authorized to edit part content
	    
	//If simple NGE formulas, user must be author
	if (!NGE::features('nge.premium'))
	    return ($user->authorise('core.create', 'com_content'));
	else 
	    return ($user->authorise('core.create', 'com_nge'));
    }	    
    
    /**
     * Method to check if you can edit an existing part.
     * @param   int $id id of the part
     * @param   string $nature of the property content/option/display
     * @return  boolean
     */
    private function userAllowedToEditPart($id, $nature='content')
    {
	    $user = JFactory::getUser();
	    //Current user must be authorized to edit part content
	    if ($id == '')
		return false;
	    
	    //If simple NGE formulas, user must be author
	    if (!NGE::features('nge.premium'))
		return ($user->authorise('core.edit', 'com_content'));
	    else {
		
		//1 - User can edit the widget : all widgets, or its own
		$canEditWidget = false;
		if ($user->authorise('core.edit', 'com_nge.part.' . $id)){
		    $canEditWidget = true;
		}
		else
		if ($user->authorise('core.edit.own', 'com_nge.part.' . $id)){
		    // Existing record already has an owner, get it
		    require_once (NGEPATH_HELPERS . '/data/nge/partdriver.php');
		    $part = NgeNgePartDriver::load($id);
		    if (empty($part)) 
			$canEditWidget = false;
		    // Grant if current user is owner of the record
		    $canEditWidget = $user->id == $part->created_by;
		}
		//If user cannot edit the widget : abort
		if ($canEditWidget == false)
		    return false;

		//2 - User can edit the content or options
		if ($nature == 'content'){
		    return $user->authorise('core.edit.content','com_nge.part.' . $id);
		}
		else { //Current user must be authorized to edit part params
		    //TODO edit options/display =>change "params" to "options" or "display" ?
		    return $user->authorise('core.edit.options','com_nge.part.' . $id);
		}
	    }
	    return false;
    }
    
    
        /**
     * NgeControllerPart::create_nge_module()
     * Create a module when part has been dropped in a position
     * @param mixed $part_id
     * @param mixed $position
     * @return
     */
    private function create_nge_module($part_id, $position, $plname,$module_before=0) {
    	
    	$model = $this->getModel('module','NgeModel');
    	$model->setState('extension.element','mod_nge');
		$mod = $model->getItem();
		
		// module title = NGE_partname_part_id
		$plname_explode = explode('.',$plname);
		$module_title = 'NGE_'.$plname_explode[count($plname_explode)-1].'_'.$part_id;
		
		
		
		// complete module values
		$mod->title = $module_title;
		$mod->ordering = 1; // default ordering = first
		// get module ordering
		if($module_before!=0) {
			$prev_module = $model->getItem($module_before);
			if($prev_module) {
				$mod->ordering = $prev_module->ordering + 1;
			}
		}

		$mod->position = $position;
		$mod->published = 1;
		$mod->showtitle = 0;
		//2.0.2 No publishup date.
		//If time zone is not correct, the module will not be visible when created.
		//$mod->publish_up = date('Y-m-d H:i:s');
		$mod->params['id'] = $part_id;
		$mod->params['module_tag'] = 'div';
		$mod->params['bootstrap_size'] = '0';
		$mod->params['header_tag'] = 'h3';
		//$mod->params['style'] = '0';
		$mod->params['style'] = 'System-none';
		$mod->language = '*';

		// convert jobject to jregistry
		$jreg_module = new JRegistry();
		$jreg_module->loadObject($mod);

		// save module
		if($model->save($jreg_module->toArray())) {
			$return['result'] = true;
			// rendering module
			$document = JFactory::getDocument();
			$renderer = $document->loadRenderer('module');
			$mod_to_render = JModuleHelper::getModule($mod->module, $mod->title);

			// If the module without the mod_ isn't found, try it with mod_.
			// This allows people to enter it either way in the content
			if (!isset($mod_to_render)) {
			    $name = 'mod_' . $module;
			    $mod_to_render = JModuleHelper::getModule($name, $title);
			}

			//$params = new JRegistry();
			//$params->loadString($mod_to_render->params); //array('style' => 'none');
			$attribs['style'] = 'xhtml';
			$return["m_id"] = $mod_to_render->id;

			$j = new JRegistry();
			$j->loadString($mod_to_render->params);
			$j->set('prepare_content',0);
			
			$mod_to_render->params = $j->toString();
			$content = JModuleHelper::renderModule( $mod_to_render, $attribs );
			
			$params = new stdClass();
			$params->medium = 'modulepreview';
			$return["html"] = JHtml::_('content.prepare',$content,$params);
			
			$return['title'] = $mod->title;
			$return['module'] = $mod->module;
			$return['position'] = $mod->position;
		}
        else
            $return['result'] =  false;
		
		
		return $return;
	}
    
}