<?php 
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');
require_once JPATH_SITE . '/components/com_nge/classes/ngemodulehelper.php';
require_once JPATH_SITE . '/components/com_nge/helpers/ngecontenthelper.php';

/**
 * Module front editing controller class.
 */
class NgeControllerModule extends JControllerForm
{

    function __construct()
    {
        parent::__construct();
    }

    /**
     * NgeControllerConfigmodule::save()
     * 
     * @param mixed $key
     * @param mixed $urlVar
     * @return void
     */
    public function save($key = NULL, $urlVar = NULL){

	$result = array();
	$result["result"] = "0";
	
	if (!JSession::checkToken()) {
 	    $result["message"] = NGE::translate('SESSION_EXPIRED');
 	    print(json_encode($result));
 	    exit();
 	}	
	
	$user = JFactory::getUser();
	$jinput = JFactory::getApplication()->input;
	$data = $_POST;
	$pk = $jinput->getInt('pk', 0);
	$module_before = $jinput->getInt('m_before_id', 0);
	
	
        if ($pk == 0 && (!$user->authorise('core.create', 'com_modules'))){
            $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED');
            echo json_encode($result);
            exit();
        }
        else
        if ($pk != 0 && (!$user->authorise('core.edit', 'com_modules.module.' . $pk))){
            $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
            echo json_encode($result);
            exit();
        }
	
        //Id of the module is sent in the url (GET), adding it to the form data (POST)
        if ($pk != '')
        	$data['id'] = $pk;
         
       	//jModelAdmin::addModelPath(JPATH_ADMINISTRATOR.'components/com_modules/models');
       	//$model = JModelAdmin::getInstance('module','ModulesModel');
       	$model = $this->getModel();
       	 
       	// get module ordering       	
       	if ($module_before != 0)
       	{
       		$prev_module = $model->getItem($module_before);       		 
       		if ($prev_module){
       			$data['ordering'] = $prev_module->ordering;
       		}
       	}

        $return = $model->save($data);

        if ($return){

            $model->getState('module.id');
            //If caller is an editor, we return the module id

            $caller = $jinput->get('caller', '');
            //Caller is inline editing (front or layout). Preview is sent back
            if ($caller == 'layout.position')
            {
                $result["m_id"] = $model->getState('module.id');
                $result["result"] = "1"; //Saving result is OK

                $result["position"] = $jinput->get('position', '', 'string');
                
                // rendering module            
                $result["html"] = NgeModuleHelper::render($result["m_id"]);
                $result["title"] = $jinput->get('title');
                $result["module"] = $jinput->get('module');

                echo json_encode($result);
                exit();
            } else if ($caller == 'layout.article'){

                    $result["m_id"] = $model->getState('module.id');
                    $result["result"] = "1"; //Saving result is OK
                    $jform = $jinput->get('jform', '', 'array');
                    $result["position"] = $jinput->get('position');
                    $result["html"] = $this->renderLoadPosition($result['position']);
                    $result["title"] = $jinput->get('title');
                    $result["module"] = $jinput->get('module');

                    echo json_encode($result);
                    exit();
	}else{
		/*No caller module content editing*/
		$result["result"] = 1;
		$result["message"] = NGE::translate('COM_NGE_EDITING_MSG_SAVE_MODULE');
		echo json_encode($result);
		exit();
	}
        }else{
            $result["result"] = "0"; //Saving result is OK, or session problem
            $result["message"] = $model->getError();
            print (json_encode($result));
            exit();
        }
    }


    /**
     * NgeControllerModule::delete()
     * 
     * @return void
     */
    public function delete()
    {
	$user = JFactory::getUser();
	$jinput = JFactory::getApplication()->input;
	$m_id = $jinput->getInt('m_id', 0);
	$result = array();
	$result["result"] = "0"; // Deleting is not permitted

	if (!JSession::checkToken()) {
		    $result["message"] = NGE::translate('SESSION_EXPIRED');
	}
	else
	if (!$user->authorise('core.delete', 'com_modules.module.' . $m_id)){
		$result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_DELETE_NOT_PERMITTED');		
	}
	else
	if ($m_id == 0){
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_ID_IN_KEY');
	}
	else {
                    JControllerForm::addModelPath(JPATH_ADMINISTRATOR . '/components/com_modules/models');
	    // modify joomla module publish field using admin/com_modules module model  
                    $model = $this->getModel('module', 'ModulesModel');
                    // get module
                    $module = $model->getItem($m_id);
                    //In demo mode, not removed, but do as if it where
                    if (NGE::features('nge.demo') || $model->publish($m_id, -2))
                    {
                    	$result["m_id"] = $module->id;
                    	$result["result"] = "1"; //Publish or unpublished result is OK
                    	$result["position"] = $module->position;
                    	// rendering module
		$result["html"] = NgeContentHelper::parse(NgeModuleHelper::render($module->id));
                    	$result["title"] = $module->title;
                    	$result["module"] = $module->module;
		if (NGE::features('nge.demo'))
		    $result['message'] = NGE::translate('COM_NGE_DEMO_MODE_MESSAGE');
                    }
	}
	
	echo json_encode($result);
	exit();
    }
	    

    /**
     * NgeControllerConfigmodule::duplicate()
     * 
     * @return void
     */
    public function duplicate($key = NULL, $urlVar = NULL) {
    	
	$user = JFactory::getUser();
	$jinput = JFactory::getApplication()->input; 
	$m_id = $jinput->getInt('m_id',0);
	$result = array();
	$result["result"] = "0"; 
	
	if (!JSession::checkToken()) {
	    $result["message"] = NGE::translate('SESSION_EXPIRED');
	}
	else	
	if (!($user->authorise('core.edit', 'com_modules.module.' . $m_id) && $user->authorise('core.create', 'com_modules'))){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED');
	}
	else
	if(!$m_id) {		
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_MODULE_TO_DUPLICATE');
	}
	else {
	    $newModule = NgeModuleHelper::duplicate($m_id);
	    
	    if ($newModule != '')	{
		    $result["result"] = "1"; //Saving result is OK
		    $result["m_id"] = $newModule->id;
		    $result["title"] = $newModule->title;
		    $result["html"] = $newModule->render();
	    } else {
		$result["message"] = $model->getError();
	    }	
	}
				
        print (json_encode($result));
        exit();         
    }

    
    /**
     * NgeControllerConfigmodule::move()
     * 
     * @return void
     */
    public function move() {
        	
	$user = JFactory::getUser();
	$jinput = JFactory::getApplication()->input;         
	$pk = $jinput->getInt('m_id', 0);
	$result = array();
	$result["result"] = "0";
	$newPosition = $jinput->get('end_position','','string');
	$previousModulePk = $jinput->getInt('m_before_id', 0);
	
	if (!JSession::checkToken()) {
	    $result["message"] = NGE::translate('SESSION_EXPIRED');
	}
	else
	if (!$user->authorise('core.edit', 'com_modules.module.' . $pk)){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else
	if ($pk == 0){
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_ID_IN_KEY');
	}
	else {
	    
	    if (NgeModuleHelper::move($pk, $position, $previousModulePk)){            
		$result["pk"] = $pk;
		$result["result"] = "1"; //Saving result is OK
		$result["position"] = $newPosition;
	    } else
	    {
		$result["message"] = NGE::translate('COM_NGE_JS_EDITING_ARTICLE_UNABLE_MOVE_MODULE');
	    }
	}
	
        print (json_encode($result));
        exit();         
    }

    /**
     * NgeControllerConfigmodule::move()
     * 
     * @return void
     */
    public function moduletoarticle() {
	
	$user = JFactory::getUser();
	$jinput = JFactory::getApplication()->input; 
	$module_id = $jinput->getInt('m_id',0);
	$article_id = $jinput->getInt('a_id',0);
	$result = array();
	$result["result"] = "0";
        
	if (!JSession::checkToken()) {
	    $result["message"] = NGE::translate('SESSION_EXPIRED');
	}
	else	
	if ((!$user->authorise('core.edit', 'com_modules.module.' . $module_id) || (!$user->authorise('core.edit', 'com_content.article.' . $article_id)))){
	    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else
	if (($module_id == 0) || ($article_id == 0)){
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_ID_IN_KEY');
	}
	else {
	    // get module 
	    $module_to_move = $model->getItem($module_id);
	    // change module position
	    $module_to_move->position = $model->getNewPositionInArticle($article_id);
	    
	    //TODO si le ordering change changer le ordering de tout les modules suivant de +1
	    // transform module_to_move to jregistry
	    $registry = new JRegistry();
	    $registry->loadObject($module_to_move);

	    // save module
	    $model = $this->getModel();
	    if($model->save($registry->toArray()) ) {
		$result["pk"] = $module_to_move->id;
		$result["result"] = "1"; //Saving result is OK
		$result["position"] = $module_to_move->position;
		$result['title'] = $module_to_move->title;
		$result['module'] = $module_to_move->module;
		$result['html'] = $this->renderLoadPosition($module_to_move->position);

	    } else{
		$result["message"] = $model->getError();
	    }	    
	}
	
	print (json_encode($result));
	exit();         
    }    
    
    /**
     * NgeControllerConfigmodule::renderLoadPosition()
     * 
     * @param mixed $module_title
     * @return
     */
    private function renderLoadPosition($module_title) {
        return '{loadposition '.$module_title.'}';   
        
    }
    
    
}