<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

/**
 * Brik controller class.
 */
class NgeControllerMainbar extends JControllerForm {
    
    /**
     * NgeControllerMainbar::loadContent()
     * load the layout content
     * @return void
     */
    public function content() {
        
	
 	if (!JSession::checkToken('get')) {
 	    echo NGE::translate('SESSION_EXPIRED');
 	    exit();
 	}	
	
    	$attribs = array();
    	$result = array();
    	$jinput = JFactory::getApplication()->input;

	$content = $jinput->get('content', '', 'string');
  
	// If no key, error and stopping script
	if($content !="" ) {
	    
	    //User can use front-editing?
	    $user = JFactory::getUser();
	    $canEditPart = false;
	    if (NGE::features('nge.premium')){
		$canEditPart = $user->authorise('core.create','com_nge');
	    }
	    else
		$canEditPart  = $user->authorise('core.edit', 'com_content');

	    if ($canEditPart == false){
		echo NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	    }
	    else
		include JPath::check(NGEPATH_HELPERS . '/editor/mainbar/'.$content.'/mainbar.'.$content.'.php');
	}
        exit();
		
    }

}