<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once JPATH_COMPONENT . '/controller.php';
require_once NGEPATH_HELPERS . '/data/nge/itemdriver.php';
//require_once NGEPATH_HELPERS . '/ngepartshelper.php';
//require_once NGEPATH_HELPERS . '/forms/fields/ngefields.php';

/**
 * Pattern controller class.
 */
class NgeControllerItem extends NgeController
{
    
    /**
     * Create or update pattern
     */
    public function save(){
	
	if (NGE::features('nge.demo')){
	      $result = array();
                    $result["result"] = "0";
	    $result["message"] = NGE::translate('COM_NGE_DEMO_MODE_MESSAGE');
	    exit();
	}
	else {
	    $user = JFactory::getUser();
	    if (!$user->authorise('page.manage','com_nge')){
		$result = array();
		$result['result'] = "0";
		$result['message'] = JText::_('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	    } else {
		$jinput = JFactory::getApplication()->input;
		$id =		$jinput->getRaw('id'); //id is string and can contain special chars (#)
		$item =		$jinput->get('item');
		$selector =	$jinput->getRaw('selector'); //selector is string and can contain special chars (#)
		$title =		$jinput->get('title');
		$params =		$jinput->getRaw('params');
		$result = NgeItemDriver::save($id, $item, $selector, $title, $params);

	    }
	    echo json_encode($result);
	    exit();
	}
    }
    
    /**
     * Create or update pattern
     */
    public function cssrefresh(){
	
	$result = array();
                $result["result"] = "0";
	$result["message"] = "";
		
	if (NGE::features('nge.demo')){	      
	    $result["message"] = NGE::translate('COM_NGE_DEMO_MODE_MESSAGE');
	    exit();
	}
	else {
	    $user = JFactory::getUser();
	    if (!$user->authorise('page.manage','com_nge')){
		$result['message'] = JText::_('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	    } else {
		$jinput = JFactory::getApplication()->input;
		$id =		$jinput->getRaw('id'); //id is string and can contain special chars (#)
		$item =		$jinput->get('item');
		$selector =	$jinput->getRaw('selector'); //selector is string and can contain special chars (#)
		$title =		$jinput->get('title');
		$params =		$jinput->getRaw('params');
		if(is_string($params))
		parse_str($params, $params);
		$jsonParams = json_encode($params);
		
		//Parse 
		$itempath = explode('.', $item);
		$directories = '';
		$name = "";
		for ($i=0; $i<count($itempath); $i++)
		    $directories .= $itempath[$i].'/';
		$name .= $itempath[count($itempath)-1];
		$path = NGEPATH_ITEMS . '/' . $directories . 'css.php';

		// Load the path
		if (file_exists($path))
		{ 
		    $content = '';
		    //global var for API
		    $item = new stdClass();
		    $item->id = $id;
		    $item->selector = $selector;
		    $item->params = $jsonParams;
		    ob_start();
		    include JPath::check($path);
		    $content = ob_get_contents(); // . $content;
		    ob_end_clean();
		    $result["result"] = "1";
		}
		else
		    $content = '';
		$result['css'] = $content;
	    }
	    echo json_encode($result);
	    exit();
	}
    }
  
    
    public function remove(){

	$user = JFactory::getUser();
	if (!$user->authorise('page.manage','com_nge')){
	    echo json_encode(NgeItemDriver::save($id, $item, $selector, $title, $params));	    
	    $result = array();
	    $result['result'] = "0";
	    $result['status'] = JText::_('JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED');
	} else {
	
	    $jinput = JFactory::getApplication()->input;
	    $id = $jinput->getInt('id');

	    if ($id != ''){
		$result = json_encode(NgeItemDriver::remove($id));
	    }
	    else {
		$result = array();
		$result['result'] = "0";
		$result['status'] = JText::_('JERROR_NO_ITEMS_SELECTED');
	    }
	}
	echo json_encode($result);
	exit();
    }
}
