<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

use Joomla\Filter\InputFilter;

/**
 * Part controller class.
 */
class NgeControllerInline extends JControllerForm
{
    
     /**
     * NgeControllerInline::load()
     * load a value from a single field or property
     * @return success/failure
     */
    public function load() {

 	if (!JSession::checkToken('get')) {
 	    $result["result"] = "0";  // Saving result is not OK : session problem
 	    $result["message"] = NGE::translate('SESSION_EXPIRED');
 	    print(json_encode($result));
 	    exit();
 	}	
	
	$jinput = JFactory::getApplication()->input;
	$id =		$jinput->getInt('id');
	$type =		$jinput->get('type');
	//Reading source value that can contain ":" symbol 
	$source =		$jinput->getRaw('source');
	$filter = new InputFilter();
	$sourceArray = explode(':', $source);	
	for ($i = 0; $i<count($sourceArray); $i++){
	    $sourceArray[$i] = $filter->clean($sourceArray[$i]);
	}
	$source = implode(':', $sourceArray);
	$rendering =	$jinput->get('rendering'); //Rendering=editor : part tags will be redered to be edited wysiwyg in the inline rich editor

	//ACL check will be done in each source
	$result = $this->loadSource($id, $type, $source, $rendering);
    	print(json_encode($result));
	exit();
    }

     /**
     * NgeControllerInline::unpublish()
     * unpublish an element
     * @return json result
     */
    public function publish() {
	$result = array();
	$result["result"] = "0"; // Publishing is not premitted : session expired
	
	if (!JSession::checkToken())
	{
		$result["message"] = NGE::translate('SESSION_EXPIRED');
	} else{
		
	    $jinput = JFactory::getApplication()->input;
	    $id =		$jinput->get('id', '', 'int');
	    $type =	$jinput->get('type', '', 'string');
	    $rendering =	$jinput->get('rendering', '', 'string'); //Rendering=editor : part tags will be redered to be edited wysiwyg in the inline rich editor

	    if (!$id) {
		$result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_ID_IN_KEY');
	    }
	    else
	    if (!$type) {
		$result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_TYPE_DEFINED');
	    }
	    else	//ACL check will be done amng each content type
		$result = $this->setPublish($id, $type, true ,$rendering);
	}
    	print(json_encode($result));
	exit();
    }
    
     /**
     * NgeControllerInline::unpublish()
     * unpublish an element
     * @return json result
     */
    public function unpublish() {
	$result = array();
	$result["result"] = "0"; // Publishing is not premitted : session expired
	
	if (!JSession::checkToken())
	{
		$result["message"] = NGE::translate('SESSION_EXPIRED');
	} else{
		
	    $jinput = JFactory::getApplication()->input;
	    $id =		$jinput->get('id', '', 'int');
	    $type =	$jinput->get('type', '', 'string');
	    $rendering =	$jinput->get('rendering', '', 'string'); //Rendering=editor : part tags will be redered to be edited wysiwyg in the inline rich editor

	    if (!$id) {
		$result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_ID_IN_KEY');
	    }
	    else
	    if (!$type) {
		$result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_TYPE_DEFINED');
	    }
	    else    	//ACL check will be done amng each content type
		$result = $this->setPublish($id, $type, false ,$rendering);
	}
    	print(json_encode($result));
	exit();
    }
    

     /**
     * NgeControllerInline::load()
     * load a value from a single field or property
     * @return success/failure
     */
    private function loadSource($id, $type, $source, $rendering) {

	$result = array();
	$result["result"] = "0";	
	
	// id not found
	if (!$id) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_ID_IN_KEY');
	}
	else
	if (!$source) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_SOURCE_DEFINED');
	}
	else
	switch ($type){
	    case 'article' :
		
		//Current user must be authorized to edit article
		if (!$this->allowEditArticle($id)){
		    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
		    return $result;
		}
		
		try{
		    require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		    $result['value'] = NgeJoomlaArticleDriver::loadInline($id, $source);
		    $result['result'] = 1;
		} catch(Exception $e){
		    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_LOADING_ARTICLE_CONTENT');
		}		
		break;
	    case 'module' :
		
		//Current user must be authorized to edit module
		$user = JFactory::getUser();
		if ($id != '' && (!$user->authorise('core.edit', 'com_modules.module.' . $id))){
		    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
		}		
		
		try{
		    require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
		    $result['value'] = NgeJoomlaModuleDriver::loadInline($id, $source);
		    $result['result'] = 1;
		} catch(Exception $e){
		    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_LOADING_MODULE_CONTENT');
		}		
		break;
	    /*case 'k2item' :
		try{
		    require_once (NGEPATH_HELPERS . '/data/k2/k2itemdriver.php');
		    $result['value'] = NgeK2itemDriver::loadInline($id, $source);
		    $result['result'] = 1;
		} catch(Exception $e){
		    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_LOADING_K2ITEM_CONTENT');
		}		
		break;*/
	    case 'part' :

		$sourceArray = explode(':', $source);
		if (count($sourceArray) >1){
		    $field = $sourceArray[0];
		    $property = $sourceArray[1];
		}
		else {
		    $field = 'content';
		    $property = $source;
		}		
		
		$user = JFactory::getUser();
		//Current user must be authorized to edit part content
		if ($field == 'content'){
		    if ($id != '' && (!$user->authorise('core.edit','com_nge.part.' . $id))){
			//User is owner and can edit?			
			require_once (NGEPATH_HELPERS . '/data/nge/partdriver.php');
			$part = NgeNgePartDriver::load($id);
			if (!(($part->created_by == $user->id) && $user->authorise('core.edit.own', 'com_nge.part.' . $id))){
			    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
			    return $result;
			}
		    }
		}
		else { //Current user must be authorized to edit part params
		    //TODO edit options/display =>change "params" to "options" or "display" ?
		    if ($id != '' && (!$user->authorise('core.edit.options','com_nge.part.' . $id))){
			$result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
			return $result;
		    }
		}

		try{
		    require_once (NGEPATH_HELPERS . '/data/nge/partdriver.php');
		    $result['value'] = NgeNgePartDriver::loadProperty($id, $field, $property);
		    $result['result'] = 1;
		} catch(Exception $e){
		    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_LOADING_PART_CONTENT');
		}		
		break;
	    
	    default :
		$result["message"] = NGE::translate('COM_NGE_EDITING_MSG_UNKNOWN_DATA_TYPE');
		break;	
	}

	
	//Loading inline, we are in etit mode, we can render the parts. They will be editable in wyziwyg.
	//They are rendered without included libraries, that are already in the page	
	if ($rendering == 'editor') {
		require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
		//specify caller (inline), to force loading all parts, even with display conditions
		$params = new stdClass();
		$params->caller = 'inline';
		$result['value'] = NgeContentHelper::parse($result['value'], $params);
	}	
	
	return $result;
    }
    
    
    	    
    /**
     * NgeControllerInline::setPublish()
     * $state : True to publish, False to unpublish
     * @return void
     */
    private function setPublish($id, $type, $stateId, $rendering) {
    
	$result = array();

	$result["result"] = "0";  // Loading result is not OK : session problem
	// id not found
	
	    switch ($type){
		case 'module' :
		    // user authorisation
		    $user = JFactory::getUser();
		    if (!$user->authorise('core.edit.state', 'com_modules'))
		    {
			$result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_ACCESS_FORBIDDEN');
		    } else
			{ 
			    JControllerForm::addModelPath(JPATH_ADMINISTRATOR . '/components/com_modules/models');
			    // modify joomla module publish field using admin/com_modules module model  
			    $model = $this->getModel('module', 'ModulesModel');
			    $module = $model->getItem($id);
			    //If demo, don't publish, but do as if it where
			    if (NGE::features('nge.demo') || $model->publish($id, $stateId))
			    {
				$result["result"] = "1"; //Publish or unpublished result is OK
				require_once JPATH_SITE . '/components/com_nge/classes/ngemodulehelper.php';
				
				//If rendering is editor, we can show unpublished modules. See nge system plugin
				if (($stateId == false) && ($rendering == 'editor')) {
/*				    	if ($module->module != 'mod_nge')
						$result["html"] = '<div id="module-' .$module->id . '" class="ngemodule ngemodule-joomla ngeeditablestructure ngeeditablestructuremodule ngeunpublished" data-module-label="' . $module->title . '" data-module-id="' . $module->id . '" data-module-module="' . $module->module . '">';
					else
						$result["html"] .= '<div id="module-' . $module->id . '" class="ngemodule ngemodule-part ngeeditablestructure ngeeditablestructuremodule ngeunpublished" data-module-label="' . $module->title . '" data-module-id="' . $module->id . '" data-module-module="' . $module->module . '">';*/
					$result["html"] = $module->title;
					//$result["html"] .= '</div>';
				}
				else
				    $result["html"] = NgeModuleHelper::render($module->id);
				
				if (NGE::features('nge.demo'))
				    $result['message'] = NGE::translate('COM_NGE_DEMO_MODE_MESSAGE');
			    }
		}
		break;
	    }
	    if (($result["result"] == '1') && ($rendering == 'editor')) {
		//Loading inline, we are in etit mode, we can render the parts. They will be editable in wyziwyg.
		require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
		$result['html'] = NgeContentHelper::parse($result['html']);
	    }
	    return $result;
    }
    
    
     /**
     * NgeControllerInline::store()
     * store a value in a single field or property
     * @return success/failure
     */
    public function store() {

	$result = array();
	$result["result"] = "0";
	
 	if (!JSession::checkToken()) {
 	    $result["message"] = NGE::translate('SESSION_EXPIRED');
 	    print(json_encode($result));
 	    exit();
 	}	
	
	$jinput = JFactory::getApplication()->input;

	$id =		$jinput->getInt('id', 0);
	$type =		$jinput->get('type');
	//Reading source value that can contain ":" symbol 
	$source =		$jinput->getRaw('source');
	$filter = new InputFilter();
	$sourceArray = explode(':', $source);	
	for ($i = 0; $i<count($sourceArray); $i++){
	    $sourceArray[$i] = $filter->clean($sourceArray[$i]);
	}
	$source = implode(':', $sourceArray);	
	//Using getRaw to get all tags like the <part tags
	$value =		$jinput->getRaw('value');
	$callback =		$jinput->get('callback');

	// part id not found
	if (!$id) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_PART_ID_IN_KEY');
	}
	else
	if (!$source) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_SOURCE_DEFINED');
	}
	else
	switch ($type){
	    case 'article' :
		if (!$this->allowEditArticle($id)){
		    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
		}else {
		    require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		    $result['result'] = NgeJoomlaArticleDriver::storeInline($id, $value, $source);
		    $result['callback'] = $value;
		}
		break;	    
	    case 'joomla.fields' :
		if (!$this->checkEditId('com_content.edit.article', $id)){
		    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
		}else {		
		    require_once (NGEPATH_CONTENTS . '/source/joomla/fields/content.php');
		    $result['result'] = NgeJoomlaFieldsContent::storeInline($id, $value, $source);
		    $result['callback'] = $value;
		}
		break;	    
	    case 'module' :
		$user = JFactory::getUser();
		if ($id != '' && (!$user->authorise('core.edit', 'com_modules.module.' . $id))){
		    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
		} else {				
		    require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
		    $result['result'] = NgeJoomlaModuleDriver::storeInline($id, $value, $source);
		    $result['callback'] = $value;
		}
		break;	    
	    /*case 'k2item' :
		require_once (NGEPATH_HELPERS . '/data/k2/k2itemdriver.php');
		$result['result'] = NgeK2itemDriver::storeInline($id, $value, $source);
		break;*/
	    case 'content_category' :
		if (!$this->allowEditCategory($id)){
		    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
		}else {
		    require_once (NGEPATH_HELPERS . '/data/joomla/categorydriver.php');
		    $result['result'] = NgeCategoryDriver::storeInline($id, $value, $source);
		}
		break;	    
	    /*case 'nge.item' :
		require_once (NGEPATH_HELPERS . '/data/nge/itemdriver.php');
		$result['result'] = NgeNgeItemDriver::storeInline($id, $value, $source);
		break;*/
	    case 'part' :		
		$sourceArray = explode(':', $source);
		 $result['message'] = $source;
		if (count($sourceArray) >1){
		    $field = $sourceArray[0];
		    $property = $sourceArray[1];
		}
		else {
		    $field = 'content';
		    $property = $source;
		}
		if (!$this->allowEditPart($id, $field)){
		    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
		}else {
		    $valueType = $jinput->get('value_type', '', 'string'); //Can be object "object" or single string ""
		    $multiSelect = $jinput->get('multiselect', [], 'array'); //if exist array of index or empty array if not exist
		    require_once (NGEPATH_HELPERS . '/data/nge/partdriver.php');
		   // $result['message'] = $property;
		    $result['result'] = NgeNgePartDriver::storeProperty($id, $value, $field, $property, $valueType, $multiSelect);
		    $result['callback'] = $value;
		}
		break;
	    case 'partarticlelist' :
		//TEmp Add new article in list
		    $dataJson = $jinput->get('data_article', '','array');
		    if(is_array($dataJson))
			    $data = $dataJson;
		    else
			    $data = json_decode($dataJson);
		    
		if (!$this->allowAddArticle($data)){
		    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
		}else {		    
		    require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		    $data['state'] = 1;
		    $data['language'] = '*';
		    $articleId = NgeArticleDriver::create($data);
		    if ($articleId >0){
			//$part->add
			$result['result'] = 1;
			$result['pk'] = $id;
			$params = new stdClass();
			    $params->rendering_mode = 'edit';
			require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
			    $result["html"] = NgePartRendererDefault::render('['.$id.']', $params);
		    }    
		}
		break;	    
	    
	    default :
		$result["message"] = NGE::translate('COM_NGE_EDITING_MSG_UNKNOWN_DATA_TYPE');
		break;	
	}

	
	//For preview return while inlineediting
/*	switch ($callback) {
	    case 'html' :
		$result['callback'] = $data->content->html;
		break;
	    case 'article' :
		require_once (JPATH_ROOT . '/components/com_nge/helpers/data/joomla/articledriver.php');
		$article = NgeArticleDriver::load($value);
		$result['callback'] = $article->introtext;
		break;
	    case 'module' :
		require_once (JPATH_ROOT . '/components/com_nge/helpers/data/joomla/moduledriver.php');
		$result['callback'] = NgeModuleDriver::load($value);
		break;
	    case 'url' :
		require_once (JPATH_ROOT . '/components/com_nge/helpers/data/url/urldriver.php');
		$result['callback'] = UrlDriver::getContents($value);
		break;
	}
*/	
	
	print(json_encode($result));
	exit();
	

    }
     
    /**
     * NgeControllerInline::store()
     * store a value in a single field or property
     * @return success/failure
     */
    public function storeconfig() {

	$result = array();

 	if (!JSession::checkToken()) {
 	    $result["result"] = "0";  // Saving result is not OK : session problem
 	    $result["message"] = JText::_('SESSION_EXPIRED');
 	    print(json_encode($result));
 	    exit();
 	}
	
	$jinput = JFactory::getApplication()->input;

	$id =		$jinput->get('id', '', 'string');
	$type =		$jinput->get('type', '', 'string');
	$ngeparams =	$jinput->get('ngeparams', '', 'string');

	$result["result"] = "0";  // Saving result is not OK : session problem
	// part id not found
	if (!$id) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ID_MISSING');
	}
	else
	switch ($type){
	    case 'article' :
		require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		$result['result'] = NgeJoomlaArticleDriver::storeConfig($id, $value, $source);
		break;	    
	    case 'nge.item' :
		$id =  $jinput->get('id', '', 'string');
		$itemtype = $jinput->get('itemtype', '', 'string');
		$itemtitle = $jinput->get('itemtitle', '', 'string');
		
		require_once (NGEPATH_HELPERS . '/data/nge/itemdriver.php');
		require_once (NGEPATH_HELPERS . '/ngeitemhelper.php');
		//if (NgeNgeItemDriver::storeConfig($id, $itemtype, $itemtitle, $value)){
		if (NgeNgeItemDriver::storeConfig($id, $ngeparams)){
			$render = NgeItemHelper::render($id, $itemtype, $ngeparams);
			if (NgeNgeItemDriver::storeCss($id, $render)){
				$result['result'] = NgeItemHelper::updateCss(); //Update main items css cache
				$result['callback'] = $render;
			}
		}
		break;	    	    
	    case 'pattern' :
		require_once (NGEPATH_HELPERS . '/data/joomla/patterndriver.php');
		$result['result'] = NgeJoomlaArticleDriver::storeConfig($id, $value, $source);
		break;	    
	    case 'part' :		
		break;	    	    
	    default :
		$result["message"] = NGE::translate('COM_NGE_EDITING_MSG_UNKNOWN_DATA_TYPE');
		break;	
	}
		
	print(json_encode($result));
	exit();

    }
    
     /**
     * NgeControllerInline::items()
     * manage multiple items in lists
     * @return success/failure
     */
    public function items() {
	$result = array();
	$result["result"] = "0";  // Saving result is not OK

 	if (!JSession::checkToken('get')) {
 	    $result["message"] = JText::_('SESSION_EXPIRED');
 	    print(json_encode($result));
 	    exit();
 	}
	
	$jinput = JFactory::getApplication()->input;
	$action =		$jinput->get('action');
	$id =		$jinput->getInt('id');
	$type =		$jinput->get('type');
	$source =		$jinput->get('source');
	$value =		$jinput->get('value');
	$label =		$jinput->get('label');
	//$callback =	$jinput->get('callback', '', 'string');

	// part id not found
	if (!$id) {
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_NO_PART_ID_IN_KEY');
	}
	else
	switch ($type){
	    case 'part' :		
		$itemsmode =	str_replace('_', '.', $jinput->get('itemsmode', '', 'string'));	
		require_once (NGEPATH_HELPERS . '/data/nge/partdriver.php');
		switch ($action){
		    case 'add' : 
			switch ($itemsmode){
			    case 'joomla.articles' :
/*				$item =	$jinput->getInt('item');
				$user = JFactory::getUser();				    
				if (!$user->authorise('core.edit.state', 'com_content.article.' . $id)){
				    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
				}
				else {
				    require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
				    $result['result'] = NgeJoomlaArticleDriver::reorderItem($item, $oldIndex, $newIndex);
				}*/
				break;
			    case 'joomla.menu' :
				$item =	$jinput->getInt('item');
				$user = JFactory::getUser();
				if ($user->authorise('core.edit.state', 'com_menus')){
				    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED');
				}
				else {				    
				    require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');				
				    $result['result'] = NgeJoomlaMenuDriver::reorderItem($item, $oldIndex, $newIndex);
				}
				break;
			    default: //part
				if (!$this->allowEditPart($id, 'content')){
				    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
				}
				else
				    $result['result'] = NgeNgePartDriver::addItem($id, $source, $value, $label);
				break;
			}
			break;
		    case 'remove' : 
			$itemId =	$jinput->getInt('item');
			switch ($itemsmode){
			    case 'joomla.articles' : //Joomla blog content
				$user = JFactory::getUser();
				if (!$user->authorise('core.edit.state', 'com_content.article.' . $id)){
				    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
				}
				else {
				    require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
				    $result['result'] = NgeJoomlaArticleDriver::unpublish($itemId);				    
				}
				break;
			    case 'joomla.menu' : //Joomla menus content
				$user = JFactory::getUser();
				if ($user->authorise('core.edit.state', 'com_menus')){
				    $result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED');
				}
				else {
				    require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
				    $result['result'] = NgeJoomlaMenuDriver::unpublish($itemId);
				}
				break;
			    default: //custom contents
				//$index =	$jinput->get('index', '', 'int');
				if (!$this->allowEditPart($id, 'content')){
				    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
				}
				else
				    $result['result'] = NgeNgePartDriver::removeItem($id, $source);
				break;
			}
			break;
		    case 'reorder' : 
			if (!$this->allowEditPart($id, 'content')){
			    $result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
			}
			else{
			    $oldIndex =	$jinput->get('oldindex', '', 'int');
			    $newIndex =	$jinput->get('newindex', '', 'int');
			    switch ($itemsmode){
				case 'joomla.articles' :
				    $item =	$jinput->getInt('item');
				    $user = JFactory::getUser();				    
				    if (!$user->authorise('core.edit.state', 'com_content.article.' . $id)){
					$result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
				    }
				    else {
					require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
					$result['result'] = NgeJoomlaArticleDriver::reorderItem($item, $oldIndex, $newIndex);
				    }
				    break;
				case 'joomla.menu' :
				    $item =	$jinput->getInt('item');
				    $user = JFactory::getUser();
				    if ($user->authorise('core.edit.state', 'com_menus')){
					$result["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED');
				    }
				    else {				    
					require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');				
					$result['result'] = NgeJoomlaMenuDriver::reorderItem($item, $oldIndex, $newIndex);
				    }
				    break;
				default: //custom
				    if (!$this->allowEditPart($id, 'content')){
					$result["message"] = JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $id);
				    }
				    else
					$result['result'] = NgeNgePartDriver::reorderItem($id, $oldIndex, $newIndex);
				    break;
			    }
			}
			break;
		    /*case 'unpublish' : 
			require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
			$result['result'] = NgeJoomlaMenuDriver::unpublish($item);*/
		}
		
		require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
		$result["html"] = NgePartRendererDefault::render('['.$id.']');
		break;
	    
	}	
	print(json_encode($result));
	exit();

    }

    /**
     * Method to check if you can edit an existing part.
     * @param   int $id id of the part
     * @param   string $nature of the property content/option/display
     * @return  boolean
     */
    private function allowEditPart($id, $nature)
    {
	    $user = JFactory::getUser();
	    //Current user must be authorized to edit part content
	    if ($id == '')
		return false;
	    
	    //If simple NGE formulas, user must be author
	    if (!NGE::features('nge.premium'))
		return ($user->authorise('core.edit', 'com_content'));
	    else {
		
		//1 - User can edit the widget : all widgets, or its own
		$canEditWidget = false;
		if ($user->authorise('core.edit', 'com_nge.part.' . $id)){
		    $canEditWidget = true;
		}
		else
		if ($user->authorise('core.edit.own', 'com_nge.part.' . $id)){
		    // Existing record already has an owner, get it
		    require_once (NGEPATH_HELPERS . '/data/nge/partdriver.php');
		    $part = NgeNgePartDriver::load($id);
		    if (empty($part)) 
			$canEditWidget = false;
		    // Grant if current user is owner of the record
		    $canEditWidget = $user->id == $part->created_by;
		}
		//If user cannot edit the widget : abort
		if ($canEditWidget == false)
		    return false;

		//2 - User can edit the content or options
		if ($nature == 'content'){
		    return $user->authorise('core.edit.content','com_nge.part.' . $id);
		}
		else { //Current user must be authorized to edit part params
		    //TODO edit options/display =>change "params" to "options" or "display" ?
		    return $user->authorise('core.edit.options','com_nge.part.' . $id);
		}
	    }
	    return false;
    }
    
    
    /**
     * Method to check if you can edit an existing article.
     * @param   int $id id of the article
     * @return  boolean
     */
    private function allowEditArticle($id)
    {
	    $user = JFactory::getUser();

	    if ($user->authorise('core.edit', 'com_content.article.' . $id)) 
		return true;

	    if ($user->authorise('core.edit.own', 'com_content.article.' . $id)){
		// Existing record already has an owner, get it
		require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		$article = NgeJoomlaArticleDriver::loadTable($id);
		if (empty($article)) 
		    return false;
		// Grant if current user is owner of the record
		return $user->id == $article->created_by;
	    }
	    return false;
    }
    
    /**
     * Method to check if you can add a new article.
     * @param   $id id of the article
     * @return  boolean
     */

    private function allowAddArticle($data = array())
	{
	
		$user = JFactory::getUser();
		
		$categoryId = ArrayHelper::getValue($data, 'catid', $this->input->getInt('filter_category_id'), 'int');
		$allow = null;

		if ($categoryId)
		{
			// If the category has been passed in the data or URL check it.
			$allow = $user->authorise('core.create', 'com_content.category.' . $categoryId);
		}

		if ($allow === null)
		{
			// In the absense of better information, revert to the component permissions.
			return $user->authorise('core.create', 'com_content.category');
		}

		return $allow;
	}
    
    
    
    /**
     * Method to check if you can edit an existing category
     * @param   int $id id of the category
     * @return  boolean
     */
    private function allowEditCategory($id)
    {
	    if ($user->authorise('core.edit', 'com_content.category.' . $id))
		    return true;

	    if ($user->authorise('core.edit.own', 'com_content.category.' . $recordId))
	    {
		require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		$category = NgeJoomlaCategoryDriver::load($id);
		if (empty($category)) 
		    return false;
		// Grant if current user is owner of the record
		return $user->id == $category->created_user_id;
	    }
	    return false;
    }
    
    
    
}