<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

use Joomla\Filter\InputFilter;

require_once JPATH_COMPONENT . '/controller.php';
require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php';
require_once NGEPATH_HELPERS . '/ngepartshelper.php';
require_once NGEPATH_HELPERS . '/forms/fields/ngefields.php';

/**
 * Pattern controller class.
 */
class NgeControllerForm extends NgeController
{ 
    
        /*
     * load
     * Retrieve form html form specific location with params
     * Mulitple forms source available :
     * - Handsontable : Get form for handsontable modal with data passed in url
     * - Pattern : load Pattern data and load form with them
     */
    public function load(){

	if(JFactory::getSession()->checkToken('get')===false) {
	    header("HTTP/1.0 403 Forbidden");
	    exit(JText::_('JINVALID_TOKEN'));
	}
	
	//Parameters
	$jinput = JFactory::getApplication()->input;
	//$source = $jinput->get('source', '','string');
	$key = $jinput->get('key', '', 'string'); //source id, can be id or source:id, for example pattern:123
	$mode = $jinput->get('mode', '', 'string'); //create / edit
	$form = $jinput->get('form', '', 'string'); //form name can be content:name / options::name / display:name for permissions check
	//Reading source value that can contain ":" symbol 
	$form =		$jinput->getRaw('form');
	$filter = new InputFilter();
	$formArray = explode(':', $form);	
	for ($i = 0; $i<count($formArray); $i++){
	    $formArray[$i] = $filter->clean($formArray[$i]);
	}
	$form = implode(':', $formArray);	
	$user = JFactory::getUser();
        
	//Reading form type : can be config_serie or options:config_serie. Prefix is used for permissions. Must be setted or "content" and "display" forms (default="options")
	$formDecode= explode(':', $form);
	if (count($formDecode) > 1){
	    $type = $formDecode[0];
	    $form = $formDecode[1];
	}
	else
	    $type = "options";

	//Reading key source : can be nnn or pattern:nnn
	$keyDecode= explode(':', $key);
	if (count($keyDecode) > 1){
	    $source = $keyDecode[0];
	    $key = $keyDecode[1];
	}
	else
	    $source = "part";
		
	//Load language 
	$lang = JFactory::getLanguage();
	$lang->load('com_nge_pack', JPATH_SITE);

	//Check permissions
	$this->editParams = new stdClass();
	if (NGE::features('nge.premium')){
	    if ($mode == 'edit'){ //Existing part
		    //User can edit parts?
		    $canEditPart = $user->authorise('core.edit','com_nge.part.'.$key);
		    //User can edit its own parts ?
		    if (!$canEditPart){
			if ($user->authorise('core.edit.own', 'com_nge.part.' . $key)){
			    // Existing record already has an owner, get it
			    require_once (NGEPATH_HELPERS . '/data/nge/partdriver.php');
			    $part = NgeNgePartDriver::load($key);
			    if (empty($part)) 
				$canEditPart = false;
			    // Grant if current user is owner of the record
			    $canEditPart = $user->id == $part->created_by;
			}
		    }
		    if ($canEditPart)
		    switch ($type) {
			case "content" :
			    $canEditPart = $user->authorise('core.edit.content','com_nge.part.'.$key);
			    break;
			case "options" :
			    $canEditPart = $user->authorise('core.edit.options','com_nge.part.'.$key);
			    break;
			case "display" :
			    $canEditPart = $user->authorise('core.edit.display','com_nge.part.'.$key);
			    break;
		    }
		    if (!$canEditPart){
			echo NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $key);
			exit();
		    }		    
	    }else { //New part
		$canCreatePart = true;
		if (!$user->authorise('core.create','com_nge.part')) {
		    $canCreatePart = false;
		}else {
		    //If we can create a new part, Content is enabled
		    if (($type == "options") && (!$user->authorise('core.edit.options','com_nge.part')))
			    $canCreatePart = false;
		    else
		    if (($type == "display") && (!$user->authorise('core.edit.display','com_nge.part')))
			    $canCreatePart = false;
		}
		if (!$canCreatePart){
		    echo NGE::translate('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED');
		    exit();
		}
	    }
	}
	else {
	    if ($mode == "create"){
		if (!$user->authorise('core.edit', 'com_content')){
		    echo NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
		    exit();
		}
	    }
	    else{ //edit
		if (!$user->authorise('core.create', 'com_content')){
		    echo NGE::translate('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED');
		    exit();
		}
	    }
	}	    
			
	//Loading data
	if ($mode == "edit"){
	    switch ($source){
		case "part" :
		    require_once NGEPATH_HELPERS . '/ngepartshelper.php';
		    $part = NgePartsHelper::getPart('['.$key.']');
		    $formpath = $part->name;
		    if ($type == "content"){
			$dataParams = $paramsArray = json_decode($part->content, true);
			//Old format V1.0
			if (isset($dataParams['sources']) || isset($dataParams['link_types'])){
			    require_once NGEPATH_HELPERS . '/config/paramsupgrade.php';
			    $dataParams = NgeParamsUpgrade::upgrade10($part->name, $dataParams);
			}
		    }
		    else
			$dataParams = $paramsArray = json_decode($part->params, true);
		    NGEFields::setData($dataParams);
		    break;
		case "pattern" :
		    require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php';
		    $pattern = NgePatternDriver::load($key);
		    $formpath = $pattern->name;
			    $patternType = $pattern->type;
		    if ($type == "content"){
			$dataParams = $paramsArray = json_decode($pattern->content, true);
		    }
		    else
			$dataParams = $paramsArray = json_decode($pattern->params, true);
		    NGEFields::setData($dataParams);
		    break;
	    }
	}
	else //mode create
	    $formpath = $key;

	
	//Setting local vars for subform references
	$data = array();
	$data['key'] = $source . ':' . $key;
	$data['mode'] = $mode;

	
	//Loading form in part directories
	$directories = '';
	$name = "";
	$formpath = explode('.', $formpath);
	for ($i = 0; $i < count($formpath); $i++)
	    $directories .= $formpath[$i] . '/';
	$path = NGEPATH_PARTS . '/' . $directories;	
	$filename = '';
	if(file_exists($path . $form.'.php')){
	    $filename = $path . $form.'.php';
	}
	else
	if(file_exists($path = JPATH_SITE . '/components/com_nge/parts/nge/default/' . $form.'.php'))
		$filename = JPATH_SITE . '/components/com_nge/parts/nge/default/' . $form.'.php';
	else
	if(file_exists(NGEPATH_HELPERS . '/forms/parts/' . $form.'.php'))
		$filename = NGEPATH_HELPERS . '/forms/parts/' . $form.'.php';
	if ($filename != ''){
	    include JPath::check($filename);
	}
	exit();
    }

}