<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

/**
 * Part controller class.
 */
class NgeControllerEditor extends JControllerForm
{

    
     /**
     * NgeControllerEditor::load()
     * load a editor scripts for front-editing
     * @return success/failure
     */
    public function load() {
		
	//User can load front-editing?
	$user = JFactory::getUser();
	$canEditPart = false;
	if (NGE::features('nge.premium')){
	    $canEditPart = $user->authorise('frontediting.edit','com_nge');
	}
	else
	    $canEditPart  = $user->authorise('core.edit', 'com_content');
	
	if ($canEditPart == false){
	    echo NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else {
	    $ngeEditor = NGE::editor();
	    echo $ngeEditor->render();
	}
	exit();
    }    
}