<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once JPATH_COMPONENT . '/controller.php';
require_once JPATH_COMPONENT . '/classes/ngearticlehelper.php';
require_once JPATH_COMPONENT . '/classes/ngemodulehelper.php';
require_once JPATH_COMPONENT . '/classes/ngeimagehelper.php';
require_once(NGEPATH_HELPERS . '/ngeparthelper.php');
//require_once JPATH_COMPONENT . '/classes/ngepart.php';

/**
 * Draggable controller class.
 */
class NgeControllerDraggable extends NgeController
{
    /*public function createElement(){

		$jinput = JFactory::getApplication()->input;
		$element = $jinput->get('element', '', 'string');	

		switch ($element) {
    		case "article":
			case "article_new":
    			$status = self::createElementArticle($_REQUEST);
    			break;
    		case "part":
    			$status = self::createElementPart($_REQUEST);
    			break;
    		case "module":
    			$status = self::createElementModule($_REQUEST);
    			break;
    		case "image":
    			$status = self::createElementImage($_REQUEST);
    			break;
//     		case "document":
//     			$status = self::createElementDocument($_REQUEST);
//     		break;   		
    	}
    	
    	$status["element"] = $element;
    	print(json_encode($status));
    	exit();
    }*/
	
    public function updateElement(){

	if(JFactory::getSession()->checkToken('get')===false) {
	    header("HTTP/1.0 403 Forbidden");
	    exit(JText::_('JINVALID_TOKEN'));
	}	
	
	$jinput = JFactory::getApplication()->input;
	$element = $jinput->get('element', '', 'string');
	$destination = $jinput->get('destination', '', 'string');

    	switch ($element) {
    		case "part":
		    $status = self::updateElementPart($_REQUEST);
		    break;
    		case "module":
		    $status = self::updateElementModule($_REQUEST);
		    break;
    	}
    	 
    	$status["element"] = $element;
    	$status["destination"] = $destination;
    	print(json_encode($status));
    	exit();
    }
    
    private function updateElementModule($data){
    	$res = array();
	$res["success"] = 0;
    	
	$jinput = JFactory::getApplication()->input;
	$m_id = $jinput->getInt('m_id', 0);
	$destination = $jinput->get('destination', '');

	$user = JFactory::getUser();
	if ($m_id != 0 && (!$user->authorise('core.edit', 'com_modules.module.' . $m_id))){
	    $res["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else
	    switch ($destination) {
    		case "position":
			$end_position = $jinput->get('end_position', '');
    			$m_before_id = $jinput->getInt("m_before_id", null);
			
	    		if(NgeModuleHelper::move($m_id, $end_position, $m_before_id)){
			    $res["success"] = 1;
	    		}else{
			    $res["message"] = NGE::translate('COM_NGE_EDITING_MSG_UPDATE_MODULE_IN_POSITION');
	    		}				
    		break;  
    		case "article":
			$articleId = $jinput->getInt('articleId', null);
			if (($articleId == null) || (!$user->authorise('core.edit', 'com_content.article.' . $articleId))) {
			    $res["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
			}
			else {
			    $newPosition = NgeArticleHelper::getNewPosition($data["articleId"]);

			    if (NGEModuleHelper::move($m_id, $newPosition)){
				$res["success"] = 1;				    
				$res["html"] = NgeArticleHelper::renderPosition($newPosition);	
			    }else{
				$res["message"] = NGE::translate('COM_NGE_EDITING_MSG_UPDATE_MODULE_IN_ARTICLE');
			    }	
			}
    		break;
    		case "page" :
    			//Not possible
    		break;
	    }
    
    	return $res;
    }
    
    private function updateElementPart($data){
    	$res = array();
	$res["success"] = 0;
	
	$jinput = JFactory::getApplication()->input;
	$part_id = $jinput->getInt('part_id', 0);
	$part_type = $jinput->get('part_type', '');
	$end_position = $jinput->get('end_position', '');
	$m_before_id = $jinput->getInt('m_before_id', 0);

	//User can edit parts?
	$user = JFactory::getUser();
	$canEditPart = false;
	if (NGE::features('nge.premium')){
	    $canEditPart = $user->authorise('core.edit','com_nge.part.' . $part_id);
	}
	else
	    $canEditPart  = $user->authorise('core.edit', 'com_content');
	
	if ($canEditPart == false){
	    $res["message"] = NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
	}
	else
    	switch ($data['destination']) {
	    case "position":
		    $module = NgeModuleHelper::createNgeModule($part_id, $part_type, $end_position, $m_before_id);

		    if($module == false){
			    $res["message"] = NGE::translate('COM_NGE_EDITING_MSG_CREATING_NGE_MODULE');
		    }else {
			    $res["success"] = 1;
			    $res["part"] = new stdClass();
			    $res["module"] = new stdClass();
			    $res["part"]->id = $part_id;
			    $res["module"]->id = $module->id;
			    $res["html"] = $module->render();//contenu html du module;
		    }
	    break;
	    case "article" :
		    //Nothing to do
	    break;
	    case "page" :
		    //Nothing to do
	    break;
    	}
    
    	return $res;
    }
    
	private function createElementArticle($data){
		$res = array();
		
		//First : create the article if new (ref ="") or get object article if exist		
		if(isset($data['ref']) && ($data['ref'] != "")){ //If new we create them
			$article = NgeArticleHelper::getArticle($data['ref']);
		}else{ //Else, get Article information with his ref (id)
			$article = NgeArticleHelper::createArticle(
				array(
					"title"=>		$data['title'], 
					"introtext"=>	"Tantum autem cuique tribuendum, primum quantum ipse efficere possis, deinde etiam quantum ille quem diligas atque adiuves, sustinere. Non enim neque tu possis, quamvis excellas, omnes tuos ad honores amplissimos perducere, ut Scipio P. Rupilium potuit consulem efficere, fratrem eius L. non potuit. Quod si etiam possis quidvis deferre ad alterum, videndum est tamen, quid ille possit sustinere.",
					"catid"=>		$data['category']
				)
			);
		}

		if (($article == false) || ($article->id == '')){
			$res["success"] = 0;
			$res["message"] = NGE::translate('COM_NGE_EDITING_MSG_CREATING_ARTICLE');
			return $res;
		}
		
		//Second : create the part depending on the part type that we want (ex: panels.panel, text.title...)
		$data_part_create = array();
		switch ($data['part_type']) {
			case 'panels.panel':
				$data_part_create = array(
					"name"=>		$data['part_type'], 
					"content"=>	'{"content":{"source":"article","article":"'.$article->id.'"}}'
				);
				break;
			case 'panels.expandable':
				$data_part_create = array(
						"name"=>		$data['part_type'],
						"content"=>	'{"content":{"source":"article","article":"'.$article->id.'"}}'
				);
				break;
			case 'navigation.introduction':
				//TODO a faire
				echo "draggable.php -> createElementArticle() cas navigation.introduction à faire quand le part existe";
				exit();
				break;
			case 'navigation.link':
				$data_part_create = array(
						"name"=>		$data['part_type'],
						"content"=>	'{"label":"'.$article->title.'","link":{"type":"article","menu":"","article":"'.$article->id.'","url":"","file":""}}'
				);
				break;
		}
		
		$part = NgePartHelper::createPart($data_part_create);
		
		if($part == false){
			//Error to save the part
			$res["success"] = 0;
			$res["message"] = NGE::translate('COM_NGE_EDITING_MSG_CREATING_PART');
			return $res;
		}
		
		//Third : we return result depending on the destination
		$res["part"] = new stdClass();
		$res["article"] = new stdClass();
		$res["part"]->id = $part->id;
		$res["article"]->id = $article->id;
		
		switch ($data['destination']) {
			case 'article':
			case 'page':
				$res["success"] = 1;
				$res["html"] = $part->render(array("rendering"=>"edit"));//contenu html du part;
				break;
			case "position":
				$module = NgeModuleHelper::createNgeModule($part->id, $data['part_type'], $data["endPosition"], $data["m_before_id"]);

				if($module == false){
					$res["success"] = 0;
					$res["message"] = NGE::translate('COM_NGE_EDITING_MSG_CREATING_MODULE');
				}else {
				
					$res["success"] = 1;
					$res["module"] = new stdClass();
					$res["module"]->id = $module->id;
					$res["html"] = $module->render();//contenu html du module;
				}	
			break;
		}
		
		return $res;
	}
	
	private function createElementPart($data){
		$res = array();
		//Nothing for the moment because we use the config PART view to create a PART (old)
		return $res;
	}
	
	private function createElementModule($data){
		$res = array();

		switch ($data["destination"]) {
			case "position":
				//Nothing for the moment because we use the config module view to create a module (old)
				break;
			case "article":
				$data['position'] = NgeArticleHelper::getNewPosition($data["articleId"]);
				$module = NgeModuleHelper::createModule($data);
				
				if($module == false){
					$res["success"] = 0;
					$res["message"] = NGE::translate('COM_NGE_EDITING_MSG_CREATING_MODULE_IN_ARTICLE');
				}else{
					$res["success"] = 1;
					$res["module"] = new stdClass();
					$res["module"]->id = $module->id;
					$res["html"] = NgeArticleHelper::renderPosition($module->position);//contenu html du module in article layout;				
				}				
				break;
			case "page" :
				//Not possible
				break;
		}
		
		return $res;
	}
	
	private function createElementImage($data){
		$res = array();
		$path = str_replace("\\", '/', $data["ref"]);
				
		//First : create the part depending on the part type that we want (ex: panels.panel, text.title...)
		switch ($data['part_type']) {
			case 'images.image' :
				$part = NgePartHelper::createPart(
					array(
						"name"=>		$data['part_type'],
						"content"=>	'{"image":"'.addslashes($path).'"}'
					)
				);
				break;
			case 'galleries.slider' :
				$part = NgePartHelper::createPart(
					array(
						"name"=>		$data['part_type'],
						"content"=>	'{"sources":["image","image","image","image","image","image","image","image","image","image","image","image"],"images":["'.addslashes($path).'","","","","","","","","","","",""],"captions":["","","","","","","","","","","",""],"count":"1"}',
						"params"=>	'{"slider":{"fillmode":"0","startindex":"0","loop":"1","scale":"1","arrowkeynavigation":"0","width":"600","height":"300","autoplay":"1","autoplaysteps":"1","autoplayinterval":"3000","pauseonhover":"1","cursoronhover":"0","slideduration":"500","slidespacing":"0","playorientation":"1","dragorientation":"1"},"slideshow":{"mode":"one","transition":"{$Duration:700,$Opacity:2,$Brother:{$Duration:1000,$Opacity:2}}"},"caption":{"hpadding":"12","vpadding":"8","font":{"style":"default","class":"","name":"Default","color":"#666666","size":"30","letter_spacing":"0","weight":"normal","italic":"0"},"background":{"style":"none","color":"#eeeeee","color2":"#ffffff","image":"","opacity":"100"},"positions":{"vertical":{"position":"bottom","height":"15","margin":"0"},"horizontal":{"position":"full","width":"30","margin":"0"}}},"navigator":{"arrow":{"display":"1","skin":"01","steps":"1"},"bullet":{"display":"1","skin":"01","autocenter":"1","steps":"1"}},"header":{"placement":"top","align":"left","hpadding":"12","vpadding":"8","tag":"h3","font":{"style":"default","class":"","name":"Default","color":"#666666","size":"30","letter_spacing":"0","weight":"normal","italic":"0"},"glyph":{"placement":"left","size":"30","color":"#666666"},"background":{"style":"none","color":"#eeeeee","color2":"#ffffff","image":"","opacity":"100"}},"border":{"style":"none","placements":["left","top","bottom","right"],"width":"1","color":"#cccccc","radius_placements":["topleft","topright","bottomleft","bottomright"],"radius_width":"0"},"background":{"style":"none","color":"#eeeeee","color2":"#ffffff","image":"","opacity":"100"},"shadow":{"display":"none","style":"light"},"display":{"phone":"1","tablet":"1","desktop":"1","printer":"1"},"width_mode":"custom","select_size_all":"pourcent","width":"100","width_select":"pourcent","margin_top":"0","margin_top_select":"pourcent","margin_right":"0","margin_right_select":"pourcent","margin_bottom":"0","margin_bottom_select":"pourcent","margin_left":"0","margin_left_select":"pourcent","size":{"properties":"0"},"publish":{"published":"1"},"access":{"display":"1","content":"3","options":"3"},"ngeversion":"1.0"}'
					)
				);
				break;
			default :
				$part = false;
		}

		if(($data['part_type'] != 'html.img') && (($part == false))){
			//Error creating the part
			$res["success"] = 0;
			$res["message"] = NGE::translate('COM_NGE_EDITING_MSG_CREATING_PART');
			return $res;
		}else if(($data['part_type'] != 'html.img') && (($part != false))){
			$res["part"] = new stdClass();
			$res["part"]->id = $part->id;
		}
		
		//Second : we return result depending on the destination
		switch ($data['destination']) {
			case 'article':
				switch ($data['part_type']) {
					case "html.img":
						$res["html"] = NgeImageHelper::render($path);
						$res["success"] = 1;
						break;
					default:
						$res["success"] = 1;
						$res["html"] = $part->render(array("rendering"=>"edit"));//contenu html du part;
						break;
				}
				break;
			case 'page':
				$res["success"] = 1;
				$res["html"] = $part->render(array("rendering"=>"edit"));//contenu html du part;
				break;
			case "position":
				$module = NgeModuleHelper::createNgeModule($part->id, $data['part_type'], $data["endPosition"], $data["m_before_id"]);

				if($module == false){
					$res["success"] = 0;
					$res["message"] = NGE::translate('COM_NGE_EDITING_MSG_CREATING_MODULE');
				}else {
				
					$res["success"] = 1;
					$res["module"] = new stdClass();
					$res["module"]->id = $module->id;
					$res["html"] = $module->render();//contenu html du module;
				}	
			break;
		}
	
		return $res;
	}
	
// 	private function createElementDocument(currentDestination, $ref, part_type=’’){
// 		$res = array();
// 		$path = $ref;
		
// 		if(currentDestination == "article"){
// 			$res["success"] = 1; //Success 1 - error 0
// 			$res["html"] = '<img src="'.$path.'">';
// 		}else if(currentDestination == "page"){
// 			//on crée le part en fonction du type de part que l'on veut
// 			$part = createPart(part_type) return pk (id) du part, et le contenu html
		
// 			//Ensuite on crée le module branché sur le part
// 			$module = createModule(partPk) return m_id, m_title, part information, article information, html
		
// 			Soit
// 			$res["success"] = 1; //Success 1 - error 0
// 			$res["module"] = $module;
// 			$res["part"] = $part;
// 			$res["html"] = contenu html du part;
// 		}else if(currentDestination == "page"){
// 			//on crée le part en fonction du type de part que l'on veut
// 			$part = createPart(part_type) return pk (id) du part, et le contenu html
// 			$propriete = ["image=".path];
// 			$part = createPart(part_type, propriété(array)) return pk (id) du part, et le contenu html
		
// 			Soit
// 			$res["success"] = 1; //Success 1 - error 0
// 			$res["part"] = $part;
// 			$res["html"] = contenu html du part;
// 		}else if(currentDestination == "page"){
// 			//on crée le part en fonction du type de part que l'on veut
// 			$part = createPart(part_type) return pk (id) du part, et le contenu html
// 			$propriete = ["image=".path];
// 			$part = createPart(part_type, propriété(array)) return pk (id) du part, et le contenu html
		
// 			//Ensuite on crée le module branché sur le part
// 			$module = createModule($part->pk) return m_id, m_title, part information, article information, html
		
// 			Soit
// 			$res["success"] = 1; //Success 1 - error 0
// 			$res["module"] = $module;
// 			$res["part"] = $part;
// 			$res["html"] = contenu html du module;
// 		}
// 	}									
}