<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once JPATH_COMPONENT . '/controller.php';

/**
 * Pattern controller class.
 */
class NgeControllerCheck_authentication extends NgeController
{
    public function check(){
    	$user = JFactory::getUser();
    	$result = array();  
        
        if($user->guest == 1){
            /*Is not connected or session is finish*/
            $result["result"] = 0;
            $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_SESSION_FINISHED');
        }else{
            $result["result"] = 1;
            $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_USER_NOT_CONNECTED');
        }
    	
    	print(json_encode($result));
    	exit();
    }
    
    public function login(){
    	$app = JFactory::getApplication();
        $jinput = $app->input;
        $login_array = array('username' => $jinput->get('username', '', 'USERNAME'), 'password' => $jinput->get('password', '', 'RAW'));
    	$isLogged = $app->login($login_array);  
        $newtoken = JSession::getFormToken();
        
        if($isLogged == 1){
            $result["result"] = 1;
            $result["message"] = NGE::translate( "COM_NGE_AUTH_LOGIN_SUCCESS" );
            $result["token"] = $newtoken;
        }else{
            $result["result"] = 0;
            $result["message"] = NGE::translate( "COM_NGE_AUTH_LOGIN_FAILED" );
        }
    	
    	print(json_encode($result));
    	exit();
    }
}