<?php
/**
 * @package     NextGenEditor
 * Data structure for all thumbnails based widgets
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/*
 * Storage data structure for generic charts
 * Categories and series can contain different formats.
 * These two properties will be transmitted directly to highcharts.
 * The available formats are those that are usable in highcharts.
 * some more properties can be added, especially for specific properties for one serie or one point
 */
class NgeContentStructureChart
{
    
	public $annotations; //Chart annotation
	public $title; //Main chart title
	public $subtitle; //Main chart subtitle
	public $xaxistitle; //xAxis title
	public $yaxistitle; //yAxis title
	public $legendtitle; //Legend title
	public $series; //Array of series ("name"->serieName, "data"->array) The array of data can be of different kinds : ('x'=>label, 'y'=>value), (label, value), value
	public $categories; //Array of point labels [0-n]
	public $information; //Extra information data
	
	function __construct(){

		$this->annotations = array();
		$this->title = '';
		$this->subtitle = '';
		$this->xaxistitle;
		$this->yaxistitle;
		$this->legendtitle;
		$this->series = array();
		$this->categories = array();
		$this->information = array();
	}
	
	function addSerie($name, $data){
	    $serie = array();
	    $serie['name'] = $name;
	    $serie['data'] = $data;
	    $this->series[] = $serie;
	}
}