<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

require_once(NGEPATH_CONTENTS . '/source/contentsource.php');
$com_path = JPATH_SITE.'/components/com_content/';
require_once $com_path.'helpers/route.php';

class NgeVideoContent extends NgeContentSource
{
	static function loadBody($value, $params=array())
	{
		$dataVideo = new stdClass();				    
		$dataVideo->content = $params;
	    return NGE::layout('nge.parts.media.html.video_html', $dataVideo);

		
	}
	
	/**
	 * Get Available fields. Will be used in layout display for example
	 */
	static function getFields(){
	    
	    $fields = array();
	    return $fields;
	}
	
	static function loadList($params)
	{		
		$ordering = (isset($params->ordering) && ($params->ordering != '')) ? 	$params->ordering: 'ordering';
		$count =		isset($params->count) ? 	$params->count: 0;
		$category =	isset($params->category) ? 	$params->category: '';		
		$author =		isset($params->author) ? 	$params->author: '';		
		$featured =	isset($params->featured) ? 	$params->featured: '';		
		$tags =		isset($params->tags) ?	$params->tags: '';		
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select("a.id, a.title, a.alias, a.catid, a.created_by as author, a.introtext, date(a.created) as created, time(a.created) as created_time, a.hits");
		$query->select('ua.name AS author')
			->join('LEFT', '#__users AS ua ON ua.id = a.created_by');
		$query->select('c.title AS category, c.alias AS category_alias')
			->join('LEFT', '#__categories AS c ON c.id = a.catid');
		$query->from("#__content AS a");
		$query->where("state !=-2");

		if ($category != ''){
			if (is_array($category)){
				$category = ArrayHelper::toInteger($category);
				$query->where('a.catid in ('.implode($category, ',').')');
			}
			else
				$query->where('a.catid =' . (int) $category);
		}
		if ($author != ''){
			if (is_array($author)){
				$author = ArrayHelper::toInteger($author);
				$query->where('a.created_by in ('.implode($author, ',').')');
			}
			else
				$query->where('a.created_by =' . (int) $author);
		}
		if ($tags != ''){
			if (is_array($tags)){
				$tags = ArrayHelper::toInteger($tags);
				$query->where('a.created_by in ('.implode($tags, ',').')');
			}
			else
				$query->where('a.created_by =' . (int) $tags);
		}
		if ($featured != ''){
				$query->where('a.featured =' . (int) $featured);
		}
		switch ($ordering){
			case 'popular':
				$ordering = 'hits DESC';
				break;
			case 'latest':
				$ordering = 'created DESC';
				break;
		}
				
		$query->order($ordering);
		if ($count != 0)
			$query->setLimit($count); 
		//if ($category != '')
		//	$query->where('a.catid = '.$category);

		$db->setQuery($query);
		$items = $db->loadObjectList();

		foreach ($items as &$item){
			$item->slug = $item->id.':'.$item->alias;
			if (isset($item->category_alias))
				$item->catslug = $item->catid ? $item->catid .':'.$item->category_alias : $item->catid;
			else
				$item->catslug = $item->catid;
				
		//	if ($access || in_array($item->access, $authorised))
		//	{
				// We know that user has the privilege to view the article
				$item->link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug));
		//	}
		}
		
		// get article active in page?
		$current_article = 0;
		$jinput = JFactory::getApplication()->input;
		$option = $jinput->get('option','');
		$view = $jinput->get('view','');
		$idarticle = $jinput->get('id','');
		if($option=='com_content' && $view=='article') {
			  $current_article = $idarticle;
		}
		// Prepare data for display using display options
		foreach ($items as &$item){
			if (isset($item->images))
				$item->images  = json_decode($item->images);
            
			// is item active ?
			$item->active = false;
			if($item->id==$current_article)
				$item->active = true;
		}
		
		return $items;	
	}
	
}