<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(NGEPATH_CONTENTS . '/source/contentsource.php');

class NgeQueryContent extends NgeContentSource
{
    
	static function getLabel($data, $params){

	    switch ($params->layout->mode) {
		case 'fields' :
		    //Default label: first field
		    return current($data);
		    break;
		case 'template' :
		    require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
			$item = new stdClass();
			$item->editable = false;
			return SmartyRenderer::renderString($data, $params->layout->template->label);
		    break;
	    };		
	}

	static function getBody($data, $params)
	{
	    //$data is a row record
	    $item = new stdClass();
	    $item->editable = false;
	    
	    switch ($params->layout->mode) {
		case 'fields' :
		    $htmlRow = '<table class="table">';
		    $firstField = true;
		    foreach ($data as $key=>$value) {
			if ($firstField == true){
			    $item->label = $value;
			    $firstField = false;
			}
			$htmlRow .= '<tr><td>'.$key.'</td><td>'.$value.'</td></tr>' ;
		    }
		    $htmlRow .= '</table>';
		    return $htmlRow;
		    break;
		case 'template' :
		    require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
			$item = new stdClass();
			$item->editable = false;
			return SmartyRenderer::renderString($data, $params->layout->template->body);
		    break;
	    };		
	}
	
	/**
	 * Get Available fields. Will be used in layout display for example
	 */
	static function getFields(){
	    
	    $fields = array();
	    $fields[] = array('name'=>'title', 'label'=>'Title', 'type'=>'text');
	    $fields[] = array('name'=>'author', 'label'=>'Author', 'type'=>'text');
	    $fields[] = array('name'=>'created', 'label'=>'Created date', 'type'=>'text');
	    $fields[] = array('name'=>'modified', 'label'=>'Modified date', 'type'=>'text');
	    $fields[] = array('name'=>'published', 'label'=>'Published date', 'type'=>'text');
	    $fields[] = array('name'=>'images.image_intro', 'label'=>'Intro image', 'type'=>'image');
	    $fields[] = array('name'=>'category', 'label'=>'Category', 'type'=>'text');
	    $fields[] = array('name'=>'introtext', 'label'=>'Intro text', 'type'=>'editor');
	    $fields[] = array('name'=>'fulltext', 'label'=>'Full text', 'type'=>'editor');
	    return $fields;
	}
	
	/**
	 * Loading single resultset
	 * @param type $value
	 * @param type $params
	 * @return type
	 */
	static function loadBody($value, $params=array()){
	    $query = $value;
	    try {
		$result = '';
		if ($query != ''){
			$db = JFactory::getDbo();
			$db->setQuery($query);
			$data = $db->loadObject();
			return self::getBody($data, $params);
		}
		else
			 return '';	    
	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return '';
	    }		
	}
	
	/**
	 * when multiple content
	 * get a result with multiple items
	 * @param type $params
	 * @return type
	 */
	static function loadList($params)
	{		
	    $query = $params->query;
	    try {
		$result = '';
		if ($query != ''){
			$db = JFactory::getDbo();
			$db->setQuery($query);
			$result = $db->loadAssocList();
			return $result;
		}
		else
			 return null;	    
	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return null;
	    }
	}
	
}