<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(NGEPATH_CONTENTS . '/source/contentsource.php');

class NgeNetworksContent extends NgeContentSource
{
	
    /**
    * Get data and format it to be rendered in a "buttonbar" like widget
    * @param type $params
    * @return \NgeContentStructureThumbnails
    */
    static function getListData($params){
		
	require_once (NGEPATH_CONTENTS . '/structure/list.php');

	$items = array();
	foreach ($params->content->networks->networks as $selectedNetwork){
		if (isset($params->networks[$selectedNetwork])){
		    $networkParams = $params->networks[$selectedNetwork];
		    $item = new NgeContentStructureList();
		    
		    $glyphleft = '<span class="icomoon '.$networkParams->glyph . '" style="display:table-cell; vertical-align:middle; padding-right:8px"></span>';
		    $item->label = $glyphleft . $networkParams->label;
		    $item->label = $glyphleft;
		    $item->glyph->name = $networkParams->glyph;
		    $item->color = $networkParams->color;
		    $items[] = $item;
		}
	}
	    return $items;
    }
}