<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;
require_once(NGEPATH_CONTENTS . '/source/contentsource.php');
$com_path = JPATH_SITE.'/components/com_content/';
require_once $com_path.'helpers/route.php';

class NgeJoomlaArticleContent extends NgeContentSource
{
	
    
        /**
    * Get data and format it to be rendered in a "buttonbar" like widget
    * @param type $params
    * @return \NgeContentStructureThumbnails
    */
    static function getListData($params){
		
	require_once (NGEPATH_CONTENTS . '/structure/list.php');

    	    $items = self::loadList($params, 'link');

	    $buttonItems = array();
	    foreach ($items as $item){
	    
	    	    $buttonItem = new NgeContentStructureList();
		    $buttonItem->id = $item->id;
		    $buttonItem->label = $item->title;
		    $buttonItem->link = $item->link;
		    $buttonItem->active = $item->active;
		    $buttonItems[] = $buttonItem;
	    }
	    return $buttonItems;
    }
	    
	        
        /**
    * Get data and format it to be rendered in a "thumbnails" like widget
    * @param type $params
    * @return \NgeContentStructureThumbnails
    */
    static function getThumbnailsData($params){
		
	require_once (NGEPATH_CONTENTS . '/structure/thumbnails.php');

	$items = array();

	$data = self::loadList($params->content->joomla_article, 'body');

	if (!isset($params->content->joomla_article->layout))
	    $params->content->joomla_article->layout = new stdClass();
	$params->content->joomla_article->layout->mode = 'intro';

	    switch ($params->content->joomla_article->layout->mode) {
		case 'full' :
		    foreach ($data as $row) {
			$item = new NgeContentStructureThumbnails();
			$item->header->label = $row->title;
			$item->body = $row->full;		
		    }				    
		    break;
		case 'template' :
			require_once (NGEPATH_HELPERS . '/renderer/mustache/mustacherenderer.php');
			foreach ($data as $row) {
				$item = new NgeContentStructureThumbnails();
				if ($params->content->database_query->layout->template->label != '')
				    $item->header->label = MustacheRenderer::renderString($row, $params->content->database_query->layout->template->label);
				if ($params->content->database_query->layout->template->body != '')
				    $item->body = MustacheRenderer::renderString($row, $params->content->database_query->layout->template->body);
				if ($params->content->database_query->layout->template->caption != '')
				    $item->caption = MustacheRenderer::renderString($row, $params->content->database_query->layout->template->caption);
				/*else
				if ($data->content->database_query->layout->template->source == 'file')
					$item->body = SmartyRenderer::render($contentRow, $data->content->database_query->layout->template->file);*/
				$items[] = $item;
			}
			break;
		default : //intro
			foreach ($data as $row) {
			    $item = new NgeContentStructureThumbnails();
			    $item->header->label = '<a href="' . $row->link . '">' . $row->title . '</a>';
			    $item->link = $row->link;

			    //Body
			    if (isset($row->images->image_intro) && $row->images->image_intro != ''){
				$item->body =  '<div class="ngearticle"><a href="' . $item->link . '"><img src="' . NGE::url('root') . $row->images->image_intro . '"/></a></div>';
				$item->legend = substr(strip_tags ($row->introtext), 0, 200) . '&nbsp;...';
			    }
			    else {
				    //If any existing image in the article, find and keep the first one
				    $img = '';
				    $posImg = strpos($row->introtext, '<img');
				    if ($posImg !== false) {
					$posEndImg = strpos(substr($row->introtext, $posImg), '>');
					$img = substr($row->introtext, $posImg, $posEndImg+1);
				    }
				    $text = substr(strip_tags ($row->introtext), 0, 200) . '&nbsp;...';
				    $text = substr($text, 0, strrpos($text, ' ')) . '&nbsp;...';

				    //$text = substr($articlesList[$i]->introtext, 0, strrpos(substr($articlesList[$i]->introtext, 0, 200), ' ')) . '&nbsp;...';
				    //$text = substr($articlesList[$i]->introtext, 0, strrpos(substr($articlesList[$i]->introtext, 0, 200), ' ')) . '&nbsp;...';
				    //$item->body = $img . $text;
				    //if ($data->content->joomla_article->renderer->intro->legend->link == 1)
					$item->body = '<a class="ngearticle" href="' . $item->link . '">' . $img . '</a>' . $text;
				    //$item->body = $img . $text;
			    }
			    $items[] = $item;
			}
			break;		    
	    }			    
	    return $items;
    }
   
    
    static function loadBody($value, $params=array())
	{
		$id = $value;
		$result = new stdClass();
		
		$articleTable = JTable::getInstance("content");
		$articleTable->load($id);
		$result->introtext = 	$articleTable->get("introtext");
		$result->fulltext = 	$articleTable->get("fulltext");
		//Full content (see article model)
		$result->articletext = trim($result->fulltext) != '' ? $result->introtext . "<hr id=\"system-readmore\" />" . $result->fulltext : $result->introtext;
		//default content
		//cf com_content view_html.php
		/*
		if ($item->params->get('show_intro', '1') == '1')
		{
			$item->text = $item->introtext . ' ' . $item->fulltext;
		}
		elseif ($item->fulltext)
		{
			$item->text = $item->fulltext;
		}
		else
		{
			$item->text = $item->introtext;
		}*/
		$result->text = trim($result->fulltext) == '' ? $result->introtext : $result->fulltext;
		
		$result->title = 	$articleTable->get("title");
		//TODO corriger le probleme qui fait que ça bug sous figaro aire
// 		$result->introtext = 	JHtml::_('content.prepare', $result->introtext);
		
		return $result->introtext;
	}
	
	/**
	 * Get Available fields. Will be used in layout display for example
	 */
	static function getFields(){
	    
	    $fields = array();
	    $fields[] = array('name'=>'title', 'label'=>'Title', 'type'=>'text');
	    $fields[] = array('name'=>'author', 'label'=>'Author', 'type'=>'text');
	    $fields[] = array('name'=>'created', 'label'=>'Created date', 'type'=>'text');
	    $fields[] = array('name'=>'modified', 'label'=>'Modified date', 'type'=>'text');
	    $fields[] = array('name'=>'published', 'label'=>'Published date', 'type'=>'text');
	    $fields[] = array('name'=>'images.image_intro', 'label'=>'Intro image', 'type'=>'image');
	    $fields[] = array('name'=>'category', 'label'=>'Category', 'type'=>'text');
	    $fields[] = array('name'=>'introtext', 'label'=>'Intro text', 'type'=>'editor');
	    $fields[] = array('name'=>'fulltext', 'label'=>'Full text', 'type'=>'editor');
	    return $fields;
	}

	/**
	 * 
	 * @param type $params
	 * @return array
	 * 
	 * Data array to be displayed in a link list.
	 * Properties : title, link
	 * 
	 * 
	 */
	static function loadLinkList($params){
	    return self::loadList($params, 'link');
	}
	
	static function loadBodyList($params){
	    return self::loadList($params, 'body');
	}
	
	static function loadThumbnailList($params){
	    $data = self::loadList($params, 'body');
	    for ($i=0;$i<count($data);$i++){
		$data[$i]->header= new stdClass();
		$data[$i]->header->label = $data[$i]->title;
		$data[$i]->header->glyph= new stdClass();
		$data[$i]->header->glyph->name = '';
		$data[$i]->badge= new stdClass();
		$data[$i]->badge->label = '';
		$data[$i]->hover='';
		$data[$i]->legend='';	
		
	    }
	    return $data;
	}
	
	static function loadList($params, $fieldsBasket='body')
	{		
	    
		$contentParams = $params->content->joomla_article;
		$ordering = (isset($contentParams->ordering) && ($contentParams->ordering != '')) ? 	$contentParams->ordering: 'ordering';
		$count =		isset($contentParams->count) ? 	$contentParams->count: 0;
		$category =	isset($contentParams->category) ? 	$contentParams->category: '';
		$author =		isset($contentParams->author) ? 	$contentParams->author: '';
		$featured =	isset($contentParams->featured) ? 	$contentParams->featured: '';
		$tags =		isset($contentParams->tags) ?	$contentParams->tags: '';		
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		switch ($fieldsBasket){
		    case 'link' :
			$query->select("a.id, a.title, a.alias, a.catid");
			$query->from("#__content AS a");
			$query->where("state !=-2");
			break;
		    case 'body' :
			$query->select("a.id, a.title, a.alias, a.introtext as body, a.catid, a.created_by as author, a.introtext, date(a.created) as created, time(a.created) as created_time, a.hits");
			$query->select('ua.name AS author')
			->join('LEFT', '#__users AS ua ON ua.id = a.created_by');
			$query->select('c.title AS category, c.alias AS category_alias')
			->join('LEFT', '#__categories AS c ON c.id = a.catid');
			$query->from("#__content AS a");
			$query->where("state !=-2");
			break;
		}
		/*
		$query->select("a.id, a.title, a.alias, a.catid, a.created_by as author, a.introtext, date(a.created) as created, time(a.created) as created_time, a.hits");
		$query->select('ua.name AS author')
			->join('LEFT', '#__users AS ua ON ua.id = a.created_by');
		$query->select('c.title AS category, c.alias AS category_alias')
			->join('LEFT', '#__categories AS c ON c.id = a.catid');
		$query->from("#__content AS a");
		$query->where("state !=-2");
*/
		if (isset($contentParams->category_filter) && ($contentParams->category_filter == 'custom') && $category != ''){
			if (is_array($category)){
				$category = ArrayHelper::toInteger($category);
				$query->where('a.catid in ('.implode($category, ',').')');
			}
			else
				$query->where('a.catid =' . (int) $category);
		}
		if ($author != ''){
			if (is_array($author)){
				$author = ArrayHelper::toInteger($author);
				$query->where('a.created_by in ('.implode($author, ',').')');
			}
			else
				$query->where('a.created_by =' . (int) $author);
		}
		if (isset($contentParams->tags_filter) && ($contentParams->tags_filter == 'custom') && $tags != ''){
			$query->join('LEFT', '#__contentitem_tag_map AS tm ON tm.content_item_id = a.id');
			if (is_array($tags)){
				$tags = ArrayHelper::toInteger($tags);
				$query->where('tm.tag_id in ('.implode($tags, ',').')');
			}
			else
				$query->where('tm.tag_id =' . (int) $tags);
			
		}
		if ($featured != ''){
				$query->where('a.featured =' . (int) $featured);
		}
		switch ($ordering){
			case 'popular':
				$ordering = 'hits DESC';
				break;
			case 'latest':
				$ordering = 'created DESC';
				break;
		}
				
		$query->order($ordering);
		if ($count != 0)
			$query->setLimit($count); 
		//if ($category != '')
		//	$query->where('a.catid = '.$category);

		$db->setQuery($query);
		$items = $db->loadObjectList();

		foreach ($items as &$item){
			$item->slug = $item->id.':'.$item->alias;
			if (isset($item->category_alias))
				$item->catslug = $item->catid ? $item->catid .':'.$item->category_alias : $item->catid;
			else
				$item->catslug = $item->catid;
				
		//	if ($access || in_array($item->access, $authorised))
		//	{
				// We know that user has the privilege to view the article
				$item->link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug));
		//	}
		}
		
		// get article active in page?
		$current_article = 0;
		$jinput = JFactory::getApplication()->input;
		$option = $jinput->get('option','');
		$view = $jinput->get('view','');
		$idarticle = $jinput->get('id','');
		if($option=='com_content' && $view=='article') {
			  $current_article = $idarticle;
		}
		// Prepare data for display using display options
		foreach ($items as &$item){
			if (isset($item->images))
				$item->images  = json_decode($item->images);
            
			// is item active ?
			$item->active = false;
			if($item->id==$current_article)
				$item->active = true;
		}
		return $items;	
	}
	
}