<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(NGEPATH_CONTENTS . '/source/contentsource.php');

class NgeInputContent extends NgeContentSource
{
  
    
        /**
    * Get data and format it to be rendered in a chart widget as label serie data (see getchartDateData)
    * @param type $params
    * @return \NgeContentStructureChart
    */
    static function getChartData($params){

	require_once (NGEPATH_CONTENTS . '/structure/chart.php');

	$content = $params->params->get('content');
        $chart = $params->params->get('chart');
	$chartData = new NgeContentStructureChart();	
        
	     if(isset($content->input) && $content->input !== "" && !empty($content->input)){
		//Data assignment to the chart
		$chartData->title = $content->title->label; 
		$chartData->subtitle = $content->subtitle->label;

		/*Remove last row value if empty*/
		$currentValues = $content->input->values;
		$isEmptyRow = true;
		$i = count($currentValues)-1;
		while($isEmptyRow && $i >= 0){
		    for ($j=1;$j<count($currentValues[$i]);$j++){
			if($currentValues[$i][$j] !== null && $currentValues[$i][$j] !== ""){
			    $isEmptyRow = false;
			}
		    }

		    if($isEmptyRow){
			unset($content->input->values[$i]);
		    }
		    $i--;
		}

		//Series name should exist and start to the col 1, Col 0 use for chart categories
		for ($i = 1; $i<count($content->input->options->names); $i++){
                    $annotations_labels = array();
                    
		    /*In edit mode when value are empty*/
		    if(isset($params->rendering->mode) && $params->rendering->mode == 'edit'){
			if($content->input->options->names[$i] === ""){
			    $content->input->options->names[$i] = "---";
			}
		    }

		    //Data of the current serie
		    $serie_data = array();
		    $serie_data['name'] = $content->input->options->names[$i];
		    $serie_data["data"] = array();
                    
                    /*SERIE OPTIONS*/
                    $serie_options = (isset($content->input->options) && isset($content->input->options->cols) && isset($content->input->options->cols[$i])) ? $content->input->options->cols[$i] : null;
                    if($serie_options !== null){
                        //Ligne
                        if (isset($serie_options->style) && $serie_options->style == "custom"){
                            if(isset($serie_options->color) && $serie_options->color !== ""){
                                $serie_data["color"] = $serie_options->color;
                            }
                            if(isset($serie_options->line->style) && $chart->series->default->line->style !== $serie_options->line->style){
                                $serie_data["dashStyle"] = $serie_options->line->style;
                            }
                            if(isset($serie_options->line->width) && $chart->series->default->line->width != $serie_options->line->width){
                                $serie_data["lineWidth"] = (float)$serie_options->line->width;
                            }
                            if(isset($serie_options->line->cap) && $chart->series->default->line->cap !== $serie_options->line->cap){
                                $serie_data["lineCap"] = $serie_options->line->cap;
                            }
                        }

                        //Markers
                        if(isset($serie_options->markers->display) && $serie_options->markers->display != 'default'
                                && $serie_options->markers->display !== $chart->series->default->markers->display) {
                            $serie_data["marker"]["enabled"] = ($serie_options->markers->display == '1');
                        }			
                        //Labels
                        if(isset($serie_options->labels->display) && $serie_options->labels->display != 'default'
                                && $serie_options->labels->display !== $chart->series->default->labels->display) {
                            $serie_data["dataLabels"]["enabled"] = ($serie_options->labels->display == '1');
                        }
                    }
                    
                    /*POINT OPTIONS*/
		    for ($j=0;$j<count($content->input->values);$j++){
			$point_data = array();
			$point_value = (isset($content->input->values[$j][$i]) && $content->input->values[$j][$i] != "") ? floatval(str_replace(',', '.', str_replace(' ', '', $content->input->values[$j][$i]))) : null;
			$point_options = (isset($content->input->options) && isset($content->input->options->cells) && isset($content->input->options->cells[$j][$i])) ? $content->input->options->cells[$j][$i] : null;
                        
                        /* Categories = first col
			 * In edit mode when value are empty*/
			if(isset($params->rendering->mode) && $params->rendering->mode == 'edit'){
			    if($content->input->values[$j][0] === "" || $content->input->values[$j][0] === null){
				$content->input->values[$j][0] = "---";
			    }
			}

                        /*Only for pie add name for each point, normally there only one serie*/
                        if ($chart->series->default->type === "pie"){
                            $point_data["name"] = str_replace('\'', '\\\'', str_replace('\\', '\\\\', $content->input->values[$j][0]));
                        }
                        
                        /*Value of the point*/
			$point_data["y"] = $point_value;
                        
                        if(isset($params->rendering->mode) && $params->rendering->mode == 'edit'){
                            $className = "number-point-".$j." serie-point-".$i.$j;
                            $point_data["className"] = $className;
                            $point_data["dataLabels"]["className"] = $className;
                        }

                        /*Specific object data for the point*/
                        if($point_options !== null){
                            if(isset($point_options->className) && $point_options->className !== ""){
                                if(isset($point_data["className"])){
                                    $point_data["className"] .= " ".$point_options->className;
                                }else{
                                   $point_data["className"] = " ".$point_options->className; 
                                }
                            }
                            if(isset($point_options->color) && $point_options->color !== ""){
                                $point_data["color"] = $point_options->color;
                            }
                            
                            if(isset($point_options->label)){
                                if(isset($point_options->label->display)){
                                    /*First check if current serie datalabels options exist and different of default*/
                                    if(isset($serie_options->labels->display) && $serie_options->labels->display != 'default') {
                                        if($point_options->label->display !== $serie_options->labels->display){
                                            switch ($point_options->label->display) {
                                                case "1":
                                                    $point_data["dataLabels"]["enabled"] = true;
                                                    break;

                                                case "0":
                                                    $point_data["dataLabels"]["enabled"] = false;
                                                    break;
                                            }
                                        }
                                    }else{ /*Compare to default option serie Datalabel*/
                                        if($point_options->label->display !== $chart->series->default->labels->display){
                                            switch ($point_options->label->display) {
                                                case "1":
                                                    $point_data["dataLabels"]["enabled"] = true;
                                                    break;

                                                case "0":
                                                    $point_data["dataLabels"]["enabled"] = false;
                                                    break;
                                            }
                                        }
                                    }
                                }
                                
                                /*Only for PIE point use distance instead of x and y*/
                                if ($chart->series->default->type === "pie"){
                                    //Connector and distance
                                    if(isset($point_options->label->position->mode) && $point_options->label->position->mode === "outside"){
                                        //Distance
                                        if (isset($point_options->label->distance)){
                                            $point_data["dataLabels"]["distance"] = (float)$point_options->label->distance;
                                        }
                                    }else{
                                        //Label inside : negative distance if not a negative value
                                        if(isset($point_options->label->distance)){
                                            if(floatval($point_options->label->distance) > 0){
                                                $point_data["dataLabels"]["distance"] = (int) - $point_options->label->distance;
                                            }else{
                                                $point_data["dataLabels"]["distance"] = (int) $point_options->label->distance;
                                            }
                                        }
                                    }
                                }else{
                                    if(isset($point_options->label->x) && $point_options->label->x != "0"){
                                        $point_data["dataLabels"]["x"] = (float)$point_options->label->x;
                                    }
                                    if(isset($point_options->label->y) && $point_options->label->y != "-6"){
                                        $point_data["dataLabels"]["y"] = (float)$point_options->label->y;
                                    }
                                }
                            }
                        
                            /*Annotations*/
                            if(isset($point_options->annotations)){
                                if(isset($point_options->annotations->text) && $point_options->annotations->text !== ""){
                                    $curent_annotation_label = array();
                                    $curent_annotation_label['text'] = '<span class=\"annotation-data-position\" nbserie=\"'.($i-1).'\" nbpoint=\"'.$j.'\" >'.str_replace(array("\r","\n"),"",nl2br($point_options->annotations->text)).'</span>';
                                    $curent_annotation_label['point'] = array();
                                    $curent_annotation_label['point']['x'] = $j;
                                    $curent_annotation_label['point']['y'] = (int)$point_value;
                                    $curent_annotation_label['point']['xAxis'] = 0;
                                    $curent_annotation_label['point']['yAxis'] = 0;

                                    /*Annotations general*/
                                    if(isset($point_options->annotations->display_mode) && $point_options->annotations->display_mode !== "default"){
                                        if(isset($point_options->annotations->shape) && $point_options->annotations->shape !== $chart->annotations->default->shape){
                                            $curent_annotation_label["shape"] = $point_options->annotations->shape;
                                        }
                                        if(isset($point_options->annotations->padding) && $point_options->annotations->padding !== $chart->annotations->default->padding){
                                            $curent_annotation_label["padding"] = floatval($point_options->annotations->padding);
                                        }
                                        if(isset($point_options->annotations->allowOverlap)){
			if($point_options->annotations->allowOverlap !== $chart->annotations->default->allowOverlap){
			    $curent_annotation_label["allowOverlap"] = (bool)$point_options->annotations->allowOverlap;
			}
                                        }
                                        else
			$curent_annotation_label["allowOverlap"] = 1;
					    
                                        if(isset($point_options->annotations->overflow) && $point_options->annotations->overflow !== $chart->annotations->default->overflow){
                                            $curent_annotation_label["overflow"] = "none";
                                        }
                                        if(isset($point_options->annotations->crop) && $point_options->annotations->crop !== $chart->annotations->default->crop){
                                            $curent_annotation_label["crop"] = (bool)$point_options->annotations->crop;
                                        }
                                        if(isset($point_options->annotations->useHTML) && $point_options->annotations->useHTML !== $chart->annotations->default->useHTML){
                                            $curent_annotation_label["useHTML"] = (bool)$point_options->annotations->useHTML;
                                        }
                                        if(isset($point_options->annotations->position) 
                                                && isset($point_options->annotations->position->mode) && $point_options->annotations->position->mode === "custom"){
			if(isset($point_options->annotations->align) && $point_options->annotations->align !== $chart->annotations->default->align){
			    $curent_annotation_label["align"] = $point_options->annotations->align;
			}
			if(isset($point_options->annotations->verticalAlign) && $point_options->annotations->verticalAlign !== $chart->annotations->default->verticalAlign){
			    $curent_annotation_label["verticalAlign"] = $point_options->annotations->verticalAlign;
			}					    
			if(isset($point_options->annotations->position->x) && $point_options->annotations->position->x !== $chart->annotations->default->position->x){
			    $curent_annotation_label["x"] = floatval($point_options->annotations->position->x);
			}
			if(isset($point_options->annotations->position->y) && $point_options->annotations->position->y !== $chart->annotations->default->position->y){
			    $curent_annotation_label["y"] = floatval($point_options->annotations->position->y);
			}
                                        }
                                    }

                                    /*Annotations font*/
                                    if(isset($point_options->annotations->font) && isset($point_options->annotations->font->display_mode) && $point_options->annotations->font->display_mode === "custom"){
                                        $curent_annotation_label_style = array();

                                        if(isset($point_options->annotations->font->name) && $point_options->annotations->font->name !== ""){
                                            $font_weight = (isset($point_options->annotations->font->weight) ? $point_options->annotations->font->weight : "normal");
                                            $externalFont = NGE::getExternalFont($point_options->annotations->font->name, $font_weight);
                                            if($externalFont !== null){
                                                $curent_annotation_label_style["fontFamily"] = $externalFont["name"];
                                            }else{
                                                $curent_annotation_label_style["fontFamily"] = $point_options->annotations->font->name;
                                            }
                                        }
                                        if(isset($point_options->annotations->font->size) && $point_options->annotations->font->size !== $chart->annotations->default->font->size){
                                            $curent_annotation_label_style["fontSize"] = $point_options->annotations->font->size."px";
                                        }
                                        if(isset($point_options->annotations->font->weight) && $point_options->annotations->font->weight !== $chart->annotations->default->font->weight){
                                            $curent_annotation_label_style["fontWeight"] = $point_options->annotations->font->weight;
                                        }
                                        if(isset($point_options->annotations->font->color) && $point_options->annotations->font->color !== $chart->annotations->default->font->color){
                                            $curent_annotation_label_style["color"] = $point_options->annotations->font->color;
                                        }

                                        if(count($curent_annotation_label_style) > 0){
                                            $curent_annotation_label["style"] = $curent_annotation_label_style;
                                        }
                                    }

                                    /*Annotations border*/
                                    if(isset($point_options->annotations->border) && isset($point_options->annotations->border->display_mode) && $point_options->annotations->border->display_mode === "custom"){
                                        if(isset($point_options->annotations->border->display) && $point_options->annotations->border->display !== "0"){
                                            if(isset($point_options->annotations->border->width) && $point_options->annotations->border->width !== $chart->annotations->default->border->width){
                                                $curent_annotation_label['borderWidth'] = floatval($point_options->annotations->border->width);
                                            }
                                            if(isset($point_options->annotations->border->color->value) && $point_options->annotations->border->color->value !== $chart->annotations->default->border->color->value
//                                                        && isset($point_options->annotations->border->color->style) && $point_options->annotations->border->color->style === "custom"
                                            ){
                                                $curent_annotation_label['borderColor'] = $point_options->annotations->border->color->value;
                                            }
                                            if(isset($point_options->annotations->border->radius_width) && $point_options->annotations->border->radius_width !== $chart->annotations->default->border->radius_width){
                                                $curent_annotation_label['borderRadius'] = floatval($point_options->annotations->border->radius_width);
                                            }
                                        }else{
                                            $curent_annotation_label['borderWidth'] = 0;
                                        }
                                    }

                                    /*Annotations background*/
                                    if(isset($point_options->annotations->background) 
                                            && (isset($point_options->annotations->background->display_mode) && $point_options->annotations->background->display_mode === "custom")){
                                        if((isset($point_options->annotations->background->color))
                                            || (isset($point_options->annotations->background->opacity))){
                                            list($r, $g, $b) = sscanf($point_options->annotations->background->color, "#%02x%02x%02x");
                                            $curent_annotation_label['backgroundColor'] = "rgba(".$r.",".$g.",".$b.",".(floatval($point_options->annotations->background->opacity)/100).")";
                                        }
                                    }

                                    /*Annotations shadow*/
                                    if(isset($point_options->annotations->shadow) 
                                            && (isset($point_options->annotations->shadow->display_mode) && $point_options->annotations->shadow->display_mode === "custom")){
                                        if(isset($point_options->annotations->shadow->style) && $point_options->annotations->shadow->style !== "none"){
                                            $curent_annotation_label_shadow = array();

                                            if(isset($point_options->annotations->shadow->offset_x) && $point_options->annotations->shadow->offset_x !== $chart->annotations->default->shadow->offset_x){
                                                $curent_annotation_label_shadow["offsetX"] = floatval($point_options->annotations->shadow->offset_x);
                                            }
                                            if(isset($point_options->annotations->shadow->offset_y) && $point_options->annotations->shadow->offset_y !== $chart->annotations->default->shadow->offset_y){
                                                $curent_annotation_label_shadow["offsetY"] = floatval($point_options->annotations->shadow->offset_y);
                                            }
                                            if(isset($point_options->annotations->shadow->color) && $point_options->annotations->shadow->color !== $chart->annotations->default->shadow->color){
                                                $curent_annotation_label_shadow["color"] = $point_options->annotations->shadow->color;
                                            }
                                            if(isset($point_options->annotations->shadow->opacity) && $point_options->annotations->shadow->opacity !== $chart->annotations->default->shadow->opacity){
                                                $curent_annotation_label_shadow["opacity"] = floatval($point_options->annotations->shadow->opacity)/100;
                                            }
                                            if(isset($point_options->annotations->shadow->width) && $point_options->annotations->shadow->width !== $chart->annotations->default->shadow->width){
                                                $curent_annotation_label_shadow["width"] = floatval($point_options->annotations->shadow->width);
                                            }
                                        }else{
                                            $curent_annotation_label_shadow["width"] = 0;
                                        }

                                        if(count($curent_annotation_label_shadow) > 0){
                                            $curent_annotation_label["shadow"] = $curent_annotation_label_shadow;
                                        }
                                    }

                                    if(count($curent_annotation_label) > 0){
                                        array_push($annotations_labels, $curent_annotation_label);
                                    }
                                }
                            }
                        }

			if ($i == 1 && $chart->series->default->type !== "pie"){ //Only on the first col and if the chart is not a pie
			    $chartData->categories[] = str_replace('\'', '\\\'', str_replace('\\', '\\\\', $content->input->values[$j][0]));
			}
                        
			$serie_data["data"][] = $point_data;
		    }
                    
                    if(count($annotations_labels) > 0){
                        $annoArray = array();
                        $annoArray["id"] = "serie-".($i-1);
                        $annoArray["labels"] = $annotations_labels;

                        if(!isset($chartData->annotations)){
                            $chartData->annotations = array();
                        }
                        array_push($chartData->annotations, $annoArray);
                    }
                                        
                    $serie_data['name'] = $content->input->options->names[$i];
                    $chartData->series[] = $serie_data;
		}
	    }

	    return $chartData;
    }

            /**
    * Get data and format it to be rendered in a chart widget as dateserie data
    * @param type $params
    * @return \NgeContentStructureChart
    */
    static function getChartDateData($params, $input = null){

	require_once (NGEPATH_CONTENTS . '/structure/chart.php');

	$content = $params->params->get('content');
        $chart = $params->params->get('chart');
	$chartData = new stdClass();
        $input = (isset($input) && $input !== null) ? $input : "";
        
	     if(isset($input) && $input !== "" && !empty($input)){
		/*Remove last row value if empty*/
		$currentValues = $input->values;
		$isEmptyRow = true;
		$i = count($currentValues)-1;
		while($isEmptyRow && $i >= 0){
		    for ($j=1;$j<count($currentValues[$i]);$j++){
			if($currentValues[$i][$j] !== null && $currentValues[$i][$j] !== ""){
			    $isEmptyRow = false;
			}
		    }

		    if($isEmptyRow){
			unset($input->values[$i]);
		    }
		    $i--;
		}

		//Series name should exist and start to the col 1, Col 0 use for chart categories
		for ($i = 1; $i<count($input->options->names); $i++){
                    $annotations_labels = array();
                    
		    /*In edit mode when value are empty*/
		    if(isset($params->rendering->mode) && $params->rendering->mode == 'edit'){
			if($input->options->names[$i] === ""){
			    $input->options->names[$i] = "---";
			}
		    }

		    //Data of the current serie
		    $serie_data = array();
		    $serie_data['name'] = $input->options->names[$i];
		    $serie_data["data"] = array();
                    
                    /*SERIE OPTIONS*/
                    $serie_options = (isset($input->options) && isset($input->options->cols) && isset($input->options->cols[$i])) ? $input->options->cols[$i] : null;
                    if($serie_options !== null){
                        //Ligne
                        if (isset($serie_options->style) && $serie_options->style == "custom"){
                            if(isset($serie_options->color) && $serie_options->color !== ""){
                                $serie_data["color"] = $serie_options->color;
                            }
                            if(isset($serie_options->line->style) && $chart->series->default->line->style !== $serie_options->line->style){
                                $serie_data["dashStyle"] = $serie_options->line->style;
                            }
                            if(isset($serie_options->line->width) && $chart->series->default->line->width != $serie_options->line->width){
                                $serie_data["lineWidth"] = (float)$serie_options->line->width;
                            }
                            if(isset($serie_options->line->cap) && $chart->series->default->line->cap !== $serie_options->line->cap){
                                $serie_data["lineCap"] = $serie_options->line->cap;
                            }
                        }

                        //Markers
                        if(isset($serie_options->markers->display) && $serie_options->markers->display != 'default'
                                && $serie_options->markers->display !== $chart->series->default->markers->display) {
                            $serie_data["marker"]["enabled"] = ($serie_options->markers->display == '1');
                        }			
                        //Labels
                        if(isset($serie_options->labels->display) && $serie_options->labels->display != 'default'
                                && $serie_options->labels->display !== $chart->series->default->labels->display) {
                            $serie_data["dataLabels"]["enabled"] = ($serie_options->labels->display == '1');
                        }
                    }
                    
                    /*POINT OPTIONS*/
		    for ($j=0;$j<count($input->values);$j++){
			$point_data = array();
			$point_value = (isset($input->values[$j][$i]) && $input->values[$j][$i] != "") ? floatval(str_replace(',', '.', str_replace(' ', '', $input->values[$j][$i]))) : null;
			$point_options = (isset($input->options) && isset($input->options->cells) && isset($input->options->cells[$j][$i])) ? $input->options->cells[$j][$i] : null;
                        $count_date = count($input->values)-1-$j;
                        
                        /* Categories = first col*/
                        if($input->values[$j][0] === "" || $input->values[$j][0] === null){
                            $input->values[$j][0] = date('d-m-Y', strtotime('-'.$count_date.' day'));
                        }

                        /*Only for pie add name for each point, normally there only one serie*/
                        if ($chart->series->default->type === "pie"){
                            $point_data["name"] = str_replace('\'', '\\\'', str_replace('\\', '\\\\', $input->values[$j][0]));
                        }
                        
                        /*Value of the point*/                        
                        $current_date = trim($input->values[$j][0]);
                        if (strpos($current_date, '/') !== false){
                            $current_date_formatted = str_replace("/", "-", $current_date);
                        }elseif(strpos($current_date, ' ') !== false){
                            $current_date_formatted = str_replace(" ", "-", $current_date);
                        }else{
                            $current_date_formatted =  $current_date;
                        }
                        
                        if (($timestamp = strtotime($current_date_formatted)) === false) {
                            $time_for_highcharts = strtotime(date('d-m-Y', strtotime('-'.$count_date.' day'))) * 1000;
                        } else {
                            $time_for_highcharts = floatval($timestamp) * 1000;
                        }

			$point_data["x"] = $time_for_highcharts;
			$point_data["y"] = $point_value;
                        
                        if(isset($params->rendering->mode) && $params->rendering->mode == 'edit'){
                            $className = "number-point-".$j." serie-point-".$i.$j;
                            $point_data["className"] = $className;
                            $point_data["dataLabels"]["className"] = $className;
                        }

                        /*Specific object data for the point*/
                        if($point_options !== null){
                            if(isset($point_options->className) && $point_options->className !== ""){
                                if(isset($point_data["className"])){
                                    $point_data["className"] .= " ".$point_options->className;
                                }else{
                                   $point_data["className"] = " ".$point_options->className; 
                                }
                            }
                            if(isset($point_options->color) && $point_options->color !== ""){
                                $point_data["color"] = $point_options->color;
                            }
                            
                            if(isset($point_options->label)){
                                if(isset($point_options->label->display)){
                                    /*First check if current serie datalabels options exist and different of default*/
                                    if(isset($serie_options->labels->display) && $serie_options->labels->display != 'default') {
                                        if($point_options->label->display !== $serie_options->labels->display){
                                            switch ($point_options->label->display) {
                                                case "1":
                                                    $point_data["dataLabels"]["enabled"] = true;
                                                    break;

                                                case "0":
                                                    $point_data["dataLabels"]["enabled"] = false;
                                                    break;
                                            }
                                        }
                                    }else{ /*Compare to default option serie Datalabel*/
                                        if($point_options->label->display !== $chart->series->default->labels->display){
                                            switch ($point_options->label->display) {
                                                case "1":
                                                    $point_data["dataLabels"]["enabled"] = true;
                                                    break;

                                                case "0":
                                                    $point_data["dataLabels"]["enabled"] = false;
                                                    break;
                                            }
                                        }
                                    }
                                }
                                
                                /*Only for PIE point use distance instead of x and y*/
                                if ($chart->series->default->type === "pie"){
                                    //Connector and distance
                                    if(isset($point_options->label->position->mode) && $point_options->label->position->mode === "outside"){
                                        //Distance
                                        if (isset($point_options->label->distance)){
                                            $point_data["dataLabels"]["distance"] = (float)$point_options->label->distance;
                                        }
                                    }else{
                                        //Label inside : negative distance if not a negative value
                                        if(isset($point_options->label->distance)){
                                            if(floatval($point_options->label->distance) > 0){
                                                $point_data["dataLabels"]["distance"] = (int) - $point_options->label->distance;
                                            }else{
                                                $point_data["dataLabels"]["distance"] = (int) $point_options->label->distance;
                                            }
                                        }
                                    }
                                }else{
                                    if(isset($point_options->label->x) && $point_options->label->x != "0"){
                                        $point_data["dataLabels"]["x"] = (float)$point_options->label->x;
                                    }
                                    if(isset($point_options->label->y) && $point_options->label->y != "-6"){
                                        $point_data["dataLabels"]["y"] = (float)$point_options->label->y;
                                    }
                                }
                            }
                        
                            /*Annotations*/
                            if(isset($point_options->annotations)){
                                if(isset($point_options->annotations->text) && $point_options->annotations->text !== ""){
                                    $curent_annotation_label = array();
                                    $curent_annotation_label['text'] = '<span class=\"annotation-data-position\" nbserie=\"'.($i-1).'\" nbpoint=\"'.$j.'\" >'.str_replace(array("\r","\n"),"",nl2br($point_options->annotations->text)).'</span>';
                                    $curent_annotation_label['point'] = array();
                                    $curent_annotation_label['point']['x'] = $j;
                                    $curent_annotation_label['point']['y'] = (int)$point_value;
                                    $curent_annotation_label['point']['xAxis'] = 0;
                                    $curent_annotation_label['point']['yAxis'] = 0;

                                    /*Annotations general*/
                                    if(isset($point_options->annotations->display_mode) && $point_options->annotations->display_mode !== "default"){
                                        if(isset($point_options->annotations->shape) && $point_options->annotations->shape !== $chart->annotations->default->shape){
                                            $curent_annotation_label["shape"] = $point_options->annotations->shape;
                                        }
                                        if(isset($point_options->annotations->padding) && $point_options->annotations->padding !== $chart->annotations->default->padding){
                                            $curent_annotation_label["padding"] = floatval($point_options->annotations->padding);
                                        }
                                        if(isset($point_options->annotations->allowOverlap)){
			if($point_options->annotations->allowOverlap !== $chart->annotations->default->allowOverlap){
			    $curent_annotation_label["allowOverlap"] = (bool)$point_options->annotations->allowOverlap;
			}
                                        }
                                        else
			$curent_annotation_label["allowOverlap"] = 1;
					    
                                        if(isset($point_options->annotations->overflow) && $point_options->annotations->overflow !== $chart->annotations->default->overflow){
                                            $curent_annotation_label["overflow"] = "none";
                                        }
                                        if(isset($point_options->annotations->crop) && $point_options->annotations->crop !== $chart->annotations->default->crop){
                                            $curent_annotation_label["crop"] = (bool)$point_options->annotations->crop;
                                        }
                                        if(isset($point_options->annotations->useHTML) && $point_options->annotations->useHTML !== $chart->annotations->default->useHTML){
                                            $curent_annotation_label["useHTML"] = (bool)$point_options->annotations->useHTML;
                                        }
                                        if(isset($point_options->annotations->position) 
                                                && isset($point_options->annotations->position->mode) && $point_options->annotations->position->mode === "custom"){
			if(isset($point_options->annotations->align) && $point_options->annotations->align !== $chart->annotations->default->align){
			    $curent_annotation_label["align"] = $point_options->annotations->align;
			}
			if(isset($point_options->annotations->verticalAlign) && $point_options->annotations->verticalAlign !== $chart->annotations->default->verticalAlign){
			    $curent_annotation_label["verticalAlign"] = $point_options->annotations->verticalAlign;
			}					    
			if(isset($point_options->annotations->position->x) && $point_options->annotations->position->x !== $chart->annotations->default->position->x){
			    $curent_annotation_label["x"] = floatval($point_options->annotations->position->x);
			}
			if(isset($point_options->annotations->position->y) && $point_options->annotations->position->y !== $chart->annotations->default->position->y){
			    $curent_annotation_label["y"] = floatval($point_options->annotations->position->y);
			}
                                        }
                                    }

                                    /*Annotations font*/
                                    if(isset($point_options->annotations->font) && isset($point_options->annotations->font->display_mode) && $point_options->annotations->font->display_mode === "custom"){
                                        $curent_annotation_label_style = array();

                                        if(isset($point_options->annotations->font->name) && $point_options->annotations->font->name !== ""){
                                            $font_weight = (isset($point_options->annotations->font->weight) ? $point_options->annotations->font->weight : "normal");
                                            $externalFont = NGE::getExternalFont($point_options->annotations->font->name, $font_weight);
                                            if($externalFont !== null){
			//JMB 19/03/18 bug affichage warning $ngetoolsfonts = null
			if ($ngetoolsfonts != null)
			    array_push($ngetoolsfonts, $externalFont);
                                                $curent_annotation_label_style["fontFamily"] = $externalFont["name"];
                                            }else{
                                                $curent_annotation_label_style["fontFamily"] = $point_options->annotations->font->name;
                                            }
                                        }
                                        if(isset($point_options->annotations->font->size) && $point_options->annotations->font->size !== $chart->annotations->default->font->size){
                                            $curent_annotation_label_style["fontSize"] = $point_options->annotations->font->size."px";
                                        }
                                        if(isset($point_options->annotations->font->weight) && $point_options->annotations->font->weight !== $chart->annotations->default->font->weight){
                                            $curent_annotation_label_style["fontWeight"] = $point_options->annotations->font->weight;
                                        }
                                        if(isset($point_options->annotations->font->color) && $point_options->annotations->font->color !== $chart->annotations->default->font->color){
                                            $curent_annotation_label_style["color"] = $point_options->annotations->font->color;
                                        }

                                        if(count($curent_annotation_label_style) > 0){
                                            $curent_annotation_label["style"] = $curent_annotation_label_style;
                                        }
                                    }

                                    /*Annotations border*/
                                    if(isset($point_options->annotations->border) && isset($point_options->annotations->border->display_mode) && $point_options->annotations->border->display_mode === "custom"){
                                        if(isset($point_options->annotations->border->display) && $point_options->annotations->border->display !== "0"){
                                            if(isset($point_options->annotations->border->width) && $point_options->annotations->border->width !== $chart->annotations->default->border->width){
                                                $curent_annotation_label['borderWidth'] = floatval($point_options->annotations->border->width);
                                            }
                                            if(isset($point_options->annotations->border->color->value) && $point_options->annotations->border->color->value !== $chart->annotations->default->border->color->value
//                                                        && isset($point_options->annotations->border->color->style) && $point_options->annotations->border->color->style === "custom"
                                            ){
                                                $curent_annotation_label['borderColor'] = $point_options->annotations->border->color->value;
                                            }
                                            if(isset($point_options->annotations->border->radius_width) && $point_options->annotations->border->radius_width !== $chart->annotations->default->border->radius_width){
                                                $curent_annotation_label['borderRadius'] = floatval($point_options->annotations->border->radius_width);
                                            }
                                        }else{
                                            $curent_annotation_label['borderWidth'] = 0;
                                        }
                                    }

                                    /*Annotations background*/
                                    if(isset($point_options->annotations->background) 
                                            && (isset($point_options->annotations->background->display_mode) && $point_options->annotations->background->display_mode === "custom")){
                                        if((isset($point_options->annotations->background->color))
                                            || (isset($point_options->annotations->background->opacity))){
                                            list($r, $g, $b) = sscanf($point_options->annotations->background->color, "#%02x%02x%02x");
                                            $curent_annotation_label['backgroundColor'] = "rgba(".$r.",".$g.",".$b.",".(floatval($point_options->annotations->background->opacity)/100).")";
                                        }
                                    }

                                    /*Annotations shadow*/
                                    if(isset($point_options->annotations->shadow) 
                                            && (isset($point_options->annotations->shadow->display_mode) && $point_options->annotations->shadow->display_mode === "custom")){
                                        if(isset($point_options->annotations->shadow->style) && $point_options->annotations->shadow->style !== "none"){
                                            $curent_annotation_label_shadow = array();

                                            if(isset($point_options->annotations->shadow->offset_x) && $point_options->annotations->shadow->offset_x !== $chart->annotations->default->shadow->offset_x){
                                                $curent_annotation_label_shadow["offsetX"] = floatval($point_options->annotations->shadow->offset_x);
                                            }
                                            if(isset($point_options->annotations->shadow->offset_y) && $point_options->annotations->shadow->offset_y !== $chart->annotations->default->shadow->offset_y){
                                                $curent_annotation_label_shadow["offsetY"] = floatval($point_options->annotations->shadow->offset_y);
                                            }
                                            if(isset($point_options->annotations->shadow->color) && $point_options->annotations->shadow->color !== $chart->annotations->default->shadow->color){
                                                $curent_annotation_label_shadow["color"] = $point_options->annotations->shadow->color;
                                            }
                                            if(isset($point_options->annotations->shadow->opacity) && $point_options->annotations->shadow->opacity !== $chart->annotations->default->shadow->opacity){
                                                $curent_annotation_label_shadow["opacity"] = floatval($point_options->annotations->shadow->opacity)/100;
                                            }
                                            if(isset($point_options->annotations->shadow->width) && $point_options->annotations->shadow->width !== $chart->annotations->default->shadow->width){
                                                $curent_annotation_label_shadow["width"] = floatval($point_options->annotations->shadow->width);
                                            }
                                        }else{
                                            $curent_annotation_label_shadow["width"] = 0;
                                        }

                                        if(count($curent_annotation_label_shadow) > 0){
                                            $curent_annotation_label["shadow"] = $curent_annotation_label_shadow;
                                        }
                                    }

                                    if(count($curent_annotation_label) > 0){
                                        array_push($annotations_labels, $curent_annotation_label);
                                    }
                                }
                            }
                        }
                        
			$serie_data["data"][] = $point_data;
		    }
                    
                    if(count($annotations_labels) > 0){
                        $annoArray = array();
                        $annoArray["id"] = "serie-".($i-1);
                        $annoArray["labels"] = $annotations_labels;

                        if(!isset($chartData->annotations)){
                            $chartData->annotations = array();
                        }
                        array_push($chartData->annotations, $annoArray);
                    }
                                        
                    $serie_data['name'] = $input->options->names[$i];
                    if(!isset($chartData->series)){
                        $chartData->series = array();
                    }
                    array_push($chartData->series, $serie_data);
		}
	    }

	    return $chartData;
    }
    
	/**
	 * Get an array of needed fonts
	 * @param type $params
	 */
	static function getChartFonts($params){    
	    $fontsUrls = array();
	    $content = $params->params->get('content');
	    if(isset($content->input) && $content->input !== "" && !empty($content->input))
		for ($i = 1; $i<count($content->input->options->names); $i++){
		    for ($j=0;$j<count($content->input->values);$j++){
			$point_options = (isset($content->input->options) && isset($content->input->options->cells) && isset($content->input->options->cells[$j][$i])) ? $content->input->options->cells[$j][$i] : null;

			//Searching anotations fonts
			if($point_options !== null){			
					    if(isset($point_options->annotations->font) && isset($point_options->annotations->font->display_mode) && $point_options->annotations->font->display_mode === "custom"
						 && isset($point_options->annotations->font->name) && $point_options->annotations->font->name !== ""){
						    $font_weight = (isset($point_options->annotations->font->weight) ? $point_options->annotations->font->weight : "normal");
						    $externalFont = NGE::getExternalFont($point_options->annotations->font->name, $font_weight);
						    if($externalFont !== null)
				    array_push($fontsUrls, $externalFont);
			    }
			}
		    }
		}
	    return $fontsUrls;
	}
    
	static function getLabel($data, $params){

	    switch ($params->layout->mode) {
		case 'fields' :
		    //Default label: first field
		    return current($data);
		    break;
		case 'template' :
		    require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
			$item = new stdClass();
			$item->editable = false;
			return SmartyRenderer::renderString($data, $params->layout->template->label);
		    break;
	    };		
	}

	static function getBody($data, $params)
	{
	    //$data is a row record
	    $item = new stdClass();
	    $item->editable = false;
	    
	    switch ($params->layout->mode) {
		case 'fields' :
		    $htmlRow = '<table class="table">';
		    $firstField = true;
		    foreach ($data as $key=>$value) {
			if ($firstField == true){
			    $item->label = $value;
			    $firstField = false;
			}
			$htmlRow .= '<tr><td>'.$key.'</td><td>'.$value.'</td></tr>' ;
		    }
		    $htmlRow .= '</table>';
		    return $htmlRow;
		    break;
		case 'template' :
		    require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
			$item = new stdClass();
			$item->editable = false;
			return SmartyRenderer::renderString($data, $params->layout->template->body);
		    break;
	    };		
	}
	
	/**
	 * Get Available fields. Will be used in layout display for example
	 */
	static function getFields(){
	    
	    $fields = array();
	    $fields[] = array('name'=>'title', 'label'=>'Title', 'type'=>'text');
	    $fields[] = array('name'=>'author', 'label'=>'Author', 'type'=>'text');
	    $fields[] = array('name'=>'created', 'label'=>'Created date', 'type'=>'text');
	    $fields[] = array('name'=>'modified', 'label'=>'Modified date', 'type'=>'text');
	    $fields[] = array('name'=>'published', 'label'=>'Published date', 'type'=>'text');
	    $fields[] = array('name'=>'images.image_intro', 'label'=>'Intro image', 'type'=>'image');
	    $fields[] = array('name'=>'category', 'label'=>'Category', 'type'=>'text');
	    $fields[] = array('name'=>'introtext', 'label'=>'Intro text', 'type'=>'editor');
	    $fields[] = array('name'=>'fulltext', 'label'=>'Full text', 'type'=>'editor');
	    return $fields;
	}
	
	static function getList($params)
	{

	    //Transform stored data into associative array, to be rendered in templates
	    $values = $params->input->values;
	
	    $result = array();
	    if (count($values) >0){
		$labels = $values[0];
		for ($i=1;$i<count($values);$i++){
		    $row = array();
		    for ($j=0;$j<count($values[$i]);$j++){
			//$row['col' . (string)($i+1)] = $valuesRow[$i];
			$row[$labels[$j]] = $values[$i][$j];
		    }
		    $result[] = $row;
		}
		return $result;
	    }
	}	
}