<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(NGEPATH_CONTENTS . '/source/contentsource.php');

class NgeDatabaseInputContent extends NgeContentSource
{
	/**
	 * Formatting data from stored structure to be readable as assocData
	 * the stored structure contains data and also display informations
	 * @param type $inputValues
	 * @return type
	 */
    	static function formatAssocData($inputValues){
	    $assocData = array();
	    foreach($inputValues as $row){
		$assocRow = array();
		for ($i=1; $i<=count($row);$i++){
		    $assocRow['col' . $i] = $row[$i-1];
		}
		$assocData[] = $assocRow;
	    }
	    return $assocData;
	}

	/**
	 * Get data and format it to be rendered in a tabs widget
	 * @param type $params
	 * @return \NgeContentStructureThumbnails
	 */
	static function getTabsData($params){
	    
	    require_once (NGEPATH_CONTENTS . '/structure/tabs.php');
	    $items = array();	    
	    $input = $params->content->database_input->database->input;
	     
	    switch ($params->content->database_input->layout->mode) {
		    case 'template' :			
			$assocData = self::formatAssocData($input->values);						
			    require_once (NGEPATH_HELPERS . '/renderer/mustache/mustacherenderer.php');
			    foreach ($assocData as $contentRow) {
				    $item = new NgeContentStructureTabs();
				    if ($params->content->database_input->layout->template->label != '')
					$item->tab->label = MustacheRenderer::renderString($contentRow, $params->content->database_input->layout->template->label);
				    if ($params->content->database_input->layout->template->body != '')
					$item->body = MustacheRenderer::renderString($contentRow, $params->content->database_input->layout->template->body);
				    $items[] = $item;
			    }
			    break;
		    default : //fields			
			foreach($input->values as $row){
			    $item = new NgeContentStructureTabs();
			    $item->tab->label = $row[0];
			    $item->body = '<table class="table">';
			    for ($i=0; $i<count($row);$i++){
				$item->body .= '<tr><td>' . $input->options->names[$i] . '</td><td>' . $row[$i] . '</td></tr>';
			    }
			    $item->body .= '</table>';
			    $items[] = $item;
			}
			break;
	    }
	    return $items;		
	}

	static function getListData($params){
		
	    require_once (NGEPATH_CONTENTS . '/structure/list.php');
	    $items = array();
	    $input = $params->content->database_input->database->input;
	    if (isset($input->values)){
		foreach ($input->values as $row) {
		    $item = new NgeContentStructureList();
		    $item->label =	$row[0];
		    $item->link =	$row[1];
		    if (trim($item->label != ''))
			$items[] = $item;
		}
	    }
	    return $items;
	}
	
	
	/**
	 * Get data and format it to be rendered in a "thumbnails" like widget
	 * @param type $params
	 * @return \NgeContentStructureThumbnails
	 */
	static function getThumbnailsData($params){
	    
	    require_once (NGEPATH_CONTENTS . '/structure/thumbnails.php');
	    $items = array();

	     $input = $params->content->database_input->database->input;
	     
	    switch ($params->content->database_input->layout->mode) {
		    case 'template' :
			
			//Formating data to be readable by the template engine
			$inputData = self::formatAssocData($input->values);
						
			    require_once (NGEPATH_HELPERS . '/renderer/mustache/mustacherenderer.php');
			    foreach ($inputData as $contentRow) {
				    $item = new NgeContentStructureThumbnails();
				    if ($params->content->database_input->layout->template->label != '')
					$item->header->label = MustacheRenderer::renderString($contentRow, $params->content->database_input->layout->template->label);
				    if ($params->content->database_input->layout->template->body != '')
					$item->body = MustacheRenderer::renderString($contentRow, $params->content->database_input->layout->template->body);
				    if ($params->content->database_input->layout->template->caption != '')
					$item->caption = MustacheRenderer::renderString($contentRow, $params->content->database_input->layout->template->caption);
				    /*else
				    if ($data->content->database_query->layout->template->source == 'file')
					    $item->body = SmartyRenderer::render($contentRow, $data->content->database_query->layout->template->file);*/
				    $items[] = $item;
			    }
			    break;
		    default : //fields
			if (isset($input->values))
			foreach($input->values as $row){
			    $item = new NgeContentStructureThumbnails();
			    $item->body = '<table class="table">';
			    for ($i=0; $i<count($row);$i++){
				$item->body .= '<tr><td>' . $input->options->names[$i] . '</td><td>' . $row[$i] . '</td></tr>';			
			    }
			    $item->body .= '</table>';
			    $items[] = $item;
			}
			    break;
	    }
	    return $items;		
	}
	
	static function loadLinkList($params){
	    return self::loadList($params, 'link');
	}
	
	static function loadBodyList($multipleContent){
	    
	    $input = $multipleContent->input;
	    try {
		$result = array();
		foreach($input->values as $inputRow){
		    $row = new stdClass();
		    for ($i=0; $i<count($inputRow);$i++){
			if ($i==0)
			    $row->title= $inputRow[$i];
			else	
			if ($i==1)
			    $row->body= $inputRow[$i];
		    }
		    $result[] = $row;
		}
		return $result;

	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return null;
	    }
	    	    
	}
	
	static function loadThumbnailList($multipleContent){
	    
	     $input = $multipleContent->input;
	    try {
		$result = array();
		foreach($input->values as $inputRow){
		    $row = new stdClass();
		    $row->header= new stdClass();
		    $row->header->label = '';
		    $row->header->glyph= new stdClass();
		    $row->header->glyph->name = '';
		    $row->badge= new stdClass();
		    $row->badge->label = '';
		    $row->hover='';
		    $row->legend='';	
		    for ($i=0; $i<count($inputRow);$i++){
			if ($i==0)
			    $row->header->label= $inputRow[$i];
			else	
			if ($i==1)
			    $row->body= $inputRow[$i];
		    }
		    $result[] = $row;
		}
		return $result;

	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return null;
	    }
	    
	    $data = self::loadList($params, 'body');
	    for ($i=0;$i<count($data);$i++){
		$data[$i]->header= new stdClass();
		$data[$i]->header->label = $data[$i]->title;
		$data[$i]->header->glyph= new stdClass();
		$data[$i]->header->glyph->name = '';
		$data[$i]->hover='';
		$data[$i]->legend='';	
		
	    }
	    return $data;
	}	
	
	
	
	/**
	 * when multiple content
	 * get a result with multiple items
	 * @param type $params
	 * @return title, body
	 */
	static function loadList($params)
	{		
	    $input = $params->input;
	    try {
		$result = array();
		foreach($input->values as $inputRow){
		    $row = new stdClass();
		    for ($i=0; $i<count($inputRow);$i++){
			if ($i==0)
			    $row->id= $inputRow[$i];
			else	
			if ($i==1)
			    $row->title= $inputRow[$i];
			else	
			if ($i==2)
			    $row->link= $inputRow[$i];			
		    }
		    $result[] = $row;
		}
		return $result;

	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return null;
	    }
	}
	
	
	/**
	 * Get data and format it to be rendered in a "table" like widget
	 * @param type $params
	 * @return \NgeContentStructureTable
	 */
	static function getTableData($params){
	    
		require_once (NGEPATH_CONTENTS . '/structure/table.php');
		$tableData = new NgeContentStructureTable();
		//Main content in values property	    
		if (isset($params->content->database->input)){
		    $tableData->body = $params->content->database->input->values;
		    
		    //Header can be stored in separate headers property
		    //In this case, we force the number of header lines and merge all the header lines with the main content
		    if (isset($params->content->database->input->headers)){
			$tableData->headers = $params->content->input->headers;
			/*if (count($dataContentHeader) != 0){
			    $data->table->header->length = count($dataContentHeader);
			    $dataContent = array_merge($dataContentHeader, $dataContent);
			    $data->content->input->options->cells = array_merge($data->content->input->options->headers->cells, $data->content->input->options->cells);
			    $data->content->input->options->rows = array_merge($data->content->input->options->headers->rows, $data->content->input->options->rows);
			    //Shift rows properties to the new full content
			    //for ($i=0;$i<$data->table->header->length;$i++)
			     //   array_unshift($data->content->input->options->rows, '');
			}*/
		    }
		}
		return $tableData;
	}	
	
	
}