<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(NGEPATH_CONTENTS . '/source/contentsource.php');

class NgeDatabaseFileContent extends NgeContentSource
{

	/**
	 * Get data and format it to be rendered in a "table" like widget
	 * @param type $params
	 * @return \NgeContentStructureTable
	 */
	static function getTableData($params){
	    
		require_once (NGEPATH_CONTENTS . '/structure/table.php');
		$tableData = new NgeContentStructureTable();
		if (isset($params->content->database->file->name)){
		    $filename = JPATH_ROOT . '/' . $params->content->database->file->name;
		    if (($filename != '') && (file_exists($filename))){
			switch (strtoupper(substr($filename, -3,3))){
			    case 'CSV' : 
				$handle = fopen($params->content->file,"r"); 
				$dataContent = array();
				while (($row = fgetcsv($handle, 1000, ";")) !== FALSE) 	{
				    $dataContent[] = $row;
				}
				$tableData->body = $dataContent;
			    break;
			}

		    }
		}
		return $tableData;
	}		
}