<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

require_once(NGEPATH_CONTENTS . '/source/contentsource.php');
require_once NGEPATH_HELPERS . '/ngedata.php'; //For mysql queries

class NgeDatabaseDbContent extends NgeContentSource
{
    
    /**
    * Get data and format it to be rendered in a "thumbnails" like widget
    * @param type $params
    * @return \NgeContentStructureTabs
    */
    static function getTabsData($params){

	require_once (NGEPATH_CONTENTS . '/structure/tabs.php');

	$items = array();
	$query = $params->content->database_db->database->db->query;
	    
	    if ($query != ''){
		if (isset($params->content->content->count) && $params->content->content->count != '0')
		    $query .= ' LIMIT 0,' . $params->content->content->count;
		
		$data = NGEDATA::loadAssocList($query);

		switch ($params->content->database_db->layout->mode) {
		    case 'template' :
			    require_once (NGEPATH_HELPERS . '/renderer/mustache/mustacherenderer.php');
			    foreach ($data as $contentRow) {
				    $item = new NgeContentStructureTabs();
				    if ($params->content->database_db->layout->template->label != '')
					$item->tab->label = MustacheRenderer::renderString($contentRow, $params->content->database_db->layout->template->label);
				    if ($params->content->database_db->layout->template->body != '')
					$item->body = MustacheRenderer::renderString($contentRow, $params->content->database_db->layout->template->body);
				    /*else
				    if ($data->content->database_db->layout->template->source == 'file')
					    $item->body = SmartyRenderer::render($contentRow, $data->content->database_db->layout->template->file);*/
				    $items[] = $item;
			    }
			    break;
		    default : //fields
			    foreach ($data as $row) {
				    $item = new NgeContentStructureTabs();
				    $item->body = '<table class="table">';
				    $firstField = true;
				    foreach ($row as $key => $value) {
					    if ($firstField == true) {
						    $item->tab->label = $value;;
						    $firstField = false;
					    }
					    $item->body .= '<tr><td>' . $key . '</td><td>' . $value . '</td></tr>';
				    }
				    $item->body .= '</table>';
				    $items[] = $item;
			    }
			    break;
		}
			    
	    }
	    return $items;

    }

    /**
    * Get data and format it to be rendered in a "thumbnails" like widget
    * @param type $params
    * @return \NgeContentStructureThumbnails
    */
    static function getThumbnailsData($params){
		

	require_once (NGEPATH_CONTENTS . '/structure/thumbnails.php');

	$items = array();
	$query = $params->content->database_db->database->db->query;
	    
	    if ($query != ''){
		if (isset($params->content->content->count) && $params->content->content->count != '0')
		    $query .= ' LIMIT 0,' . $params->content->content->count;
		
		$data = NGEDATA::loadAssocList($query);

		switch ($params->content->database_db->layout->mode) {
		    case 'template' :
			    require_once (NGEPATH_HELPERS . '/renderer/mustache/mustacherenderer.php');
			    foreach ($data as $contentRow) {
				    $item = new NgeContentStructureThumbnails();
				    if ($params->content->database_db->layout->template->label != '')
					$item->header->label = MustacheRenderer::renderString($contentRow, $params->content->database_db->layout->template->label);
				    if ($params->content->database_db->layout->template->body != '')
					$item->body = MustacheRenderer::renderString($contentRow, $params->content->database_db->layout->template->body);
				    if ($params->content->database_db->layout->template->caption != '')
					$item->caption = MustacheRenderer::renderString($contentRow, $params->content->database_db->layout->template->caption);
				    /*else
				    if ($data->content->database_db->layout->template->source == 'file')
					    $item->body = SmartyRenderer::render($contentRow, $data->content->database_db->layout->template->file);*/
				    $items[] = $item;
			    }
			    break;
		    default : //fields
			    foreach ($data as $row) {
				    $item = new NgeContentStructureThumbnails();
				    $item->body = '<table class="table">';
				    $firstField = true;
				    foreach ($row as $key => $value) {
					    if ($firstField == true) {
						    $labels[] = $value;
						    $firstField = false;
					    }
					    $item->body .= '<tr><td>' . $key . '</td><td>' . $value . '</td></tr>';
				    }
				    $item->body .= '</table>';
				    $items[] = $item;
			    }
			    break;
		}
	    }
	    return $items;

    }
    

    /**
    * Get data and format it to be rendered in a chart widget
    * @param type $params
    * @return \NgeContentStructureChart
    */
    static function getChartData($params){

	require_once (NGEPATH_CONTENTS . '/structure/chart.php');

	$contentParams = $params->params->get('content');
	$chart = $params->params->get('chart');
	$dbParams = $contentParams->database->db;	
	$chartData = new NgeContentStructureChart();
	
	//Titles data
	   if (isset($dbParams->titles->query) && ($dbParams->titles->query != '')){
		$query = $dbParams->titles->query;
		//Loadinf associative array for one record
		$titlesData = NGEDATA::loadAssoc($query);
		if ($titlesData != false){
		    if (isset($titlesData['title']))		$chartData->title = $titlesData['title'];
		    if (isset($titlesData['subtitle']))		$chartData->subtitle = $titlesData['subtitle'];
		    if (isset($titlesData['xaxistitle']))	$chartData->xaxistitle = $titlesData['xaxistitle'];
		    if (isset($titlesData['yaxistitle']))	$chartData->yaxistitle = $titlesData['yaxistitle'];
		    if (isset($titlesData['legendtitle']))	$chartData->legendtitle = $titlesData['legendtitle'];
		}
	    }
	
	//Series data
	if (isset($dbParams->series->mode)){
	    switch ($dbParams->series->mode){
		case 'unique' :
		    $query = $dbParams->series->query;
		    if ($query != ''){
			$dbData = NGEDATA::loadAssocList($query);
			if (count($dbData) > 0){
                            $seriesData = array();

                            switch ($chart->series->default->type) {
                                case "pie":
                                    foreach ($dbData as $keyRow => $dbRow) {
                                        $seriesData[$keyRow] = array();
                                        $seriesData[$keyRow]["data"] = array();
                                        $pointer = 0;
                                        foreach($dbData[$keyRow] as $keyValue => $dbValue){
                                            if($pointer === 0){ /*First value is general serie pie name*/
                                                $seriesData[$keyRow]["name"] = $dbValue;
                                            }else{ /*Series*/
                                                $currentSerieData = array();
                                                $currentSerieData["name"] = $keyValue;
                                                $currentSerieData["y"] = (float)$dbValue;
                                                array_push($seriesData[$keyRow]["data"], $currentSerieData);
                                            }
                                            $pointer++;
                                        }
                                    }
                                    
                                    $chartData->series = $seriesData;
                                    break;
                                default:
                                    //Series must have the same number of values and the same categorie (label) name
                                    foreach ($dbData as $keyRow => $dbRow) {
                                        $pointer = 0;
                                        foreach($dbData[$keyRow] as $keyValue => $dbValue){
                                            if($pointer === 0){ /*First value is category*/
                                                $chartData->categories[] = $dbValue;
                                            }else{ /*Series*/
                                                $seriesData[$keyValue][] = (float)$dbValue;
                                            }
                                            $pointer++;
                                        }
                                    }
                                    
                                    foreach ($seriesData as $serieName => $serieArrayValues) {
                                        $chartData->addSerie($serieName, $serieArrayValues);
                                    }
                                    break;
                            }
			}
		    }
                    
		    break;
		case 'multiple' :
		    //Series must have the same number of values and the same categorie (label) name
                    $firstSerie = true;
		    foreach ($dbParams->series->multiple->queries as $query){
			if ($query->query != ''){
			    $dbData = NGEDATA::loadAssocList($query->query);
			    if (count($dbData) > 0){
                                $seriesData = array();

                                //Series must have the same number of values and the same categorie (label) name
                                foreach ($dbData as $keyRow => $dbRow) {
                                    $pointer = 0;
                                    foreach($dbData[$keyRow] as $keyValue => $dbValue){
                                        if($pointer === 0){ /*First value is category only of the first serie*/
                                            if($firstSerie){
                                                $chartData->categories[] = $dbValue;
                                            }
                                        }else{ /*Series*/
                                            $serie_name = (isset($query->name) && $query->name !== "") ? $query->name : $keyValue;
                                            $seriesData[$serie_name][] = (float)$dbValue;
                                        }
                                        $pointer++;
                                    }
                                }

                                foreach ($seriesData as $serieName => $serieArrayValues) {
                                    $chartData->addSerie($serieName, $serieArrayValues);
                                }
                                
                                $firstSerie = false;
                            }
			}
		    }
		    break;
	    }
	}
	    
	//Additional custom data
	    $query = $dbParams->custom->query;
	    if ($query != ''){
		//Loadinf associative array for one record
		$informationData = NGEDATA::loadAssoc($query);
		if ($informationData != false)
		    $chartData->information['custom'] = $informationData;
	    }

	    return $chartData;
    }

    
	static function getLabel($data, $params){

	    switch ($params->layout->mode) {
		case 'fields' :
		    //Default label: first field
		    return current($data);
		    break;
		case 'template' :
		    require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
			$item = new stdClass();
			$item->editable = false;
			return SmartyRenderer::renderString($data, $params->layout->template->label);
		    break;
	    };		
	}

	static function getBody($data, $params)
	{
	    //$data is a row record
	    $item = new stdClass();
	    $item->editable = false;
	    
	    switch ($params->layout->mode) {
		case 'fields' :
		    $htmlRow = '<table class="table">';
		    $firstField = true;
		    foreach ($data as $key=>$value) {
			if ($firstField == true){
			    $item->label = $value;
			    $firstField = false;
			}
			$htmlRow .= '<tr><td>'.$key.'</td><td>'.$value.'</td></tr>' ;
		    }
		    $htmlRow .= '</table>';
		    return $htmlRow;
		    break;
		case 'template' :
		    require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
			$item = new stdClass();
			$item->editable = false;
			return SmartyRenderer::renderString($data, $params->layout->template->body);
		    break;
	    };		
	}
	
	/**
	 * Get Available fields. Will be used in layout display for example
	 */
	static function getFields(){
	    
	    $fields = array();
	    $fields[] = array('name'=>'title', 'label'=>'Title', 'type'=>'text');
	    $fields[] = array('name'=>'author', 'label'=>'Author', 'type'=>'text');
	    $fields[] = array('name'=>'created', 'label'=>'Created date', 'type'=>'text');
	    $fields[] = array('name'=>'modified', 'label'=>'Modified date', 'type'=>'text');
	    $fields[] = array('name'=>'published', 'label'=>'Published date', 'type'=>'text');
	    $fields[] = array('name'=>'images.image_intro', 'label'=>'Intro image', 'type'=>'image');
	    $fields[] = array('name'=>'category', 'label'=>'Category', 'type'=>'text');
	    $fields[] = array('name'=>'introtext', 'label'=>'Intro text', 'type'=>'editor');
	    $fields[] = array('name'=>'fulltext', 'label'=>'Full text', 'type'=>'editor');
	    return $fields;
	}
	
	/**
	 * Loading single resultset
	 * @param type $value
	 * @param type $params
	 * @return type
	 */
	static function loadBody($value, $params=array()){
	    $query = $value;
	    try {
		$result = '';
		if ($query != ''){
			$db = JFactory::getDbo();
			$db->setQuery($query);
			$data = $db->loadObject();
			return self::getBody($data, $params);
		}
		else
			 return '';	    
	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return '';
	    }		
	}
	
	static function loadLinkList($params){
	    	    $query = $params->query;
	    try {
		$result = '';
		if ($query != ''){
			$db = JFactory::getDbo();
			$db->setQuery($query);
			//$result = $db->loadAssocList();
			$data = $db->loadRowList();
//			$result = $db->loadObjectList();
			
			$result = array();
			foreach($data as $dataRow){
			    $row = new stdClass();
			    for ($i=0; $i<count($dataRow);$i++){
				if ($i==0)
				    $row->id= $dataRow[$i];
				else	
				    if ($i==1)
				$row->title= $dataRow[$i];
				    else	
				    if ($i==2)
				$row->link= $dataRow[$i];
			    }
			    $result[] = $row;
			}
			return $result;
		}
		else
			 return null;	    
	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return null;
	    }

	}
	
	static function loadBodyList($params){
	    $query = $params->query;
	    try {
		$result = '';
		if ($query != ''){
			$db = JFactory::getDbo();
			$db->setQuery($query);
			//$result = $db->loadAssocList();
			$data = $db->loadRowList();
//			$result = $db->loadObjectList();
			
			$result = array();
			foreach($data as $dataRow){
			    $row = new stdClass();
			    for ($i=0; $i<count($dataRow);$i++){
				if ($i==0)
				    $row->title= $dataRow[$i];
				else	
				    if ($i==1)
				$row->body= $dataRow[$i];
			    }
			    $result[] = $row;
			}
			return $result;
		}
		else
			 return null;	    
	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return null;
	    }
	}
	
	static function loadThumbnailList($params){
	    $query = $params->query;
	    try {
		$result = '';
		if ($query != ''){
			$db = JFactory::getDbo();
			$db->setQuery($query);
			//$result = $db->loadAssocList();
			$data = $db->loadRowList();
//			$result = $db->loadObjectList();
			
			$result = array();
			foreach($data as $dataRow){
			    $row = new stdClass();
			    $row->header= new stdClass();
			    $row->header->label = '';
			    $row->header->glyph= new stdClass();
			    $row->header->glyph->name = '';
			    $row->badge= new stdClass();
			    $row->badge->label = '';
			    $row->hover='';
			    $row->legend='';	
			    for ($i=0; $i<count($dataRow);$i++){
				if ($i==0)
				    $row->header->label= $dataRow[$i];
				else	
				    if ($i==1)
				$row->body= $dataRow[$i];
			    }
			    $result[] = $row;
			}
			return $result;
		}
		else
			 return null;	    
	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return null;
	    }
	}
	
	/**
	 * when multiple content
	 * get a result with multiple items
	 * @param type $params
	 * @return type
	 */
	static function loadList($params)
	{		
	    $query = $params->query;
	    try {
		$result = '';
		if ($query != ''){
			$db = JFactory::getDbo();
			$db->setQuery($query);
			//$result = $db->loadAssocList();
			$data = $db->loadRowList();
//			$result = $db->loadObjectList();
			
			$result = array();
			foreach($data as $dataRow){
			    $row = new stdClass();
			    for ($i=0; $i<count($dataRow);$i++){
				if ($i==0)
				    $row->title= $dataRow[$i];
				else	
				    if ($i==1)
				$row->body= $dataRow[$i];
			    }
			    $result[] = $row;
			}
			return $result;
		}
		else
			 return null;	    
	    }catch(Exception $e){
		trigger_error ( $e->getMessage(), E_USER_WARNING);
		return null;
	    }
	}
	
	/**
	 * Get data and format it to be rendered in a "table" like widget
	 * @param type $params
	 * @return \NgeContentStructureTable
	 */
	static function getTableData($params){
	    
		require_once (NGEPATH_CONTENTS . '/structure/table.php');
		$tableData = new NgeContentStructureTable();
		if (isset($params->content->database->db->query)){
		    $query = $params->content->database->db->query;	    
		    if ($query != '')
			$tableData->body = NGEDATA::loadRowList($query);
		}
		return $tableData;		
	}	
	
}