enableNgePositionEditable = function () {
    /* Positions */
    jQuery(".ngelayout-position").each(function(){
        var $layoutPosition = jQuery(this);
        var tagPosition = '#'+$layoutPosition.attr('id');
        var namePosition = $layoutPosition.attr('data-position');

        $layoutPosition.data("nge", {title: namePosition, itemtype: "page.position", itemid:tagPosition, itemselector:tagPosition});
    });	

    var timerHidePositionToolbar;
    jQuery(document).off("mouseenter mouseleave", ".ngelayout-position").on("mouseenter", ".ngelayout-position", function () {
        clearTimeout(timerHidePositionToolbar);
        
        jQuery(".ngetoolbar").hide();
        var $toolbarPosition = jQuery(this).find(".ngepositiontoolbar");
        jQuery(".ngetoolbarpositionhover").removeClass("ngetoolbarpositionhover");
        $toolbarPosition.addClass("ngetoolbarpositionhover");
    }).on("mouseleave", ".ngelayout-position", function () {
        var $toolbarPosition = jQuery(this).find(".ngepositiontoolbar");
        
        timerHidePositionToolbar = setTimeout(function () {
            $toolbarPosition.removeClass("ngetoolbarpositionhover");
        }, 300);
    });
    
    jQuery(".ngelayout-position").off("click", ".position-toolbar-theme").on("click", ".position-toolbar-theme", function(){
        var $buttonTheme = jQuery(this);
        nge.checkAuthentication(function(){
            ngePositionToolbarTheme($buttonTheme); 
        });
    });
    
    jQuery(".position-toolbar-theme").off("mouseenter mouseleave").on("mouseenter", function () {
        var title = jQuery(this).attr("data-original-title");
        jQuery(this).closest(".ngetoolbar-container").find(".ngetoolbar-status").html(title).show();
    }).on("mouseleave", function () {
        jQuery(this).closest(".ngetoolbar-container").find(".ngetoolbar-status").html("").hide();
    });
};	                       

/*
 * ngePositionToolbarTheme
 * Start modal config for current position
 * @param {jQuery Element} $button
 * @returns void
 */
ngePositionToolbarTheme = function($button){
    var layoutData = $button.closest('.ngelayout-position').data('nge');
    var formUrl = "index.php?option=com_nge&view=inlineconfig&type=nge.item&format=raw&layout=form";
    var data = "type=nge.item&itemtype=" + layoutData.itemtype + "&itemtitle=" +  layoutData.title + "&itemid=" + encodeURIComponent(layoutData.itemid) + "&itemselector=" + encodeURIComponent(layoutData.itemselector);
    loadInlineForm({url: formUrl,
        data: data,
        title: '<span class="icomoon-paint-format"></span>&nbsp;' + layoutData.title,
        backgroundColor: NGECOLORS_MODULE_HEADER,
        hoverColor: NGECOLORS_MODULE_BAR,
        width:  800,
        height: 500,
        refresh : function(css){
	var $position = jQuery(layoutData.itemselector);
	$position.find('.ngetmpcss').remove()
	$position.append('<style class="ngetmpcss">' + css + '</style>');
        },	
        submit : function(resultObj){
	var $position = jQuery(layoutData.itemselector);
	$position.find('.ngetmpcss').remove()
            var $currentInlineModal = jQuery("#inlineConfigForm");
            if(resultObj.old_css_id !== ""){ /*If customcss exist*/
                replacejscssfile("ngecustom_"+resultObj.old_css_id+".min.css", rootUrl+"components/com_nge/assets/css/ngecustom_"+resultObj.css_id+".min.css", "css");
            }else{/*else customcss is created*/
                loadjscssfile(rootUrl+"components/com_nge/assets/css/ngecustom_"+resultObj.css_id+".min.css", "css");
            }
            $currentInlineModal.modal("hide");
        },
        cancel : function(){
	var $position = jQuery(layoutData.itemselector);
	$position.find('.ngetmpcss').remove();
	}
    });
};

loadjscssfile = function(filename, filetype){
    if (filetype == "js"){ /*if filename is a external JavaScript file*/
        var fileref = document.createElement('script');
        fileref.setAttribute("type","text/javascript");
        fileref.setAttribute("src", filename);
    }else if (filetype == "css"){ /*if filename is an external CSS file*/
        var fileref = document.createElement("link")
        fileref.setAttribute("rel", "stylesheet");
        fileref.setAttribute("type", "text/css");
        fileref.setAttribute("href", filename);
    }
    
    if (typeof fileref != "undefined"){
        document.getElementsByTagName("head")[0].appendChild(fileref);
    }
}

createjscssfile = function (filename, filetype){
    if (filetype == "js"){ /*if filename is a external JavaScript file*/
        var fileref = document.createElement('script');
        fileref.setAttribute("type","text/javascript");
        fileref.setAttribute("src", filename);
    }else if (filetype == "css"){ /*if filename is an external CSS file*/
        var fileref = document.createElement("link");
        fileref.setAttribute("rel", "stylesheet");
        fileref.setAttribute("type", "text/css");
        fileref.setAttribute("href", filename);
    }
    
    return fileref;
}

replacejscssfile = function(oldfilename, newfilename, filetype){
    var targetelement=(filetype=="js")? "script" : (filetype=="css")? "link" : "none"; /*determine element type to create nodelist using*/
    var targetattr=(filetype=="js")? "src" : (filetype=="css")? "href" : "none"; /*determine corresponding attribute to test for*/
    var allsuspects=document.getElementsByTagName(targetelement);
    for (var i=allsuspects.length; i>=0; i--){ /*search backwards within nodelist for matching elements to remove*/
        if (allsuspects[i] && allsuspects[i].getAttribute(targetattr)!=null && allsuspects[i].getAttribute(targetattr).indexOf(oldfilename)!=-1){
            var newelement=createjscssfile(newfilename, filetype);
            allsuspects[i].parentNode.replaceChild(newelement, allsuspects[i]);
        }
    }
}

disableNgePositionEditable = function () {};  

/*Triggering functions.*/
jQuery(document).on( "ngeEnableTheming", function() {
    enableNgePositionEditable();
});    

jQuery(document).on( "ngeDisableTheming", function() {
    disableNgePositionEditable();
});