enableNgePageEditable = function () {
    /*Warning : data information is stored as object. It is not visible as attributes in the tags, but still present in the browser.*/

    //Main body
    jQuery("body").addClass("ngelayout-page").data("nge", {title:"Page body", itemtype: "page.body", itemid: "body", itemselector: "body, body.site"});

    /* For Protostar templates : main content */
    jQuery("div.body > div.container").addClass("ngelayout-page").data("nge", {title:"Main container", itemtype: "page.container", itemid: "container", itemselector: "div.body >div.container"});	
    jQuery("header.header a.brand").addClass("ngeinlineeditable ngeinlineimage").data("nge", {title: "Logo image", type: "image", source:"title"});					
    jQuery("header.header div.site-description").addClass("ngeinlineeditable ngeinlineeditor").data("nge", {title: "Site description", type: "editor", source:"title"});					

    /* For Protostar templates : main content */
    //TODO version 3.5.0
    jQuery("#content").addClass("ngelayout-page").data("nge", {title: "Content", itemtype: "page.content", itemselector: "#content"});	

    /*Footer*/
    jQuery("footer.footer").addClass("ngelayout-page").data("nge", {title: "Page footer", itemtype: "page.position", source:"title", itemid:"footer.footer", itemselector:"footer.footer"});
    jQuery("footer div.container").addClass("ngelayout-page").data("nge", {title:"Footer container", itemtype: "page.container", itemid: "footer.container", itemselector: "footer div.container"});	

    jQuery('.ngelayout-page').each(function(){
        jQuery(this).addClass("ngeeditable");
        var toolbarPageHtml = '<div class="ngepagetoolbar" style="display: none;">';
            toolbarPageHtml += '<div class="ngetoolbar-container">';
                toolbarPageHtml += '<span id="page-toolbar-title" class="ngetoolbar-title">' + jQuery(this).data('nge').title + '</span>';
                toolbarPageHtml += '<span class="page-container-absolute">';
                    toolbarPageHtml += '<span id="page-toolbar-plugins" class="page-toolbar-plugins">';
                        toolbarPageHtml += '<span class="page-toolbar-theme ngetoolbar-icon icomoon-paint-format" style="display:none;" data-toggle="tooltip" data-original-title="Theme"></span>';
                    toolbarPageHtml += '</span>';
                    toolbarPageHtml += '<span id="page-toolbar-status" class="ngetoolbar-status" style="display:none;"></span>';
                toolbarPageHtml += '</span>';
            toolbarPageHtml += '</div>';
        toolbarPageHtml += '</div>';
        toolbarPageHtml += '<div style="clear:both;"></div>';
        jQuery(this).prepend(toolbarPageHtml);
    });  
    
    /*Events*/
    var timerHidePageToolbar;
    jQuery(document).off("mouseenter mouseleave", ".ngelayout-page").on("mouseenter", ".ngelayout-page", function () {
        clearTimeout(timerHidePageToolbar);
        
        jQuery(".ngetoolbar").hide();
        var $toolbarPage = jQuery(this).find(".ngepagetoolbar").first();
        jQuery(".ngetoolbarpositionhover").removeClass("ngetoolbarpositionhover");
        $toolbarPage.addClass("ngetoolbarpagehover");
    }).on("mouseleave", ".ngelayout-page", function () {
        var $toolbarPage = jQuery(this).find(".ngepagetoolbar").first();
        
        timerHidePageToolbar = setTimeout(function () {
            $toolbarPage.removeClass("ngetoolbarpagehover");
        }, 300);
    });
    
    jQuery(".ngelayout-page").off("click", ".page-toolbar-theme").on("click", ".page-toolbar-theme", function(e){
        if (e.stopPropagation) e.stopPropagation();
        
        var $buttonTheme = jQuery(this);
        nge.checkAuthentication(function(){
            ngePageToolbarTheme($buttonTheme); 
        });
    });
    
    jQuery(".page-toolbar-theme").off("mouseenter mouseleave").on("mouseenter", function () {
        var title = jQuery(this).attr("data-original-title");
        jQuery(this).closest(".ngetoolbar-container").find(".ngetoolbar-status").html(title).show();
    }).on("mouseleave", function () {
        jQuery(this).closest(".ngetoolbar-container").find(".ngetoolbar-status").html("").hide();
    });
}
    
disableNgePageEditable = function () {
    jQuery('.ngelayout-page').removeClass("ngeeditable");
}  

/*
 * ngePageToolbarTheme
 * Start modal config for current page
 * @param {jQuery Element} $button
 * @returns void
 */
ngePageToolbarTheme = function($button){
    var layoutData = $button.closest('.ngelayout-page').data('nge');
    console.log(layoutData);
    var formUrl = "index.php?option=com_nge&view=inlineconfig&type=nge.item&format=raw&layout=form";
    var data = "type=nge.item&itemtype=" + layoutData.itemtype + "&itemtitle=" +  layoutData.title + "&itemid=" + encodeURIComponent(layoutData.itemid) + "&itemselector=" + encodeURIComponent(layoutData.itemselector);
    console.log(data);
    loadInlineForm({url: formUrl,
        data: data,
        title: '<span class="icomoon-paint-format"></span>&nbsp;' + layoutData.title,
        backgroundColor: NGECOLORS_MODULE_HEADER,
        hoverColor: NGECOLORS_MODULE_BAR,
        width:  800,
        height: 500,
        refresh : function(css){
	    console.log('refresh');
	    console.log(css);
	var $tag = jQuery(layoutData.itemselector);
	$tag.find('.ngetmpcss').remove()
	$tag.append('<style class="ngetmpcss">' + css + '</style>');
        },
        submit : function(resultObj){
	var $tag = jQuery(layoutData.itemselector);
	$tag.find('.ngetmpcss').remove()	    
            var $currentInlineModal = jQuery("#inlineConfigForm");
            if(resultObj.old_css_id !== ""){ /*If customcss exist*/
                replacejscssfile("ngecustom_"+resultObj.old_css_id+".min.css", rootUrl+"components/com_nge/assets/css/ngecustom_"+resultObj.css_id+".min.css", "css");
            }else{/*else customcss is created*/
                loadjscssfile(rootUrl+"components/com_nge/assets/css/ngecustom_"+resultObj.css_id+".min.css", "css");
            }
            $currentInlineModal.modal("hide");
        },
        cancel : function(){
	var $tag = jQuery(layoutData.itemselector);
	$tag.find('.ngetmpcss').remove();	    
	}
    });
};

loadjscssfile = function(filename, filetype){
    if (filetype == "js"){ /*if filename is a external JavaScript file*/
        var fileref = document.createElement('script');
        fileref.setAttribute("type","text/javascript");
        fileref.setAttribute("src", filename);
    }else if (filetype == "css"){ /*if filename is an external CSS file*/
        var fileref = document.createElement("link")
        fileref.setAttribute("rel", "stylesheet");
        fileref.setAttribute("type", "text/css");
        fileref.setAttribute("href", filename);
    }
    
    if (typeof fileref != "undefined"){
        document.getElementsByTagName("head")[0].appendChild(fileref);
    }
}

createjscssfile = function (filename, filetype){
    if (filetype == "js"){ /*if filename is a external JavaScript file*/
        var fileref = document.createElement('script');
        fileref.setAttribute("type","text/javascript");
        fileref.setAttribute("src", filename);
    }else if (filetype == "css"){ /*if filename is an external CSS file*/
        var fileref = document.createElement("link");
        fileref.setAttribute("rel", "stylesheet");
        fileref.setAttribute("type", "text/css");
        fileref.setAttribute("href", filename);
    }
    
    return fileref;
}

replacejscssfile = function(oldfilename, newfilename, filetype){
    var targetelement=(filetype=="js")? "script" : (filetype=="css")? "link" : "none"; /*determine element type to create nodelist using*/
    var targetattr=(filetype=="js")? "src" : (filetype=="css")? "href" : "none"; /*determine corresponding attribute to test for*/
    var allsuspects=document.getElementsByTagName(targetelement);
    for (var i=allsuspects.length; i>=0; i--){ /*search backwards within nodelist for matching elements to remove*/
        if (allsuspects[i] && allsuspects[i].getAttribute(targetattr)!=null && allsuspects[i].getAttribute(targetattr).indexOf(oldfilename)!=-1){
            var newelement=createjscssfile(newfilename, filetype);
            allsuspects[i].parentNode.replaceChild(newelement, allsuspects[i]);
        }
    }
}

/*Triggering functions.*/
jQuery(document).on( "ngeEnableTheming", function() {
    enableNgePageEditable();
});    

jQuery(document).on( "ngeDisableTheming", function() {
    disableNgePageEditable();
});