<?php
/*
 * @package     Joomla.Plugin
 * @subpackage  Content.nge
 *
 * @copyright   Teatis
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

?>
<script>  
    enableNgeModuleToolbar = function($selector) {
	$selector = typeof $selector !== 'undefined' ? $selector : jQuery(".ngeeditablestructuremodule");
		
	/*Toolbar*/
	<?php
	$toolbarHtml = str_replace(array("\r\n", "\r", "\n"), "", JLayoutHelper::render('nge.toolbars.modules.module', null));
	?>
	/*Creating module toolbar if not exists. this function can be called in update on single selectors*/
	if (!jQuery('#ngeeditablestructuremodule-toolbar').length) {	
	    jQuery("body").prepend('<?php echo $toolbarHtml; ?>');

	    var $moduleToolbar = jQuery('#ngeeditablestructuremodule-toolbar');
  
	    jQuery("#ngemoduletlb-remove").popover({
                html: true,
                content: function () {
                    var html = jQuery('#ngemoduletlb-remove-popover').html();
                    return html;
                },
                placement: "bottom"
            }).click(function (e) {
		if (!e) var e = window.event;
                e.cancelBubble = true;
                if (e.stopPropagation) e.stopPropagation();

                currentPopoverModuleToolbarRemove = jQuery(this);
                currentPopoverModuleToolbarRemove.popover('show');

                ngeModuleToolbarCancelPopover = function () {
                    currentPopoverModuleToolbarRemove.popover("hide");
                };
	    });
	}
    
        $selector.bind("mouseenter", function (e) {
            if(isPartSortable === false){
                jQuery(this).prepend(jQuery("#ngeeditablestructuremodule-toolbar"));
                /*Setting toolbar title*/
                if (jQuery(this).data('nge') !== undefined) {
                    jQuery('#module-toolbar-title').html(jQuery(this).data("nge").title);
                }	    

                var currentModule = jQuery(this);
                var currentModuleId = jQuery(this).attr('data-module-id');
                var currentModuleTitle = jQuery(this).data("module-label");

                /*Show move button for reorder module in position layout*/
                var toolbarMoveSelector = jQuery("#nge-editing-bar").find(".ngetlb-module-move");	
                jQuery(".ngetlb-module-move").not(toolbarMoveSelector).remove();
                var currentMoveSelector = toolbarMoveSelector.clone();
                currentModule.append(currentMoveSelector);   

                /*Update toolbar*/ 
                if (jQuery(this).hasClass("ngeunpublished")) {
                    jQuery('#module-toolbar-title').html("<?php echo NGE::translate('COM_NGE_TITLE_UNPUBLISHEDMODULE'); ?>");
                    jQuery('#ngemoduletlb-publish').show();
                    jQuery('#ngemoduletlb-edit').hide();
                    jQuery('#ngemoduletlb-duplicate').hide();
                    jQuery('#ngemoduletlb-unpublish').hide();
                } else {
                    jQuery('#module-toolbar-title').html("<?php echo NGE::translate('COM_NGE_TITLE_MODULE'); ?>");
                    jQuery('#ngemoduletlb-unpublish').show();
                    jQuery('#ngemoduletlb-publish').hide();
                    jQuery('#ngemoduletlb-edit').show();
                    currentMoveSelector.show();
                    jQuery('#ngemoduletlb-duplicate').hide();
                }

                jQuery('#part-moduletoolbar-title').html(currentModuleTitle);
	var $moduleToolbar = jQuery('#ngeeditablestructuremodule-toolbar');
                $moduleToolbar.attr('data-module-id', currentModuleId);

                /*Show Toolbar*/
                
                jQuery("#module-toolbar-info").css({"margin-left": ($moduleToolbar.outerWidth() - 6) + "px"});					
                jQuery("#module-toolbar-status").html(jQuery("#module-toolbar-title").attr("data-module-toolbar-title"));
	  $moduleToolbar.css({"top": -($moduleToolbar.outerHeight()) + "px"});
                $moduleToolbar.show();
            }
        }).mouseleave(function () {
	var $moduleToolbar = jQuery('#ngeeditablestructuremodule-toolbar');
            $moduleToolbar.hide();
            jQuery(".ngetlb-module-move").hide();
            jQuery('body').prepend($moduleToolbar);
            /*Setting toolbar title*/
            if (jQuery('body').data('nge') !== undefined) {
                jQuery('#module-toolbar-title').html(jQuery(this).data("nge").title);
            }
        });
    };	
  
  
  /* Get parent structure module of a ngemodule tag, Due to differents chrome styles, structure tag can be in parents */
getModuleStructureTag = function(selector){
	var $structureModuleTag = jQuery(selector);
	var nbParents = 0;
	if (!$structureModuleTag.parent().parent().hasClass('ngelayout-position')) {
	    while ((!$structureModuleTag.parent().parent().hasClass('ngelayout-position')) && (nbParents <20)){
		$structureModuleTag = $structureModuleTag.parent();
		nbParents++;
	    }
	}
	//If mainModuleTag found, adding toolbar
	if ($structureModuleTag.parent().parent().hasClass('ngelayout-position')) {
	    return $structureModuleTag;
	}
	else
	    return undefined;
}
        
/* Adding editing capabilities dynamically for new modules being created or edited*/    
updateNgeModuleEditable = function (selector) {  
	enableNgeModuleEditable(selector);
	enableNgetoolbars();	
	enableNgeModuleEditable(selector);
	enableNgeModuleToolbar(getModuleStructureTag(selector));	
}
  
  
  ngeModuleToolbarConfig = function(button){
	var $structure = jQuery(button).closest('.ngeeditablestructure');
	var structureData = jQuery($structure).data('nge');
	
	var moduleConfigForm = jQuery("#moduleConfigForm");
	var moduleConfigIframe = jQuery("#moduleconfig_iframe");

	moduleConfigIframe.contents().find("html").html('<div style="margin-left:50%;margin-top:100px;"><img src="' + baseUrl + 'components/com_nge/assets/images/spinner.gif" /></div>');
	moduleConfigForm.modal("show");
	
	/*moduleConfigIframe.attr("src", "index.php?option=com_nge&view=module&layout=edit&caller=layout.position&mode=edit&format=raw&id=" + m_id);*/
	moduleConfigIframe.attr("src", "index.php?option=com_nge&view=module&layout=edit&caller=layout.position&mode=edit&tmpl=component&ngetemplate=admin&id=" +  structureData.id);
	
	isPartHover = false;
	//jQuery("#module-" + m_id).trigger("mouseleave");
};

/**
 * @name duplicateCurrentModule
 * @description duplicate current module in same position
 * @returns void
 */
ngeModuleToolbarDuplicate = function(button){
//duplicateCurrentModule = function ($module) {
    //var module = jQuery("#module-ngetoolbar-duplicate").closest(".ngemodule-joomla");
	var $structure = jQuery(button).closest('.ngeeditablestructure');
	var structureData = jQuery($structure).data('nge');

    /*Searching part id and closest parent layout (columns or position layout)    	*/
    //var m_id = $module.attr('data-module-id');
    var m_id = structureData.id;
    if (typeof m_id != "undefined") {
    	var url = 'index.php?option=com_nge&task=module.duplicate';
    	var token = jQuery('#tokenform').find('input').attr('name');
    	var data = {};    	
    	data['m_id'] = m_id;
    	data[token] = 1;
	var moduleHeight = $structure.height();
	var moduleWidth = $structure.width();
	$structure.after('<div id="ngetmpmodule" style="height:'+moduleHeight+';width:'+moduleWidth+';padding-left:50%;padding-top:'+moduleHeight/2+'px;"><img src="' + baseUrl + 'components/com_nge/assets/images/spinner.gif" /></div>');

		jQuery.ajax({
		    url: url,
		    data: data,
		    type: 'POST',
		    success: function (resultJson) {
		    	ajaxResult = jQuery.parseJSON(resultJson);
				if (ajaxResult.result == '1') {
		
				    /*Add edit attributes and events for this new part*/
				    //module.after(createParentDivModule);
				    jQuery("#ngetmpmodule").remove();
				    $structure.after(ajaxResult.html);
				    var partElement = $module.find(".part");
		
				    if (partElement.length == 1){
				    	enableNgePartToolbar('#part-' + ajaxResult.pk);
				    }
				    else{
					updateNgeModuleEditable('#module-' + ajaxResult.m_id);					
				    }
				} else {
				    bootbox.alert("Error : " + ajaxResult.message);
				}
		    },
		    error: function (result) {
		    	console.error(result);
		    }
		});
    }
};


/**
 * @name publishCurrentModule
 * @description publish current module
 * @returns void
 */
ngeModuleToolbarPublish = function (button) {
	var $structure = jQuery(button).closest('.ngeeditablestructure');
	var structureData = jQuery($structure).data('nge');
	var m_id = structureData.id;

        //var m_id = jQuery('#module-ngetoolbar').attr('data-module-id');
    var $currentModule = jQuery('#module-'+m_id);
    var result = false;

    if (typeof m_id != "undefined") {
	var url = 'index.php?option=com_nge&task=inline.publish&rendering=editor';
	var token = jQuery('#tokenform').find('input').attr('name');
	var data = {};
	data['id'] = m_id;
	data['type'] = 'module';
	data[token] = token;

	jQuery.ajax({
	    url: url,
	    data: data,
	    type: 'POST',
	    async: false,
	    success: function (resultJson) {
		ajaxResult = jQuery.parseJSON(resultJson);
		if (ajaxResult.result == '1') {
		    var $moduleToolbar = jQuery("#ngeeditablestructuremodule-toolbar");
		    $moduleToolbar.hide();
		    jQuery('body').prepend($moduleToolbar);
		    $currentModule.html(ajaxResult.html);
		    $currentModule.removeClass("ngeunpublished");
		    /*Adding inside module id tag to be used further by the enableNgeModuleEditable function to make this module editable*/
		    $structure.data("module-id", m_id);	

		    jQuery('#ngemoduletlb-publish').hide();
		    jQuery('#ngemoduletlb-unpublish').show();

		    /*Add edit attributes and events for this new module content*/
		    updateNgeModuleEditable('#module-' + m_id);
		    enableNgePartToolbar('#module-' + m_id, true);
		    if (undefined != ajaxResult.message)
			bootbox.alert(ajaxResult.message);
		    
		    result = true;
		} else {
		    bootbox.alert("Error : " + result.message);
		}
	    },
	    error: function (result) {
		bootbox.alert("Error : Wrong url, may be 500 Internal Servor Error =>" + result);
	    }
	});
    }

    return result;
};


/**
 * @name unpublishCurrentModule
 * @description unpublish current  module
 * @returns void
 */
ngeModuleToolbarUnpublish = function (button) {
    /*Searching part id and closest parent layout (columns or position layout)    	*/
	var $structure = jQuery(button).closest('.ngeeditablestructure');
	var structureData = jQuery($structure).data('nge');
	var m_id = structureData.id;
	var result = false;

    if (typeof m_id != "undefined") {
	var url = 'index.php?option=com_nge&task=inline.unpublish&rendering=editor';
	var token = jQuery('#tokenform >input').attr('name');
	var data = {};
	data['id'] = m_id;
	data['type'] = 'module';
	data[token] = token;

	jQuery.ajax({
	    url: url,
	    data: data,
	    type: 'POST',
	    async: false,
	    success: function (resultJson) {
		ajaxResult = jQuery.parseJSON(resultJson);
		if (ajaxResult.result == '1') {
		    /*Moving module toolbar before makgin changes */
		    var $moduleToolbar = jQuery("#ngeeditablestructuremodule-toolbar");
		    $moduleToolbar.hide();
		    jQuery('body').prepend($moduleToolbar);
		    $structure.html(ajaxResult.html);
		    /* If we are in well chrome style, removing class*/
		    $structure.removeClass('well');
		    /*Adding data for unpublished modules. See system plugin */
		    $structure.addClass('ngemodule ngemodule-joomla ngeunpublished');
		    $structure.attr('data-module-id', m_id);
		    $structure.data("nge", {title:"Module", type: "module", id: m_id});	

		    //Update toolbar buttons
		    jQuery('#ngemoduletlb-publish').show();
		    jQuery('#ngemoduletlb-unpublish').hide();

		    /*Add edit attributes and events for this new module content*/		    
		    updateNgeModuleEditable('#'+$structure.attr('id'));

		    if (undefined != ajaxResult.message)
			bootbox.alert(ajaxResult.message);

		    result = true;
		} else {
		    bootbox.alert("Error : " + result.message);
		}
	    },
	    error: function (result) {
		bootbox.alert("Error : Wrong url, may be 500 Internal Servor Error =>" + result);
	    }
	});
    }
    return result;
};

    
    /**
 * @name removePositionModuleJoomla
 * @description remove module joomla
 * @returns void
 */
ngeModuleToolbarRemove = function () {
	var $structure = jQuery("#ngeeditablestructuremodule-toolbar").closest('.ngeeditablestructure');
	var structureData = jQuery($structure).data('nge');
	var m_id = structureData.id;
	if (typeof m_id != "undefined") {
		var url = 'index.php?option=com_nge&task=module.delete';
		var token = jQuery('#tokenform').find('input').attr('name');
		var data = {};
		data['m_id'] = m_id;
		data[token] = token;
	
		jQuery.ajax({
		    url: url,
		    data: data,
		    type: 'POST',
		    success: function (resultJson) {
			result = jQuery.parseJSON(resultJson);
			    jQuery("#ngeeditablestructuremodule-toolbar").hide();
			    jQuery('body').prepend(jQuery("#ngeeditablestructuremodule-toolbar"));
			    isPartHover = false;
			    if (result.result == '1'){
				$structure.remove();
				if (undefined != result.message)
				bootbox.alert(result.message);
				
			    }
			    else
				console.error("Error : " + result.message);
		    },
		    error: function (result) {
		    	console.error("Error : Wrong url, may be 500 Internal Servor Error =>" + result);
		    }
		});
	}
};


/*Nge Module Toolbar function Information*/
    ngeModuleToolbarInformation = function(button){
		var $structure = jQuery(button).closest('.ngeeditablestructure');
		var structureData = jQuery($structure).data('nge');
		 loadInlineForm({url: "index.php?option=com_nge&view=inlineconfig&type=element&element=module&format=raw&layout=form&form=information&id=" + structureData.id,
			id: structureData.id,
			title: '<span class="icomoon-info"></span>&nbsp;Module',
			buttons : ['close'],
			backgroundColor: '#f77',
			width:  500,
			height: 300,
			submit : function(partId, itemid, itemlabel){
			},
			cancel : function(element, oldImageName, currentImageName){
			}
		});    

    };

   /*Triggering function when unlock page edition*/
    jQuery(document).on( "ngeEnableEdition", function() {
	enableNgeModuleToolbar();
    });
    
    jQuery(document).on( "ngeStartEdition", function() {


    });
    
    
</script>
<style>    
#ngeeditablestructuremodule-toolbar{
    left:0px;
    top:-30px;
}
#module-toolbar-title, #module-toolbar-status, #module-toolbar-save{
    background: #F77;
}

#ngeeditablestructuremodule-toolbar .ngetoolbar-icon{
    background: #F77;
}

#ngeeditablestructuremodule-toolbar .ngetoolbar-icon:hover{
    background: #d55;
}

</style>