<?php
/*
 * @package     Joomla.Plugin
 * @subpackage  Content.nge
 *
 * @copyright   Teatis
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
//} catch(Exception $e){
//	echo 'NextGenEditor component not found. Please install NextGenEditor component or disable NextGenEditor plugin.';
//}
defined('_JEXEC') or die;

require_once NGEPATH_CONTENTS . '/editing/contentediting.php';

/**
 * Plug-in to enable loading parts into content (e.g. articles)
 * This uses the {loadnge} syntax
 *
 * @package     Joomla.Plugin
 * @subpackage  Content.nge
 * @since       2.5
 */
class NgeK2Editing extends NgeContentEditing {
    
    public static function addInlineEditing($context, &$article, &$params, $page = 0) {
	
	switch ($context) {
	    case 'com_k2.item' :
		//Cache testing : addEditing once
		if (!isset(self::$inlineEditingStructures[$context.$article->id])){
		    self::itemEditing($context, $article, $params, $page = 0);
		    self::$inlineEditingStructures[$context.$article->id] = 1;
		}
		break;
	    case 'com_k2.itemlist' :
		/* To keep the item id for further processing */
		$article->introtext = '<div class="ngek2itemintrotext" data-id="' . $article->id . '">' . $article->introtext . '</div>';
		$article->fulltext = '<div class="ngek2itemfulltext" data-id="' . $article->id . '">' . $article->fulltext . '</div>';
		$article->text = '<div class="ngek2itemtext" data-id="' . $article->id . '">' . $article->text . '</div>';
		
		//Cache testing : addEditing once
		if (!isset(self::$inlineEditingStructures[$context.$article->id])){
		    self::itemlistEditing($context, $article, $params, $page = 0);
		    self::$inlineEditingStructures[$context.$article->id] = 1;
		}
		break;
	    case 'mod_k2_content' :
		//Cache testing : addEditing once
		$article->text = '<div class="ngek2modcontent" data-id="' . $article->id . '">' . $article->text . '</div>';		    
		if (!isset(self::$inlineEditingStructures[$context.$article->id])){
		    self::modcontentEditing($context, $article, $params, $page = 0);
		    self::$inlineEditingStructures[$context.$article->id] = 1;
		}
		break;
	}
    }
    
    private static function itemEditing($context, &$article, &$params, $page = 0){
	//NgeContenthelper::addContentPluginLayout('layout.k2item');
	
	include_once NGEPATH_CONTENTS . '/k2/editing/k2item_editable_js.php';
	include_once NGEPATH_CONTENTS . '/k2/editing/k2item_editable_js.php';
	include_once NGEPATH_CONTENTS . '/k2/editing/k2item_toolbar_js.php';		
	include_once NGEPATH_CONTENTS . '/k2/editing/modal.configk2item.php';		
	
	/*$article->text = '<div class="ngelayout ngelayout-k2item" data-ngelayout="k2item" data-nge-id="' . $article->id . '" data-title="' . $article->title . '">'
						//.JLayoutHelper::render('nge.layouts.toolbar.article')
						. '<div class="content">' . $article->text . '</div></div>';*/
    }
    
    private static function itemlistEditing($context, &$article, &$params, $page = 0){
	//NgeContenthelper::addContentPluginLayout('layout.k2item');
	
	include_once NGEPATH_CONTENTS . '/k2/editing/k2itemlistarticle_editable_js.php';	
	include_once NGEPATH_CONTENTS . '/k2/editing/modal.configk2item.php';		
	
	/*$article->text = '<div class="ngelayout ngelayout-k2item" data-ngelayout="k2item" data-nge-id="' . $article->id . '" data-title="' . $article->title . '">'
						//.JLayoutHelper::render('nge.layouts.toolbar.article')
						. '<div class="content">' . $article->text . '</div></div>';*/
    }
    
    private static function modcontentEditing($context, &$article, &$params, $page = 0){
	//NgeContenthelper::addContentPluginLayout('layout.k2item');
	
	//content module
	include_once NGEPATH_CONTENTS . '/k2/editing/k2modcontent_editable_js.php';	
	include_once NGEPATH_CONTENTS . '/k2/editing/k2modcontent_toolbar_js.php';	
	include_once NGEPATH_CONTENTS . '/k2/editing/modal.configk2item.php';		
	//items
	//include_once JPATH_SITE . '/plugins/content/nge_content/content/content/blogarticle_editable_js.php';	
	include_once NGEPATH_CONTENTS . '/k2/editing/k2item_toolbar_js.php';		
	include_once NGEPATH_CONTENTS . '/k2/editing/modal.configk2item.php';			
	
	/*$article->text = '<div class="ngelayout ngelayout-k2item" data-ngelayout="k2item" data-nge-id="' . $article->id . '" data-title="' . $article->title . '">'
						//.JLayoutHelper::render('nge.layouts.toolbar.article')
						. '<div class="content">' . $article->text . '</div></div>';*/
    }
    
    
}
