<?php
/*
 * @package     Joomla.Plugin
 * @subpackage  Content.nge
 *
 * @copyright   Teatis
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
//} catch(Exception $e){
//	echo 'NextGenEditor component not found. Please install NextGenEditor component or disable NextGenEditor plugin.';
//}
defined('_JEXEC') or die;

require_once NGEPATH_CONTENTS . '/editing/contentediting.php';


/**
 * Plug-in to enable loading parts into content (e.g. articles)
 * This uses the {loadnge} syntax
 *
 * @package     Joomla.Plugin
 * @subpackage  Content.nge
 * @since       2.5
 */
class NgeComponentEditingContent extends NgeContentEditing {
    
    public static function addInlineEditing($context, &$article, &$params, $page = 0) {	
	
	    switch ($context) {
		case 'com_content.article' :
		    self::articleEditing($context, $article, $params, $page = 0) ;
		    break;
		case 'com_content.featured' :
		    /* To keep the article id for further processing */
		    $article->introtext = '<div class="ngearticleintrotext" data-id="' . $article->id . '">' . $article->introtext . '</div>';
		    $article->fulltext = '<div class="ngearticlefulltext" data-id="' . $article->id . '">' . $article->fulltext . '</div>';
		    $article->text = '<div class="ngearticletext" data-id="' . $article->id . '">' . $article->text . '</div>';
		    self::featuredEditing($context, $article, $params, $page = 0) ;
		    break;		
		case 'com_content.category' :
		    //If id defined : article in blog.
		    //If not category description (Joomla 3.5.xx)
		    if (isset($article->id)){
			$article->introtext = '<div class="ngearticleintrotext" data-id="' . $article->id . '">' . $article->introtext . '</div>';
			$article->fulltext = '<div class="ngearticlefulltext" data-id="' . $article->id . '">' . $article->fulltext . '</div>';
			$article->text = '<div class="ngearticletext" data-id="' . $article->id . '">' . $article->text . '</div>';		    
		    }else {
			
		    }
		    self::categoryEditing($context, $article, $params, $page = 0) ;
		    break;				
		case 'com_content.categories' :
		    self::categoriesEditing($context, $article, $params, $page = 0) ;
		    break;
	    }
    }
    
    private static function articleEditing($context, &$article, &$params, $page = 0){
	//Saving in array of all layouts used
	NgeContenthelper::addContentPluginLayout('layout.article');
	/*$article->text = '<div class="ngelayout ngelayout-article" data-ngelayout="article" data-nge-id="' . $article->id . '" data-title="' . $article->title . '">'
						//.JLayoutHelper::render('nge.layouts.toolbar.article')
						. '<div class="content">' . $article->text . '</div></div>';				*/
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/article_editable_js.php';	
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/article_toolbar_js.php';			
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/modal.configarticle.php';		
    }
    
    private static function featuredEditing($context, &$article, &$params, $page = 0){
	//Saving in array of all layouts used
	//NgeContenthelper::addContentPluginLayout('layout.article');
	/*$article->text = '<div class="ngelayout ngelayout-article" data-ngelayout="article" data-nge-id="' . $article->id . '" data-title="' . $article->title . '">'
						//.JLayoutHelper::render('nge.layouts.toolbar.article')
						. '<div class="content">' . $article->text . '</div></div>';				*/
	//featured
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/featured_editable_js.php';	
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/featured_toolbar_js.php';	
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/modal.configcontentfeatured.php';		
	//articles
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/blogarticle_editable_js.php';	
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/article_toolbar_js.php';		
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/modal.configarticle.php';			
    }
    
    private static function categoryEditing($context, &$article, &$params, $page = 0){
	//Saving in array of all layouts used
	//NgeContenthelper::addContentPluginLayout('layout.article');
	/*$article->text = '<div class="ngelayout ngelayout-article" data-ngelayout="article" data-nge-id="' . $article->id . '" data-title="' . $article->title . '">'
						//.JLayoutHelper::render('nge.layouts.toolbar.article')
						. '<div class="content">' . $article->text . '</div></div>';				*/
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/category_editable_js.php';	
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/category_toolbar_js.php';	
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/modal.configcontentcategory.php';		
	//articles
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/blogarticle_editable_js.php';	
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/article_toolbar_js.php';		
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/modal.configarticle.php';			
	
    }
    
    private static function categoriesEditing($context, &$article, &$params, $page = 0){
	
	include_once NGEPATH_CONTENTS . '/editing/components/com_content/categories_editable_js.php';	
	//include_once NGEPATH_CONTENTS . '/editing/components/com_content/modal.configcontentcategories.php';		
	
    }
    
    
}
