<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access.
defined('_JEXEC') or die;

require_once(NGEPATH_HELPERS . '/ngepartshelper.php');

/**
 * Class nge article.
 * @since 1.0
 */
class NgePartObject {

	public $id;
	public $title;
	public $alias;
	public $part;
	public $content;
	public $params;
	public $language;
	public $published;
	public $created_by;

	/**
	 * Creating part
	 *
	 */
	public function __construct($data = null) {
		if($data != null){
			$this->id = $data->id;
			$this->title = $data->title;
			$this->alias = $data->alias;
			$this->part = $data->part;
			$this->content = $data->content;
			$this->params = $data->params;
			$this->language = $data->language;
			$this->published = $data->published;
			$this->created_by = $data->created_by;
		}else{
			$this->id = '';
			$this->title = '';
			$this->alias = '';
			$this->part = '';
			$this->content = '';
			$this->params = '';
			$this->language = '';
			$this->published = 1;
			$user = JFactory::getUser();
			$this->created_by = $user->id;
		}
	}

	//Merging existing content with new content
	public function mergeContent($contentString) {
		if ($this->content == '')
			$this->content = $contentString;
		else {
			$oldContentArray = json_decode($this->content, true);
			$newContentArray = json_decode($contentString, true);
			$mergedContentArray = NGE::array_merge_recursive_replace($oldContentArray, $newContentArray);

			$this->content = json_encode($mergedContentArray);
		}
	}

	//Merging existing params with new PARAMS
	public function mergeParams($params) {

		$oldParamsArray = json_decode($this->params, true);
		$newParamsArray = $params;
		$mergedParamsArray = NGE::array_merge_recursive_replace($oldParamsArray, $newParamsArray);

		$this->params = json_encode($mergedParamsArray);
	}

	/**
	 * Saving part
	 *
	 */
	public function save() {
                $user = JFactory::getUser();
                
		//Trigger onPartBeforeSave event
		JPluginHelper::importPlugin('nge');
		$result = NGE::triggerEvent('onPartBeforeSave', array(&$this));
		if (in_array(false, $result, true))
			return false;

		$this->alias = NGE::stringURLSafe($this->alias);

		$db = JFactory::getDBO();
		$save_result = false;
		
		//Part name exists?
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select(array('part'));
		$query->from('#__nge_parts_library');
		$query->where('part=' . $db->quote($this->part));
		$query->where('state=1');
		$db->setQuery($query);
		$result = $db->loadObject();
		if ($result == false)
			return false;
	    $partname = $result->part;

		
		
		//Existing part, updating params and resetting cache fields		
		if ($this->id != '') {
			$sql = "UPDATE #__nge_parts SET title = '" . addslashes($this->title) . "', alias = '" . $this->alias . "', published = " . $this->published . ",content = '" . addslashes($this->content) . "', params = '" . addslashes($this->params) . "', html='', css='', js='', modified=NOW(), modified_by='" . $user->id . "' WHERE id=" . (int) $this->id;
			$db->setQuery($sql);
			$save_result = $db->execute();
		} else {//Creating a new part
			//Creating part
			$query = $db->getQuery(true);
			$columns = array('part', 'title', 'alias', 'content', 'params', 'language', 'published', 'created', 'created_by');
			$values = array("'" . $this->part . "', '" . addslashes($this->title) . "', '" . $this->alias . "', '" . addslashes($this->content) . "', '" . addslashes($this->params) . "', '*'", $this->published, 'NOW()', $this->created_by);
			$query->insert($db->quoteName('#__nge_parts'))
					->columns($db->quoteName($columns))
					->values(implode(',', $values));
			$db->setQuery($query);
			$save_result = $db->execute();
			$this->id = $db->insertid();
		}

		/* 	    // complete property $part_category
		  $sql = "SELECT part FROM #__nge_parts WHERE id=$this->idpart";
		  $db->setQuery($sql);
		  $this->part_category = $db->loadResult();
		 */
		//Trigger onPartAfterSave event
		NGE::triggerEvent('onPartAfterSave', array($this->id));

		return $save_result;
	}
	
		/**
	 * Render the part.
	 *
	 * @param   object  $part   A part object.
	 * @param   array   $attribs  An array of attributes for the part
	 *
	 * @return  string  The HTML content of the module output.
	 *
	 */
	public function render($attribs = array())
	{		
		return NgePartHelper::render($this, $attribs);
	}
	

}
