<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access.
defined('_JEXEC') or die;


/**
 * Class nge object.
 * @since 1.0
 */
class NgeModuleObject {

	/**
	 * 	Id of the part
	 * 	@var Integer $name   
	 */
	public $id;
	public $title;
	public $content;
	public $ordering;
	public $position;
	public $published;
	public $module;
	public $showtitle;
	public $params;

	/**
	 * Creating part
	 *
	 */
	public function __construct() {

		$this->id = '';
		$this->title = '';
		$this->content = '';
		$this->ordering = 0;
		$this->position = '';
		$this->published = 1;
		$this->module = '';
		$this->showtitle = 1;
		$this->params = '';		
	}

	/**
	 * Saving part
	 *
	 */
	public function save() {

		$moduleTable = JTable::getInstance("module");
		$moduleTable->bind(JArrayHelper::fromObject($this));
		if ($moduleTable->check()){
			
			$isNewModule = $moduleTable->id == '' ? true : false;
			
			//Saving module
			$moduleTable->store();
			$this->id = $moduleTable->id;
			
			//reorder in position
			$moduleTable->reorder();			
			
			//if New module : default assignment in all menus
			if ($isNewModule){
				$db = JFactory::getDBO();
				$query = $db->getQuery(true);
				$query->clear()
					->insert('#__modules_menu')
					->columns(array($db->quoteName('moduleid'), $db->quoteName('menuid')))
					->values((int) $moduleTable->id . ', 0');
				$db->setQuery($query);
				$db->execute();
			}	

			
			return true;
		}
		else {
			return false;
		}
		
		/*
		$model = new NgeModelconfigmodule();
		$model = JModel::getInstance('module','ModulesModel');

		$result = $model->save($data);
*/
	}
	
		/**
	 * Render the part.
	 *
	 * @param   object  $part   A part object.
	 * @param   array   $attribs  An array of attributes for the part
	 *
	 * @return  string  The HTML content of the module output.
	 *
	 */
	public function render($attribs = array())
	{	
			//Disable content plugins
			$j = new JRegistry();
			$j->loadString($this->params);
			$j->set('prepare_content',0);			
			$this->params = $j->toString();
			$attribs['style'] = 'xhtml';

			$content = JModuleHelper::renderModule( $this, $attribs );
			$params = array();
			$params['medium'] = 'modulepreview';
			$content = JHtml::_('content.prepare',$content,$params);
			
			$class = "";
			if($this->module == 'mod_nge')
				$class = "ngemodule-part";
			else
				$class = "ngemodule-joomla";

			$html = '<div id="module-'.$this->id.'" class="ngemodule '.$class.'" data-module-label="'.$this->title.'" data-module-id="'.$this->id.'">';
			$html .= $content;
			$html .= '</div>';
			
			return $html;

	}

}
