<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

// No direct access.
defined('_JEXEC') or die;

require_once JPATH_SITE . '/components/com_nge/classes/ngemoduleobject.php';

/**
 * Class nge module.
 * @since 1.0
 */
class NgeModuleHelper{
	private $module = "";
	/**
	 * Method to create a Joomla module
	 * @since 1.0
	 * @param String type : joomla or part
	 * @param Array data
	 * @return object (article information) or false if not created
	 */
	
	public static function createModule($data){
		$module = new NgeModuleObject();
		if (isset($data['title']))		$module->title = $data['title'];
		if (isset($data['content']))		$module->content = $data['content'];
		if (isset($data['ordering']))		$module->ordering = $data['ordering'];
		if (isset($data['position']))		$module->position = $data['position'];
		if (isset($data['published']))	$module->published =  $data['published'];	
		if (isset($data['module']))		$module->module =  $data['module'];	
		if (isset($data['params']))		$module->params = $data['params'];

		if ($module->module == '')
			return false;
	
		if ($module->save())
			return $module;
		else
			return false;
	}
		
	public static function createNgeModule($partPk, $partName, $position, $previousModulePk=0) {
    			
		$partNameExplode = explode('.',$partName);
		$moduleTitle = 'NGE_'.$partNameExplode[count($partNameExplode)-1].'_'.$partPk;
		
		// get module ordering
		$moduleOrdering = 1;
		if($previousModulePk!=0) {
			$db	= JFactory::getDBO();
			$db->setQuery( 'SELECT ordering FROM #__modules WHERE id=' . (int) $previousModulePk);
			$moduleOrdering =$db->loadResult();	
		}
        
		$module = new NgeModuleObject();

		$module->title = $moduleTitle;
		$module->ordering = $moduleOrdering;
		$module->position = $position;
		$module->module = 'mod_nge';
		$module->showtitle = 0;
		$params = array();
		$params['id'] = $partPk;
		$params['module_tag'] = 'div';
		$params['bootstrap_size'] = '0';
		$params['header_tag'] = 'h3';
		$params['style'] = '0';
		$module->params = json_encode($params);
		
		if ($module->save())
			return  $module;
		else
			return false;
	}
	
	/**
	 * Method to get a Joomla module object
	 * @since 1.0
	 * @param id
	 * @return object (module information) or false if not created
	 */
	public static function getModule($pk){
		$moduleTable = JTable::getInstance("module");
		$moduleTable->load($pk);
		return $moduleTable;
	}
	
		
	/**
	* ModuleNgehelper::duplicate()
	* 
	* @param mixed $title
	* @return
	*/
	public static function duplicate($mk) {

		$module = self::getModule($mk);
		$module->title = self::alterTitle($module->title);
		//duplicate parts in content if exists
		require_once(JPATH_ROOT.'/components/com_nge/helpers/ngecontenthelper.php');
		$module->content = NgeContentHelper::duplicateParts($module->content);
		$module->ordering = $module->ordering + 1;
		
		// if module is mod_nge, duplicate part
		if($module->module == 'mod_nge') {
			require_once(JPATH_ROOT.'/components/com_nge/helpers/ngeparthelper.php');
			$moduleParams = json_decode($module->params);
			$partId = $moduleParams->id;
			$newPartId = NgePartHelper::duplicate($partId,'','','');
			$moduleParams->id = $newPartId;
			$module->params = json_encode($moduleParams);            
		}
		return self::createModule(JArrayHelper::fromObject($module));
		

/*		
		
		include_once (JPATH_ROOT . '/components/com_nge/models/module.php');
		$model = new NgeModelmodule();
		
		// get module 
		$module = $model->getItem($m_id);
		return '';
		// put module id to 0 => will create new
		$module->id = 0;
       
		// duplicate part in Module content if any
		if($module->content) {
			require_once (JPATH_ROOT . '/components/com_nge/helpers/ngecontenthelper.php');
			$module->content = NgeContentHelper::duplicateParts($module->content);
		}
        
		// if module is mod_nge, duplicate part
		if($module->module == 'mod_nge') {
			require_once(JPATH_ROOT.'/components/com_nge/helpers/ngeparthelper.php');
			$partId = $module->params['id'];
			$newPartId = NgePartHelper::duplicate($partId,'','','');
			$module->params['id'] = $newPartId;            
		}
        
		// Alter the title.
		$module->title = self::alterTitle($module->title);
        
		// save module via Ngemodule model
		$registry = new JRegistry();
		$registry->loadObject($module);
		if($model->save($registry->toArray()) ) {
			$newModuleId = $model->getState('module.id');
			return self::getModule($newModuleId);
		}
		else
			return '';
*/		
	}
	
	/**
	* ModuleNgehelper::move()
	* 
	* @param mixed $title
	* @return
	*/
	public static function move($pk, $newPosition, $previousModulePk=null) {

		$db	= JFactory::getDBO();
		
		$db->setQuery( 'SELECT position FROM #__modules WHERE id=' . (int) $pk);
		$oldPosition =$db->loadResult();	
		
		if ($previousModulePk != null){
			$db->setQuery( 'SELECT ordering FROM #__modules WHERE id=' . (int) $previousModulePk);
			$previousOrdering =$db->loadResult();	
		}else{
			$previousOrdering = 0;
		}
		
		if($oldPosition != $newPosition){
			//Update positions after old module place
			$sql = 'UPDATE #__modules SET ordering = ordering-1 WHERE position = ' . $db->quote($oldPosition) . ' AND ordering > ' . (int) $previousOrdering;
			$db->setQuery($sql);
			$db->execute();
		}
		
		//Update positions after new module place
		$sql = 'UPDATE #__modules SET ordering = ordering+1 WHERE position = ' . $db->quote($newPosition) .' AND ordering > ' . (int) $previousOrdering;
		$db->setQuery($sql);
		$db->execute();
		
		$sql = 'UPDATE #__modules SET position = ' . $db->quote($newPosition) . ', ordering= ' . ((int) $previousOrdering+1) . ' WHERE id = ' . (int) $pk;
		$db->setQuery($sql);
		return $db->execute();

	}
	
	public static function render($pk){
		require_once (JPATH_ROOT . '/components/com_nge/helpers/data/joomla/moduledriver.php');
		return NgeJoomlaModuleDriver::load($pk);
	}
	
	
	    
	public static function titleExists($title) {
		$db	= JFactory::getDBO();
		$db->setQuery( 'SELECT count(*) FROM #__modules WHERE title=' . $db->quote($title)) ;
        
		return $db->loadResult();
	}

	
	/**
     * NgeControllerConfigmodule::alterTitle()
     * 
     * @param mixed $title
     * @return
     */
    private static function alterTitle($title) {

		$m = null;
		if (preg_match('#\((\d+)\)$#', $title, $m))
		{
			$newtitle = preg_replace('#\(\d+\)$#', '(' . ($m[1] + 1) . ')', $title);
		}
		else
		{
			$newtitle = $title.' (2)';
		}
        
        if(self::titleExists($newtitle)) {
            $newtitle = self::alterTitle($newtitle);
        }

        return $newtitle;
    }
	
}