<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

// No direct access.
defined('_JEXEC') or die;

/**
 * Class nge article.
 * @since 1.0
 */
class NgeLibrarygalleryHelper{
		
	public static function getPartsList($partsSelection = array()){
		
		$db = JFactory::getDbo();		
		$query = $db->getQuery(true);
		$user = JFactory::getUser();
		
		$query->select('p.part as name, p.title, p.description, p.demo_link, c.plugin')
			->select('c.id as category_id, c.title as category_title, c.name as category_name, c.plugin as category_plugin')				
			->select('pl.title as plugin_title, pl.ordering as plugin_ordering')				
			->from($db->quoteName('#__nge_parts_library') . ' AS p')
			->join('LEFT', $db->quoteName('#__nge_categories', 'c') .  ' ON (' . $db->quoteName('p.catid') . ' = ' . $db->quoteName('c.id') . ')')
			->join('LEFT', $db->quoteName('#__nge_plugins', 'pl') .  ' ON (' . $db->quoteName('c.plugin') . ' = ' . $db->quoteName('pl.name') . ')')
			->where('p.state=1')
			->where('c.published=1');
		if (count($partsSelection) != 0){
		    for ($i=0;$i<count($partsSelection); $i++)
			$partsSelection[$i] = $db->quote($partsSelection[$i]);
		    $query->where('p.part in (' . implode(',', $partsSelection) . ')');
		}
		//echo $query;
		
		
		//User access
		$groups = implode(',', $user->getAuthorisedViewLevels());
		$query->where('p.access IN (' . $groups . ')');
		$query->where('c.access IN (' . $groups . ')');
		
		$query->order('pl.ordering, pl.title, c.lft, p.ordering');
		//$query->order('pl.ordering, pl.title, c.parent_id, c.lft, c.id, p.ordering');

		$db->setQuery($query);
		$data = $db->loadObjectList();

		//Default order. Standard packs first
		$list = array();
		foreach ($data as $item){	if ($item->plugin =='content' && $item->plugin_ordering == null)	{ $item->plugin_title = 'NGE_CATEGORY_CONTENT_TITLE';	$list[] = $item; }	}
		foreach ($data as $item){	if ($item->plugin =='media' && $item->plugin_ordering == null)		{ $item->plugin_title = 'NGE_CATEGORY_MEDIA_TITLE';	$list[] = $item; }	}
		foreach ($data as $item){	if ($item->plugin =='navigation' && $item->plugin_ordering == null)	{ $item->plugin_title = 'NGE_CATEGORY_NAVIGATION_TITLE';	$list[] = $item; }	}
		foreach ($data as $item){	if ($item->plugin =='office' && $item->plugin_ordering == null)		$list[] = $item;	}
		foreach ($data as $item){	if (!(in_array($item->plugin, array('content','media','navigation','office')) && ($item->plugin_ordering == null)))	$list[] = $item;	}
		return $list;
				
	}
	
	/**
	 * Loading language files for all installed Packs
	 *
	 *
	 */
	public static function loadPacksLanguage(){
		// load pack language file
    	$lang = JFactory::getLanguage();
        $lang->load('com_nge_pack', JPATH_SITE);
        
	 	// get installed plugins
		$db	= JFactory::getDBO();
	 	$sql = "SELECT * FROM #__nge_plugins WHERE type='pack'";
	 	$db->setQuery( $sql) ;
	 	$packs = $db->loadObjectList(  );
	 	
	 	if(count($packs)) {
	     	foreach($packs as $pack) {
	        	$filename = 'com_nge_'.$pack->name;
	         	$lang->load($filename, JPATH_SITE);
	     	}
	 	}	
	}
}