<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

// No direct access.
defined('_JEXEC') or die;

/**
 * class NgeGoogleFont
 *
 */
class NgeGoogleFont {
	protected static $_font_array;
	protected static $_font_weight;
	protected static $_font_italic;
	protected static $_preview_font_array;
	
	/*Set default regular font for display preview in the font selector.
	Can be regular, or nearest */
	static protected function setPreviewFonts(){
		$count = count(self::$_font_array->items);
		for ($i = 0; $i<$count; $i++){
		    if (isset(self::$_font_array->items[$i]->files->regular))
			self::$_font_array->items[$i]->files->preview = self::$_font_array->items[$i]->files->regular;
		    else {
			//Searching nearest regular font
			$nearestWeight = self::getNearestVariant(self::$_font_array->items[$i], 'default', 0);
			self::$_font_array->items[$i]->files->preview = self::$_font_array->items[$i]->files->$nearestWeight;
		    }
		}
	}	
	
	/*Public function*/
	static protected function getPreviewFontArray(){
	    ob_start();
		include NGEPATH_LIBRARIES . '/fonts/google_webfonts.json';
		$font_json_content = ob_get_contents();
		ob_end_clean();
		self::$_font_array 	= json_decode($font_json_content);
		self::setPreviewFonts();
		$previewFonts = array();
		foreach (self::$_font_array->items as $googleFont){
		    $font =new stdClass();
		    $font->family = $googleFont->family;
		    $font->file = $googleFont->files->preview;
		    $previewFonts[] = $font;
		}
		//file_put_contents(NGEPATH_LIBRARIES . '/fonts/google_previewfonts.json', json_encode($previewFonts));
		//return self::$_font_array;
		return $previewFonts;
	}
	
	/*Public function*/
	static public function getFont($font_name, $weight, $italic){
		self::$_font_weight = $weight;
		self::$_font_italic = $italic;
		$res = false;

		if (self::$_font_array == null) {
		      self::getPreviewFontArray();
		}
		$i=0;
		foreach(self::$_font_array->items as $font){
			if($font->family == $font_name){
				$font_object = self::$_font_array->items[$i];
				$res = new stdClass();
				$res->family = $font_object->family;
				$res->variant = self::getNearestVariant($font_object, self::$_font_weight, self::$_font_italic);
				$res->files = $font_object->files;
				break;
			}
			$i++;
		}
		return $res;
	}
	
	/*Public function*/
	static public function getFonts(){
	    
		if (self::$_font_array == null)
		    self::getPreviewFontArray();
	
		return self::$_font_array;
	}
	
	/*Public function*/
	static public function previewFonts(){
	    
	    if (self::$_preview_font_array == null){
		//Loading cache file containing single list of font names
		 $font_json_content = NGE::loadCache('google_previewfonts');
		 if ($font_json_content != false)
		     self::$_preview_font_array = json_decode($font_json_content);
		 else {
		     self::$_preview_font_array = self::getPreviewFontArray();
		     NGE::storeCache(json_encode(self::$_preview_font_array), 'google_previewfonts');		     
		 }
		
	    }
	    return self::$_preview_font_array;
	}	
	
	/*Public function*/
	static protected function getNearestVariant($font_object, $weight, $is_italic){
		$variant = "regular";
		$tmp_font_object = clone $font_object;
		if($is_italic == 1){
			foreach($tmp_font_object->variants as $key => $variant){
				if(!strstr($variant, "italic")) {
					unset($tmp_font_object->variants[$key]);
				}
			}
		}else{
			foreach($tmp_font_object->variants as $key => $variant){
				if(strstr($variant, "italic")) {
					unset($tmp_font_object->variants[$key]);
				}
			}
		}
		switch ($weight) {
			case "bolder":
				foreach($tmp_font_object->variants as $key => $variant){
					if(!strstr($variant, "500") && !strstr($variant, "600") && !strstr($variant, "700")
							&& !strstr($variant, "800") && !strstr($variant, "900")) {
						unset($tmp_font_object->variants[$key]);
					}
				}
				
				if(empty($tmp_font_object->variants)){
					if($is_italic == 1){
						if(in_array('italic', $font_object->variants)){
							$variant = "italic";
						}else{
							$variant = "regular";
						}
					}else{
						$variant = "regular";
					}
				}else{
					$variant = end($tmp_font_object->variants);
				}
			break;
			
			case "bold":
				foreach($tmp_font_object->variants as $key => $variant){
					if(!strstr($variant, "500") && !strstr($variant, "600") && !strstr($variant, "700")) {
						unset($tmp_font_object->variants[$key]);
					}
				}
				
				if(empty($tmp_font_object->variants)){
					if($is_italic == 1){
						if(in_array('italic', $font_object->variants)){
							$variant = "italic";
						}else{
							$variant = "regular";
						}
					}else{
						$variant = "regular";
					}
				}else{
					$variant = end($tmp_font_object->variants);
				}
			break;
			
			case "lighter":
				foreach($tmp_font_object->variants as $key => $variant){
					if(!strstr($variant, "100") && !strstr($variant, "200") && !strstr($variant, "300")) {
						unset($tmp_font_object->variants[$key]);
					}
				}
				
				if(empty($tmp_font_object->variants)){
					if($is_italic == 1){
						if(in_array('italic', $font_object->variants)){
							$variant = "italic";
						}else{
							$variant = "regular";
						}
					}else{
						$variant = "regular";
					}
				}else{
					$variant = reset($tmp_font_object->variants);
				}
			break;
			case "100":
			case "200":
			case "300":
			case "400":
			case "500":
			case "600":
			case "700":
			case "800":
			case "900":			    
				if($is_italic == 1){
						    $variant = $weight . 'italic';
				}else{
				    $variant = $weight;
				}    
			
			default :    //Normal = regular = 400 ou italic
				if($is_italic == 1){
					if(in_array('italic', $font_object->variants)){
						$variant = "italic";
					}else{
						if(in_array('regular', $font_object->variants)){
						    $variant = 'regular';
						}else{
						    if (count($tmp_font_object->variants) > 1)
							$variant = $tmp_font_object->variants[0];
						}
					}
				}else{
				    if(in_array('regular', $font_object->variants)){
						$variant = 'regular';
					}else{
					    if (count($tmp_font_object->variants) > 0)
						$variant = $tmp_font_object->variants[0];
					}
				}    
			break;
		}
		
		return $variant;
	}
}
